/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.service;

import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.PlatformDao;
import com.intel.sensing.fdk.model.entity.PlatformEntity;
import com.intel.sensing.fdk.model.entity.PlatformListEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PlatformService {
    private static PlatformService _instance = null;
    private PlatformListEntity fPlatformList;
    private String fConfigureFilePath;

    public static synchronized PlatformService getInstance() {
        if (_instance == null) {
            _instance = new PlatformService();
            _instance.init();
        }
        return _instance;
    }

    private void init() {
        this.fConfigureFilePath = ManagerFileUtils.getPlatformConfigureFile();
        this.parseConfigureFile();
    }

    public void shutup() {
    }

    public void parseConfigureFile() {
        if (new File(this.fConfigureFilePath).exists()) {
            PlatformDao PlatformDao2 = DaoFactory.getDao(PlatformDao.class);
            try {
                this.fPlatformList = PlatformDao2.getEntityByFilePath(this.fConfigureFilePath);
            }
            catch (ISSException e) {
                ISSLogger.e((Exception)((Object)e));
            }
            if (this.fPlatformList == null || this.fPlatformList.getPlatforms() == null || this.fPlatformList.getPlatforms().isEmpty()) {
                e = new ISSException("Can't get supported platform list.");
                ExceptionHandler.HandleExceptionInSeparateThread((Exception)((Object)e));
            }
        }
    }

    public List<PlatformEntity> getPlatforms() {
        if (this.fPlatformList == null || this.fPlatformList.getPlatforms() == null) {
            return new ArrayList<PlatformEntity>();
        }
        return this.fPlatformList.getPlatforms();
    }

    public PlatformEntity getPlatformByName(String platformName) {
        if (this.fPlatformList == null || this.fPlatformList.getPlatforms() == null) {
            return null;
        }
        return this.fPlatformList.getPlatforms().stream().filter(p -> p.getName().equalsIgnoreCase(platformName)).findFirst().orElse(null);
    }

    public String getPlatformNameByDisplayName(String platformName) {
        if (this.fPlatformList == null || this.fPlatformList.getPlatforms() == null) {
            return platformName;
        }
        PlatformEntity pe = this.fPlatformList.getPlatforms().stream().filter(p -> p.getExternalName().equals(platformName)).findFirst().orElse(null);
        if (pe == null) {
            return platformName;
        }
        return pe.getName();
    }

    public String getPlatformDisplayName(String plat) {
        if (this.fPlatformList == null || this.fPlatformList.getPlatforms() == null) {
            return plat;
        }
        PlatformEntity pe = this.fPlatformList.getPlatforms().stream().filter(p -> p.getName().equals(plat)).findFirst().orElse(null);
        if (pe == null) {
            return plat;
        }
        return pe.getExternalName();
    }

    public boolean supportPlaform(String name) {
        if (this.fPlatformList == null || this.fPlatformList.getPlatforms() == null) {
            return false;
        }
        return this.fPlatformList.getPlatforms().parallelStream().anyMatch(pe -> pe.getName().equalsIgnoreCase(name) && !pe.isDeprecated());
    }

    public List<String> getSupportPlatforms() {
        if (this.fPlatformList == null || this.fPlatformList.getPlatforms() == null) {
            return new ArrayList<String>();
        }
        return this.fPlatformList.getPlatforms().stream().map(pe -> {
            if (pe.isDeprecated()) {
                return null;
            }
            return pe.getName();
        }).filter(s -> s != null).collect(Collectors.toList());
    }
}

