/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.payloads.calibrations.AgmVirtualCalibrationPayload;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualAcclCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualGyroCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualMagCalibrationPayload;
import resources.CustomSpinner;

public class AgmVirtualCalibrationEditor
implements CalibrationEditor {
    private static final int ANGLE_MAXIMAL_VALUE = 360;
    private static final int FREQUENCY_MINIMAL_VALUE = 1;
    private static final int FREQUENCY_MAXIMAL_VALUE = 255;
    private static final int FREQUENCY_DEFAULT_VALUE = 10;
    private static final int WAIT_FOR_MOTIONLESS_MINIMAL_VALUE = 5;
    private static final int WAIT_FOR_MOTIONLESS_MAXIMAL_VALUE = 20;
    private static final int WAIT_FOR_MOTIONLESS_DEFAULT_VALUE = 5;
    private static final int DURATION_MINIMAL_VALUE = 5;
    private static final int DURATION_MAXIMAL_VALUE = 100;
    private static final int DURATION_DEFAULT_VALUE = 20;
    private static final int RETRY_MINIMAL_VALUE = 0;
    private static final int RETRY_MAXIMAL_VALUE = 255;
    private static final int RETRY_DEFAULT_VALUE = 100;
    protected Shell shlEditCalibration;
    private Text formatID;
    private Display display;
    private int _dataType;
    private CalibrationEditorOpener _parent = null;
    private Sensor _sensor = null;
    private boolean _modified = false;
    private AgmVirtualCalibrationPayload _data = null;
    private Label vesrionLabel;
    private CustomSpinner spnVersion;
    private String _givenFormatId;
    private Button btnSave;
    private Button btnCancel;
    private Group grpData;
    private Label lblLidAngle;
    private CustomSpinner spnAngle;
    private Button chbBaseSensor;
    private Group grpCalibration;
    private Button chbPeriodicallyCalibration;
    private Label lblFrequency;
    private Label lblWaitForMotionless;
    private Label lblDuration;
    private Label lblRetry;
    private CustomSpinner spnFrequency;
    private CustomSpinner spnWaitForMotionless;
    private CustomSpinner spnDuration;
    private CustomSpinner spnRetry;
    private Label lblFrequencyPostfix;
    private Label lblWaitForMotionlessPostfix;
    private Label lblDurationPostfix;
    private Label lblRetryPostfix;

    public static void main(String[] args) {
        try {
            AgmVirtualCalibrationEditor window = new AgmVirtualCalibrationEditor(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AgmVirtualCalibrationEditor(CalibrationEditorOpener parent, AgmVirtualCalibrationPayload data, Sensor sensor) {
        if (data == null) {
            throw new UnsupportedOperationException("Wrong usage of constructor. For null payload use the other constructor.");
        }
        this._parent = parent;
        this._data = data;
        this._sensor = sensor;
    }

    public AgmVirtualCalibrationEditor(CalibrationEditorOpener parent, int dataType, Sensor sensor) {
        this._parent = parent;
        this._dataType = dataType;
        this._sensor = sensor;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditCalibration.open();
        this.shlEditCalibration.layout();
        while (!this.shlEditCalibration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    @Override
    public String getCalibrationFormatName() {
        if (this._data != null) {
            return this._data.getCalibrationDataString();
        }
        switch (this._dataType) {
            case 2: {
                return "Calibrated Accelerometer Calibration";
            }
            case 3: {
                return "Calibrated Gyrometer Calibration";
            }
            case 4: {
                return "Calibrated Magnetometer Calibration";
            }
        }
        return "Virtual AGM Calibration";
    }

    public void saveData() {
        boolean newCalibration = false;
        AgmVirtualCalibrationPayload data = this._data;
        if (data == null) {
            switch (this._dataType) {
                case 2: {
                    data = new VirtualAcclCalibrationPayload();
                    break;
                }
                case 3: {
                    data = new VirtualGyroCalibrationPayload();
                    break;
                }
                case 4: {
                    data = new VirtualMagCalibrationPayload();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized calibration data type.");
                }
            }
            newCalibration = true;
        }
        data.setFormatID(Integer.valueOf(this.formatID.getText()));
        data.setVersion(this.spnVersion.getSelection());
        data.setSensorInBase(this.chbBaseSensor.getSelection());
        data.setLidAngle(this.spnAngle.getSelection());
        if (data instanceof VirtualGyroCalibrationPayload) {
            ((VirtualGyroCalibrationPayload)data).setPeriodicallyCalibration(this.chbPeriodicallyCalibration.getSelection());
            ((VirtualGyroCalibrationPayload)data).setFrequency(this.spnFrequency.getSelection());
            ((VirtualGyroCalibrationPayload)data).setWaitForMotionless(this.spnWaitForMotionless.getSelection());
            ((VirtualGyroCalibrationPayload)data).setDuration(this.spnDuration.getSelection());
            ((VirtualGyroCalibrationPayload)data).setRetry(this.spnRetry.getSelection());
        }
        if (newCalibration) {
            this._parent.addNewCalibration(this._sensor, data);
        }
        this._data = data;
        this._modified = false;
        this._parent.setModified();
        this._parent.refreshCalibrationData();
        this.shlEditCalibration.close();
    }

    public void fillData() {
        if (this._data == null) {
            switch (this._dataType) {
                case 2: {
                    this.formatID.setText(String.valueOf(1));
                    break;
                }
                case 3: {
                    this.formatID.setText(String.valueOf(2));
                    ((GridData)this.grpCalibration.getLayoutData()).exclude = false;
                    this.grpCalibration.setVisible(true);
                    this.shlEditCalibration.setSize(this.shlEditCalibration.computeSize(-1, -1));
                    break;
                }
                case 4: {
                    this.formatID.setText(String.valueOf(1));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized calibration data type.");
                }
            }
            this.spnVersion.setSelection(0);
            this._modified = false;
            return;
        }
        this.formatID.setText(String.valueOf(this._data.getFormatID()));
        this._givenFormatId = String.valueOf(this._data.getFormatID());
        this.spnVersion.setSelection(this._data.getVersion());
        this.chbBaseSensor.setSelection(this._data.getSensorInBase());
        this.spnAngle.setSelection(this._data.getLidAngle());
        if (this._data instanceof VirtualGyroCalibrationPayload) {
            ((GridData)this.grpCalibration.getLayoutData()).exclude = false;
            this.grpCalibration.setVisible(true);
            this.shlEditCalibration.setSize(this.shlEditCalibration.computeSize(-1, -1));
            this.chbPeriodicallyCalibration.setSelection(((VirtualGyroCalibrationPayload)this._data).getPeriodicallyCalibration());
            this.spnFrequency.setSelection(((VirtualGyroCalibrationPayload)this._data).getFrequency());
            this.spnWaitForMotionless.setSelection(((VirtualGyroCalibrationPayload)this._data).getWaitForMotionless());
            this.spnDuration.setSelection(((VirtualGyroCalibrationPayload)this._data).getDuration());
            this.spnRetry.setSelection(((VirtualGyroCalibrationPayload)this._data).getRetry());
        }
        this.setFiledsAvalibility();
        this._modified = false;
    }

    public void setFiledsAvalibility() {
        this.spnAngle.setEnabled(this.chbBaseSensor.getSelection());
        this.lblLidAngle.setEnabled(this.chbBaseSensor.getSelection());
        this.lblFrequency.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.spnFrequency.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.lblFrequencyPostfix.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.lblWaitForMotionless.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.spnWaitForMotionless.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.lblWaitForMotionlessPostfix.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.lblDuration.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.spnDuration.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.lblDurationPostfix.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.lblRetry.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.spnRetry.setEnabled(this.chbPeriodicallyCalibration.getSelection());
        this.lblRetryPostfix.setEnabled(this.chbPeriodicallyCalibration.getSelection());
    }

    protected void createContents() {
        this.shlEditCalibration = new Shell(65760);
        this.shlEditCalibration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (AgmVirtualCalibrationEditor.this._modified) {
                    MessageBox messageBox = new MessageBox(AgmVirtualCalibrationEditor.this.shlEditCalibration, 296);
                    messageBox.setText("Closing The 'Edit Calibration' Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the 'Calibration Modifier' window?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditCalibration.setImage(SWTResourceManager.getImage(AgmVirtualCalibrationEditor.class, "/resources/Intel.ico"));
        this.shlEditCalibration.setText("Calibration Modifier");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditCalibration, 1);
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shlEditCalibration, 0, 4, 128, true, false, 1, 1, 2);
        GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.formatID = GuiUtils.addTextToComposite((Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.vesrionLabel = GuiUtils.addLabelToComposite("Calibration Version:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnVersion = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.VERSION_MAX_VALUE, this.shlEditCalibration, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.grpData = GuiUtils.addGroupToComposite("Data", (Composite)this.shlEditCalibration, 0, 4, 128, true, false, 1, 1, 3);
        this.chbBaseSensor = GuiUtils.addButtonToComposite("Sensor in Base", "", (Composite)this.grpData, 32, 16384, 0x1000000, true, false, 3, 1);
        GuiUtils.addLabelToComposite("    ", (Composite)this.grpData, 0, 16384, 0x1000000, false, false, 1, 1);
        this.lblLidAngle = GuiUtils.addLabelToComposite("Fixed Lid Orientation (degrees):", (Composite)this.grpData, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnAngle = GuiUtils.addCustomSpinnerToComposite(360, this.shlEditCalibration, (Composite)this.grpData, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.grpCalibration = GuiUtils.addGroupToComposite("Calibration", (Composite)this.shlEditCalibration, 0, 4, 128, true, false, 1, 1, 1);
        this.chbPeriodicallyCalibration = GuiUtils.addButtonToComposite("Periodically calibrate while not in use", "Periodically turn on the gyrometer just to calibrate it.\n(Gyrometers need frequent calibration, but the device must be motionless \u2013 which is rare if the device is in use.)", (Composite)this.grpCalibration, 32, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeFrequency = GuiUtils.addCompositeToComposite((Composite)this.grpCalibration, 0, 16384, 0x1000000, false, false, 1, 1, 4);
        GuiUtils.addLabelToComposite("    ", compositeFrequency, 0, 16384, 0x1000000, false, false, 1, 1);
        this.lblFrequency = GuiUtils.addLabelToComposite("Activate gyrometer once every", compositeFrequency, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnFrequency = GuiUtils.addCustomSpinnerToComposite(255, this.shlEditCalibration, compositeFrequency, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.lblFrequencyPostfix = GuiUtils.addLabelToComposite("hours.", compositeFrequency, 0, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeWaitForMotionless = GuiUtils.addCompositeToComposite((Composite)this.grpCalibration, 0, 16384, 0x1000000, false, false, 1, 1, 4);
        GuiUtils.addLabelToComposite("    ", compositeWaitForMotionless, 0, 16384, 0x1000000, false, false, 1, 1);
        this.lblWaitForMotionless = GuiUtils.addLabelToComposite("Check if the device is motionless for ", compositeWaitForMotionless, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnWaitForMotionless = GuiUtils.addCustomSpinnerToComposite(20, this.shlEditCalibration, compositeWaitForMotionless, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.lblWaitForMotionlessPostfix = GuiUtils.addLabelToComposite("seconds, then calibrate.", compositeWaitForMotionless, 0, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeRetry = GuiUtils.addCompositeToComposite((Composite)this.grpCalibration, 0, 16384, 0x1000000, false, false, 1, 1, 4);
        GuiUtils.addLabelToComposite("    ", compositeRetry, 0, 16384, 0x1000000, false, false, 1, 1);
        this.lblRetry = GuiUtils.addLabelToComposite("(If not motionless, try again every", compositeRetry, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnRetry = GuiUtils.addCustomSpinnerToComposite(255, this.shlEditCalibration, compositeRetry, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.lblRetryPostfix = GuiUtils.addLabelToComposite("minutes or so.)", compositeRetry, 0, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeDuration = GuiUtils.addCompositeToComposite((Composite)this.grpCalibration, 0, 16384, 0x1000000, false, false, 1, 1, 4);
        GuiUtils.addLabelToComposite("    ", compositeDuration, 0, 16384, 0x1000000, false, false, 1, 1);
        this.lblDuration = GuiUtils.addLabelToComposite("Calibrate for", compositeDuration, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnDuration = GuiUtils.addCustomSpinnerToComposite(100, this.shlEditCalibration, compositeDuration, 2048, 16384, 0x1000000, true, false, 1, 1);
        this.lblDurationPostfix = GuiUtils.addLabelToComposite("seconds, then deactivate gyrometer.", compositeDuration, 0, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlEditCalibration, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.formatID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
            }
        });
        this.spnVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
            }
        });
        this.chbBaseSensor.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
                AgmVirtualCalibrationEditor.this.setFiledsAvalibility();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
                AgmVirtualCalibrationEditor.this.setFiledsAvalibility();
            }
        });
        this.spnAngle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
            }
        });
        this.chbPeriodicallyCalibration.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
                AgmVirtualCalibrationEditor.this.setFiledsAvalibility();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
                AgmVirtualCalibrationEditor.this.setFiledsAvalibility();
            }
        });
        this.spnFrequency.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
            }
        });
        this.spnWaitForMotionless.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
            }
        });
        this.spnDuration.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
            }
        });
        this.spnRetry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AgmVirtualCalibrationEditor.this._modified = true;
            }
        });
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgmVirtualCalibrationEditor.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgmVirtualCalibrationEditor.this.shlEditCalibration.close();
            }
        });
        this.lblFrequencyPostfix.setToolTipText("Decide how often to turn on the gyrometer and attempt a calibration. ");
        this.lblFrequency.setToolTipText("Decide how often to turn on the gyrometer and attempt a calibration. ");
        this.spnFrequency.setToolTipText("Decide how often to turn on the gyrometer and attempt a calibration. ");
        this.lblWaitForMotionless.setToolTipText("Decide how long to watch the INTEL_ORIENTATION_DEVICE_MOVEMENT sensor before beginning calibration.");
        this.spnWaitForMotionless.setToolTipText("Decide how long to watch the INTEL_ORIENTATION_DEVICE_MOVEMENT sensor before beginning calibration.");
        this.lblWaitForMotionlessPostfix.setToolTipText("Decide how long to watch the INTEL_ORIENTATION_DEVICE_MOVEMENT sensor before beginning calibration.");
        this.lblDuration.setToolTipText("Decide how long to continuously calibrate the sensor before deactivating it again.");
        this.spnDuration.setToolTipText("Decide how long to continuously calibrate the sensor before deactivating it again.");
        this.lblDurationPostfix.setToolTipText("Decide how long to continuously calibrate the sensor before deactivating it again.");
        this.lblRetry.setToolTipText("If the device is moving, decide how long it will wait before trying again. This waiting period is slightly randomized.");
        this.spnRetry.setToolTipText("If the device is moving, decide how long it will wait before trying again. This waiting period is slightly randomized.");
        this.lblRetryPostfix.setToolTipText("If the device is moving, decide how long it will wait before trying again. This waiting period is slightly randomized.");
        this.chbPeriodicallyCalibration.setSelection(true);
        this.spnFrequency.setMinimum(1);
        this.spnFrequency.setSelection(10);
        this.spnWaitForMotionless.setMinimum(5);
        this.spnWaitForMotionless.setSelection(5);
        this.spnDuration.setMinimum(5);
        this.spnDuration.setSelection(20);
        this.spnRetry.setMinimum(0);
        this.spnRetry.setSelection(100);
        this.formatID.setEnabled(false);
        this.lblLidAngle.setEnabled(false);
        this.spnAngle.setEnabled(false);
        this.spnFrequency.setEnabled(true);
        this.spnWaitForMotionless.setEnabled(true);
        this.spnDuration.setEnabled(true);
        this.spnRetry.setEnabled(true);
        ((GridLayout)this.grpCalibration.getLayout()).verticalSpacing = 0;
        ((GridLayout)compositeFrequency.getLayout()).marginHeight = 2;
        ((GridLayout)compositeWaitForMotionless.getLayout()).marginHeight = 2;
        ((GridLayout)compositeRetry.getLayout()).marginHeight = 2;
        ((GridLayout)compositeDuration.getLayout()).marginHeight = 2;
        ((GridLayout)compositeShellButton.getLayout()).marginHeight = 1;
        ((GridLayout)compositeShellButton.getLayout()).marginWidth = 0;
        int longSpinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 1.5);
        int shortSpinnerMinWidth = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        int longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 1.5);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        ((GridData)this.spnVersion.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnAngle.getLayoutData()).minimumWidth = longSpinnerMinWidth;
        ((GridData)this.spnFrequency.getLayoutData()).minimumWidth = shortSpinnerMinWidth;
        ((GridData)this.spnWaitForMotionless.getLayoutData()).minimumWidth = shortSpinnerMinWidth;
        ((GridData)this.spnDuration.getLayoutData()).minimumWidth = shortSpinnerMinWidth;
        ((GridData)this.spnRetry.getLayoutData()).minimumWidth = shortSpinnerMinWidth;
        ((GridData)btnSave.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.grpCalibration.getLayoutData()).exclude = true;
        this.grpCalibration.setVisible(false);
        this.shlEditCalibration.setSize(this.shlEditCalibration.computeSize(-1, -1));
        this.shlEditCalibration.setLocation(GuiUtils.getMiddleLocation(this.shlEditCalibration, this.display));
    }
}

