/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.calibrations.AgmVirtualCalibrationPayload;
import pdtEditor.validation.Validator;

public class VirtualGyroCalibrationPayload
extends AgmVirtualCalibrationPayload {
    public static final int CALIBRATION_TYPE = 3;
    public static final String CALIBRATION_FORMAT_STRING = "Calibrated Gyrometer Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    public static final int LATEST_FORMAT_ID = 2;
    public static final int MINIMAL_PDT_FORMAT_VERSION = 4;
    private static final int NOISE_DEFAULT_VALUE = 5000;
    private static final int CALIBRATION_SELECT_MASK_DEFAULT_VALUE = 255;
    private static final int SCALE_FACTOR_DEFAULT_VALUE = 1;
    private static final int[] OFFSET_DEFAULT_VALUE = new int[]{0, 0, 0};
    private static final int[] SCALE_DEFAULT_VALUE = new int[]{1, 1, 1};
    private static final int[] A0_DEFAULT_VALUE = new int[]{0, 0, 0};
    private static final int[] A1_DEFAULT_VALUE = new int[]{0, 0, 0};
    private static final int[] B0_DEFAULT_VALUE = new int[]{0, 0, 0};
    private static final int[] B1_DEFAULT_VALUE = new int[]{0, 0, 0};
    private int _formatID = 2;
    private int _version;
    private int _sensorInBase;
    private int _lidAngle;
    private int _periodicallyCalibration = 1;
    private int _frequency = 10;
    private int _waitForMotionless = 5;
    private int _duration = 20;
    private int _retry = 100;
    private int _noise = 5000;

    public VirtualGyroCalibrationPayload() {
    }

    public VirtualGyroCalibrationPayload(VirtualGyroCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._sensorInBase = other._sensorInBase;
        this._lidAngle = other._lidAngle;
        this._periodicallyCalibration = other._periodicallyCalibration;
        this._frequency = other._frequency;
        this._waitForMotionless = other._waitForMotionless;
        this._duration = other._duration;
        this._retry = other._retry;
        this._noise = other._noise;
    }

    public VirtualGyroCalibrationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this.checkPdtFormat();
        this._formatID = formatId;
        if (this._formatID > 2) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element virtualGyroCalibration = reader.readNewField((String)"VirtualGyroCalibration", (Node)payloadXmlNode).xmlElement;
        this._noise = reader.readNewField((String)"Noise", (int)4, (boolean)false, (Node)virtualGyroCalibration).value;
        this._sensorInBase = reader.readNewField((String)"SensorInBase", (int)1, (boolean)false, (Node)virtualGyroCalibration).value;
        this._lidAngle = reader.readNewField((String)"LidAngle", (int)2, (boolean)false, (Node)virtualGyroCalibration).value;
        if (this._formatID >= 2) {
            this._periodicallyCalibration = reader.readNewField((String)"PeriodicallyCalibration", (int)1, (boolean)false, (Node)virtualGyroCalibration).value;
            this._frequency = reader.readNewField((String)"PeriodicallyCalibrationFrequency", (int)1, (boolean)false, (Node)virtualGyroCalibration).value;
            this._waitForMotionless = reader.readNewField((String)"PeriodicallyCalibrationWaitForMotionless", (int)1, (boolean)false, (Node)virtualGyroCalibration).value;
            this._duration = reader.readNewField((String)"PeriodicallyCalibrationDuration", (int)1, (boolean)false, (Node)virtualGyroCalibration).value;
            this._retry = reader.readNewField((String)"PeriodicallyCalibrationRetry", (int)1, (boolean)false, (Node)virtualGyroCalibration).value;
        } else {
            this._formatID = 2;
        }
        reader.readNewField("CalibrationSelectMask", 1, false, virtualGyroCalibration);
        reader.readNewField("ScaleFactor", 2, false, virtualGyroCalibration);
        reader.readNewField("OffsetX", 4, false, virtualGyroCalibration);
        reader.readNewField("OffsetY", 4, false, virtualGyroCalibration);
        reader.readNewField("OffsetZ", 4, false, virtualGyroCalibration);
        reader.readNewField("ScaleX", 2, false, virtualGyroCalibration);
        reader.readNewField("ScaleY", 2, false, virtualGyroCalibration);
        reader.readNewField("ScaleZ", 2, false, virtualGyroCalibration);
        reader.readNewField("A0X", 2, false, virtualGyroCalibration);
        reader.readNewField("A0Y", 2, false, virtualGyroCalibration);
        reader.readNewField("A0Z", 2, false, virtualGyroCalibration);
        reader.readNewField("A1X", 2, false, virtualGyroCalibration);
        reader.readNewField("A1Y", 2, false, virtualGyroCalibration);
        reader.readNewField("A1Z", 2, false, virtualGyroCalibration);
        reader.readNewField("B0X", 4, false, virtualGyroCalibration);
        reader.readNewField("B0Y", 4, false, virtualGyroCalibration);
        reader.readNewField("B0Z", 4, false, virtualGyroCalibration);
        reader.readNewField("B1X", 4, false, virtualGyroCalibration);
        reader.readNewField("B1Y", 4, false, virtualGyroCalibration);
        reader.readNewField("B1Z", 4, false, virtualGyroCalibration);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof VirtualGyroCalibrationPayload)) {
            return false;
        }
        VirtualGyroCalibrationPayload other = (VirtualGyroCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._sensorInBase == other._sensorInBase && this._lidAngle == other._lidAngle && this._periodicallyCalibration == other._periodicallyCalibration && this._frequency == other._frequency && this._waitForMotionless == other._waitForMotionless && this._duration == other._duration && this._retry == other._retry && this._noise == other._noise;
    }

    @Override
    public VirtualGyroCalibrationPayload clone() {
        return new VirtualGyroCalibrationPayload(this);
    }

    private void checkPdtFormat() {
        if (DataStore.getInstance().getPdtFormatVersion() < 4) {
            throw new UnsupportedOperationException("The 'Calibrated Gyrometer Calibration' calibration is supported in PDT format version 4 and above.");
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element virtualGyroCalibration = writer.writeNewField((String)"VirtualGyroCalibration", (Node)parent).xmlElement;
        writer.writeNewField("Noise", 4, this._noise, (Node)virtualGyroCalibration);
        writer.writeNewField("SensorInBase", 1, this._sensorInBase, (Node)virtualGyroCalibration);
        writer.writeNewField("LidAngle", 2, this._lidAngle, (Node)virtualGyroCalibration);
        writer.writeNewField("PeriodicallyCalibration", 1, this._periodicallyCalibration, (Node)virtualGyroCalibration);
        writer.writeNewField("PeriodicallyCalibrationFrequency", 1, this._frequency, (Node)virtualGyroCalibration);
        writer.writeNewField("PeriodicallyCalibrationWaitForMotionless", 1, this._waitForMotionless, (Node)virtualGyroCalibration);
        writer.writeNewField("PeriodicallyCalibrationDuration", 1, this._duration, (Node)virtualGyroCalibration);
        writer.writeNewField("PeriodicallyCalibrationRetry", 1, this._retry, (Node)virtualGyroCalibration);
        writer.writeNewField("CalibrationSelectMask", 1, 255, (Node)virtualGyroCalibration);
        writer.writeNewField("ScaleFactor", 2, 1, (Node)virtualGyroCalibration);
        writer.writeNewField("OffsetX", 4, OFFSET_DEFAULT_VALUE[0], (Node)virtualGyroCalibration);
        writer.writeNewField("OffsetY", 4, OFFSET_DEFAULT_VALUE[1], (Node)virtualGyroCalibration);
        writer.writeNewField("OffsetZ", 4, OFFSET_DEFAULT_VALUE[2], (Node)virtualGyroCalibration);
        writer.writeNewField("ScaleX", 2, SCALE_DEFAULT_VALUE[0], (Node)virtualGyroCalibration);
        writer.writeNewField("ScaleY", 2, SCALE_DEFAULT_VALUE[1], (Node)virtualGyroCalibration);
        writer.writeNewField("ScaleZ", 2, SCALE_DEFAULT_VALUE[2], (Node)virtualGyroCalibration);
        writer.writeNewField("A0X", 2, A0_DEFAULT_VALUE[0], (Node)virtualGyroCalibration);
        writer.writeNewField("A0Y", 2, A0_DEFAULT_VALUE[1], (Node)virtualGyroCalibration);
        writer.writeNewField("A0Z", 2, A0_DEFAULT_VALUE[2], (Node)virtualGyroCalibration);
        writer.writeNewField("A1X", 2, A1_DEFAULT_VALUE[0], (Node)virtualGyroCalibration);
        writer.writeNewField("A1Y", 2, A1_DEFAULT_VALUE[1], (Node)virtualGyroCalibration);
        writer.writeNewField("A1Z", 2, A1_DEFAULT_VALUE[2], (Node)virtualGyroCalibration);
        writer.writeNewField("B0X", 4, B0_DEFAULT_VALUE[0], (Node)virtualGyroCalibration);
        writer.writeNewField("B0Y", 4, B0_DEFAULT_VALUE[1], (Node)virtualGyroCalibration);
        writer.writeNewField("B0Z", 4, B0_DEFAULT_VALUE[2], (Node)virtualGyroCalibration);
        writer.writeNewField("B1X", 4, B1_DEFAULT_VALUE[0], (Node)virtualGyroCalibration);
        writer.writeNewField("B1Y", 4, B1_DEFAULT_VALUE[1], (Node)virtualGyroCalibration);
        writer.writeNewField("B1Z", 4, B1_DEFAULT_VALUE[2], (Node)virtualGyroCalibration);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    @Override
    public int getFormatID() {
        return this._formatID;
    }

    @Override
    public void setFormatID(int formatID) {
        this._formatID = formatID;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public boolean getSensorInBase() {
        return this._sensorInBase == 1;
    }

    @Override
    public void setSensorInBase(boolean sensorInBase) {
        this._sensorInBase = sensorInBase ? 1 : 0;
    }

    @Override
    public int getLidAngle() {
        return this._lidAngle;
    }

    @Override
    public void setLidAngle(int lidAngle) {
        this._lidAngle = lidAngle;
    }

    public boolean getPeriodicallyCalibration() {
        return this._periodicallyCalibration == 1;
    }

    public void setPeriodicallyCalibration(boolean periodicallyCalibration) {
        this._periodicallyCalibration = periodicallyCalibration ? 1 : 0;
    }

    public int getFrequency() {
        return this._frequency;
    }

    public void setFrequency(int frequency) {
        this._frequency = frequency;
    }

    public int getWaitForMotionless() {
        return this._waitForMotionless;
    }

    public void setWaitForMotionless(int waitForMotionless) {
        this._waitForMotionless = waitForMotionless;
    }

    public int getDuration() {
        return this._duration;
    }

    public void setDuration(int duration) {
        this._duration = duration;
    }

    public int getRetry() {
        return this._retry;
    }

    public void setRetry(int retry) {
        this._retry = retry;
    }

    @Override
    public void setWhiteNoise(int whiteNoise) {
        this._noise = whiteNoise;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }
}

