/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class FaceDetectionConfigurationPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 109;
    public static final String CONFIGURATION_FORMAT_STRING = "Face Detection Configuration";
    public static final int NO_FACE_TO_WOM_TIME_SIZE = 2;
    public static final int EVENT_FILTERING_THRESHOLD_SIZE = 2;
    public static final int OBSTRUCTION_ALS_THRESHOLD_SIZE = 4;
    public static final int NO_FACE_TO_WOM_TIME_DEFAULT_VALUE = 15000;
    public static final int EVENT_FILTERING_THRESHOLD_DEFAULT_VALUE = 5;
    public static final int OBSTRUCTION_ALS_THRESHOLD_DEFAULT_VALUE = 10;
    private static final int LATEST_FORMAT_ID = 0;
    private int _formatID = 0;
    private int _version;
    public int noFaceToWomTime;
    public int eventFilteringThreshold;
    public int obstructionAlsThreshold;

    public FaceDetectionConfigurationPayload() {
    }

    public FaceDetectionConfigurationPayload(FaceDetectionConfigurationPayload src) {
        this.noFaceToWomTime = src.noFaceToWomTime;
        this.eventFilteringThreshold = src.eventFilteringThreshold;
        this.obstructionAlsThreshold = src.obstructionAlsThreshold;
    }

    public FaceDetectionConfigurationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"FaceDetectionConfiguration", (Node)payloadXmlNode).xmlElement;
        this.noFaceToWomTime = reader.readNewField((String)"NoFaceToWomTime", (int)2, (boolean)false, (Node)configurationElement).value;
        this.eventFilteringThreshold = reader.readNewField((String)"EventFilteringThreshold", (int)2, (boolean)false, (Node)configurationElement).value;
        this.obstructionAlsThreshold = reader.readNewField((String)"ObstructionAlsThreshold", (int)4, (boolean)false, (Node)configurationElement).value;
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element rootElement = writer.writeNewField((String)"FaceDetectionConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("NoFaceToWomTime", 2, this.noFaceToWomTime, (Node)rootElement);
        writer.writeNewField("EventFilteringThreshold", 2, this.eventFilteringThreshold, (Node)rootElement);
        writer.writeNewField("ObstructionAlsThreshold", 4, this.obstructionAlsThreshold, (Node)rootElement);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public ConfigurationPayload clone() {
        return new FaceDetectionConfigurationPayload(this);
    }

    @Override
    public String getConfigurationFormatString() {
        return CONFIGURATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }
}

