/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.I2cBoardDescriptionTable;
import pdtEditor.IMainWindow;
import pdtEditor.gui.GuiUtils;
import resources.CustomSpinner;

public class BoardDescriptionTableEditor {
    private DataStore _dataStore;
    private boolean _modified = false;
    private boolean _busModified = true;
    private ArrayList<I2cBoardDescriptionTable.BusObject> _busObjects = new ArrayList();
    protected Shell shlIc;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Table table;
    private Display display;
    private CustomSpinner spnBusInstance;
    private CustomSpinner spnStdHct;
    private CustomSpinner spnStdLct;
    private CustomSpinner spnStdHold;
    private CustomSpinner spnFastHct;
    private CustomSpinner spnFastLct;
    private CustomSpinner spnFastHold;
    private CustomSpinner spnHighHct;
    private CustomSpinner spnHighLct;
    private CustomSpinner spnHighHold;
    private Group grpNote;
    private Group grpSelectedBusInformation;
    private I2cBoardDescriptionTable _i2cBdt;
    private Button btnDelete;
    private Button btnAdd;
    private Button btnOk;
    private Button btnCancel_1;
    private Label lblChooseOrAdd;
    private IMainWindow _parent;

    public static void main(String[] args) {
        try {
            BoardDescriptionTableEditor window = new BoardDescriptionTableEditor(null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BoardDescriptionTableEditor(DataStore dataStore, IMainWindow parent) {
        this._dataStore = dataStore;
        this._parent = parent;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlIc.open();
        this.shlIc.layout();
        while (!this.shlIc.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        this.setModifierVisiblity();
        if (this._dataStore == null) {
            this.lblChooseOrAdd.setText("Add a bus instance to the list");
            return;
        }
        I2cBoardDescriptionTable i2cBdt = this._dataStore.getCurrentPdtFile().getI2cBdt();
        if (i2cBdt == null) {
            i2cBdt = new I2cBoardDescriptionTable();
        }
        this._i2cBdt = i2cBdt;
        this._busObjects = this._i2cBdt.getBuses();
        this.refresh();
        this.setBusModified(false);
        this._modified = false;
    }

    public void saveBus() {
        boolean newBus = false;
        I2cBoardDescriptionTable.BusObject bus = null;
        if (this.table.getSelectionIndex() >= 0) {
            bus = this._busObjects.get(this.table.getSelectionIndex());
        }
        if (bus == null) {
            bus = new I2cBoardDescriptionTable.BusObject();
            newBus = true;
        }
        for (I2cBoardDescriptionTable.BusObject otherBus : this._busObjects) {
            if (otherBus.equals(bus) || this.spnBusInstance.getSelection() != otherBus.instanceId) continue;
            MessageBox messageBox = new MessageBox(this.shlIc, 513);
            messageBox.setText("Invalid Bus Instance");
            messageBox.setMessage("The instance ID already exists. You cannot create 2 buses with the same instance ID.");
            messageBox.open();
            return;
        }
        bus.instanceId = this.spnBusInstance.getSelection();
        bus.sdtSpeedHcnt = this.spnStdHct.getSelection();
        bus.stdSpeedLcnt = this.spnStdLct.getSelection();
        bus.stdSpeedSdaHold = this.spnStdHold.getSelection();
        bus.fastSpeedHcnt = this.spnFastHct.getSelection();
        bus.fastSpeedLcnt = this.spnFastLct.getSelection();
        bus.fastSpeedSdaHold = this.spnFastHold.getSelection();
        bus.highSpeedHcnt = this.spnHighHct.getSelection();
        bus.highSpeedLcnt = this.spnHighLct.getSelection();
        bus.highSpeedSdaHold = this.spnHighHold.getSelection();
        if (newBus) {
            this._busObjects.add(bus);
        }
        this.refresh();
        this.setModifierVisiblity(false);
    }

    public void refresh() {
        this.table.removeAll();
        this.btnDelete.setEnabled(false);
        for (I2cBoardDescriptionTable.BusObject bus : this._busObjects) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{String.valueOf(bus.instanceId)});
        }
        if (this._busObjects.size() > 0) {
            this.lblChooseOrAdd.setText("Choose a bus instance from the list");
        } else {
            this.lblChooseOrAdd.setText("Add a bus instance to the list");
        }
    }

    public void addNewBus() {
        int i = 0;
        while (true) {
            boolean skipCurr = false;
            for (I2cBoardDescriptionTable.BusObject bus : this._busObjects) {
                if (bus.instanceId != i) continue;
                skipCurr = true;
                break;
            }
            if (!skipCurr) break;
            ++i;
        }
        this.spnBusInstance.setSelection(i);
        this.spnStdHct.setSelection(0);
        this.spnStdLct.setSelection(0);
        this.spnStdHold.setSelection(0);
        this.spnFastHct.setSelection(0);
        this.spnFastLct.setSelection(0);
        this.spnFastHold.setSelection(0);
        this.spnHighHct.setSelection(0);
        this.spnHighLct.setSelection(0);
        this.spnHighHold.setSelection(0);
        this.setBusModified(false);
        this.refresh();
        this.setModifierVisiblity(true);
    }

    public void editBusEntry(SelectionEvent e) {
        if (this.table.getSelectionCount() == 0) {
            this.setModifierVisiblity(false);
            return;
        }
        this.onEntryExit();
        I2cBoardDescriptionTable.BusObject bus = this._busObjects.get(this.table.getSelectionIndex());
        this.spnBusInstance.setSelection(bus.instanceId);
        this.spnStdHct.setSelection(bus.sdtSpeedHcnt);
        this.spnStdLct.setSelection(bus.stdSpeedLcnt);
        this.spnStdHold.setSelection(bus.stdSpeedSdaHold);
        this.spnFastHct.setSelection(bus.fastSpeedHcnt);
        this.spnFastLct.setSelection(bus.fastSpeedLcnt);
        this.spnFastHold.setSelection(bus.fastSpeedSdaHold);
        this.spnHighHct.setSelection(bus.highSpeedHcnt);
        this.spnHighLct.setSelection(bus.highSpeedLcnt);
        this.spnHighHold.setSelection(bus.highSpeedSdaHold);
        this.setBusModified(false);
        this.setModifierVisiblity();
    }

    public void onEntryExit() {
        if (this._busModified) {
            MessageBox messageBox = new MessageBox(this.shlIc, 200);
            messageBox.setText("Unsaved Modification");
            messageBox.setMessage("Your last changes weren't saved. Are you sure that you want to continue?");
            int res = messageBox.open();
            if (res == 128) {
                throw new RuntimeException("The user has canceled the last action");
            }
        }
        this.setBusModified(false);
    }

    public void setModifierVisiblity() {
        this.setModifierVisiblity(this.table.getSelectionCount() == 1);
    }

    public void setModifierVisiblity(boolean show) {
        GridData gridDataNote = (GridData)this.grpNote.getLayoutData();
        gridDataNote.exclude = show;
        this.grpNote.setVisible(!show);
        GridData gridDataSelectedBusInformation = (GridData)this.grpSelectedBusInformation.getLayoutData();
        gridDataSelectedBusInformation.exclude = !show;
        this.grpSelectedBusInformation.setVisible(show);
        this.shlIc.layout();
    }

    private void setBusModified(boolean modified) {
        this.table.setEnabled(!modified);
        this.btnOk.setEnabled(!modified);
        this.btnCancel_1.setEnabled(!modified);
        this._busModified = modified;
    }

    protected void createContents() {
        ModifyListener busModifyCallback = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BoardDescriptionTableEditor.this.setBusModified(true);
            }
        };
        this.shlIc = new Shell(65760);
        this.shlIc.setImage(SWTResourceManager.getImage(BoardDescriptionTableEditor.class, "/resources/Intel.ico"));
        this.shlIc.setText("I2C Board-Specific Configuration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlIc, 2);
        Composite compositeTable = GuiUtils.addCompositeToComposite((Composite)this.shlIc, 0, 4, 4, false, false, 1, 1, 1);
        Label lblBusInstance = GuiUtils.addLabelToComposite("Bus Instance:", compositeTable, 0, 16384, 0x1000000, true, false, 1, 1);
        TableViewer tableViewer = new TableViewer(compositeTable, 67586);
        this.table = tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn tblclmnBusInstance = tableViewerColumn.getColumn();
        tblclmnBusInstance.setWidth(80);
        tblclmnBusInstance.setText("Bus Instance");
        this.btnAdd = GuiUtils.addButtonToComposite("Add New Bus", "", compositeTable, 0, 4, 128, true, false, 1, 1);
        this.btnDelete = GuiUtils.addButtonToComposite("Delete Bus", "", compositeTable, 0, 4, 128, true, false, 1, 1);
        this.grpNote = GuiUtils.addGroupToComposite("", (Composite)this.shlIc, 0, 4, 128, true, true, 1, 1, 1);
        this.lblChooseOrAdd = GuiUtils.addLabelToComposite("Choose a bus instance from the list", (Composite)this.grpNote, 4, 0x1000000, 0x1000000, true, false, 1, 1);
        this.grpSelectedBusInformation = GuiUtils.addGroupToComposite("Selected Bus Information", (Composite)this.shlIc, 0, 4, 4, true, false, 1, 1, 2);
        Label lblBusInstanceNumber = GuiUtils.addLabelToComposite("Bus Instance Number:", (Composite)this.grpSelectedBusInformation, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnBusInstance = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.INSTANCE_ID_FIELD_MAX_VALUE, this.shlIc, (Composite)this.grpSelectedBusInformation, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpStandartSpeed = GuiUtils.addGroupToComposite("Standard Speed", (Composite)this.grpSelectedBusInformation, 0, 4, 0x1000000, true, false, 2, 1, 3);
        GuiUtils.addLabelToComposite("Clock:", (Composite)grpStandartSpeed, 0, 4, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Time in high state (ns):", (Composite)grpStandartSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnStdHct = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.STD_SPEED_HCNT_FIELD_SIZE_MAX_VALUE, this.shlIc, (Composite)grpStandartSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("", (Composite)grpStandartSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Time in low state (ns):", (Composite)grpStandartSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnStdLct = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.STD_SPEED_LCNT_FIELD_MAX_VALUE, this.shlIc, (Composite)grpStandartSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("", (Composite)grpStandartSpeed, 258, 4, 0x1000000, true, false, 3, 1);
        GuiUtils.addLabelToComposite("Data:", (Composite)grpStandartSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("SDA hold time (ns):", (Composite)grpStandartSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnStdHold = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.STD_SPEED_SDA_HOLD_FIELD_MAX_VALUE, this.shlIc, (Composite)grpStandartSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpFastSpeed = GuiUtils.addGroupToComposite("Fast Speed", (Composite)this.grpSelectedBusInformation, 0, 4, 0x1000000, true, false, 2, 1, 3);
        GuiUtils.addLabelToComposite("Clock:", (Composite)grpFastSpeed, 0, 4, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Time in high state (ns):", (Composite)grpFastSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnFastHct = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.FAST_SPEED_HCNT_FIELD_MAX_VALUE, this.shlIc, (Composite)grpFastSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("", (Composite)grpFastSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Time in low state (ns):", (Composite)grpFastSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnFastLct = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.FAST_SPEED_LCNT_FIELD_MAX_VALUE, this.shlIc, (Composite)grpFastSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("", (Composite)grpFastSpeed, 258, 4, 0x1000000, true, false, 3, 1);
        GuiUtils.addLabelToComposite("Data:", (Composite)grpFastSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("SDA hold time (ns):", (Composite)grpFastSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnFastHold = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.FAST_SPEED_SDA_HOLD_FIELD_MAX_VALUE, this.shlIc, (Composite)grpFastSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpHighSpeed = GuiUtils.addGroupToComposite("High Speed", (Composite)this.grpSelectedBusInformation, 0, 4, 0x1000000, true, false, 2, 1, 3);
        GuiUtils.addLabelToComposite("Clock:", (Composite)grpHighSpeed, 0, 4, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("Time in high state (ns):", (Composite)grpHighSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnHighHct = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.HIGH_SPEED_HCNT_FIELD_MAX_VALUE, this.shlIc, (Composite)grpHighSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("", (Composite)grpHighSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("Time in low state (ns):", (Composite)grpHighSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnHighLct = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.HIGH_SPEED_LCNT_FIELD_MAX_VALUE, this.shlIc, (Composite)grpHighSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        GuiUtils.addLabelToComposite("", (Composite)grpHighSpeed, 258, 4, 0x1000000, true, false, 3, 1);
        GuiUtils.addLabelToComposite("Data:", (Composite)grpHighSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        GuiUtils.addLabelToComposite("SDA hold time (ns):", (Composite)grpHighSpeed, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnHighHold = GuiUtils.addCustomSpinnerToComposite(I2cBoardDescriptionTable.BusObject.HIGH_SPEED_SDA_HOLD_FIELD_MAX_VALUE, this.shlIc, (Composite)grpHighSpeed, 2048, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeBusInfoButton = GuiUtils.addCompositeToComposite((Composite)this.grpSelectedBusInformation, 0, 131072, 0x1000000, false, false, 2, 1, 2);
        Button btnSave = GuiUtils.addButtonToComposite("Save Bus Entry", "", compositeBusInfoButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeBusInfoButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlIc, 0, 131072, 0x1000000, false, false, 2, 1, 2);
        this.btnOk = GuiUtils.addButtonToComposite("OK", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnCancel_1 = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.formToolkit.paintBordersFor((Composite)this.table);
        this.formToolkit.paintBordersFor((Composite)this.grpSelectedBusInformation);
        this.formToolkit.paintBordersFor((Composite)grpStandartSpeed);
        this.formToolkit.paintBordersFor((Composite)grpFastSpeed);
        this.formToolkit.paintBordersFor((Composite)grpHighSpeed);
        this.formToolkit.adapt((Control)this.btnOk, true, true);
        this.formToolkit.adapt((Control)this.btnCancel_1, true, true);
        this.table.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        lblBusInstance.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.lblChooseOrAdd.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        this.grpSelectedBusInformation.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblBusInstanceNumber.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        grpStandartSpeed.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        grpFastSpeed.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        grpHighSpeed.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.shlIc.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (BoardDescriptionTableEditor.this._modified) {
                    MessageBox messageBox = new MessageBox(BoardDescriptionTableEditor.this.shlIc, 296);
                    messageBox.setText("Closing without saving");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window without saving?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    BoardDescriptionTableEditor.this.editBusEntry(arg0);
                }
                catch (Exception e) {
                    arg0.doit = false;
                    return;
                }
                if (BoardDescriptionTableEditor.this.table.getSelectionCount() == 0) {
                    BoardDescriptionTableEditor.this.btnDelete.setEnabled(false);
                } else {
                    BoardDescriptionTableEditor.this.btnDelete.setEnabled(true);
                }
            }
        });
        this.spnBusInstance.addModifyListener(busModifyCallback);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    BoardDescriptionTableEditor.this.onEntryExit();
                }
                catch (Exception e) {
                    arg0.doit = false;
                    return;
                }
                BoardDescriptionTableEditor.this.addNewBus();
            }
        });
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (BoardDescriptionTableEditor.this.table.getSelectionCount() == 0) {
                    return;
                }
                ArrayList<I2cBoardDescriptionTable.BusObject> toRemove = new ArrayList<I2cBoardDescriptionTable.BusObject>();
                int[] removedIndices = BoardDescriptionTableEditor.this.table.getSelectionIndices();
                for (int i = 0; i < BoardDescriptionTableEditor.this.table.getSelectionCount(); ++i) {
                    toRemove.add((I2cBoardDescriptionTable.BusObject)BoardDescriptionTableEditor.this._busObjects.get(removedIndices[i]));
                }
                BoardDescriptionTableEditor.this._busObjects.removeAll(toRemove);
                BoardDescriptionTableEditor.this.setModifierVisiblity(false);
                BoardDescriptionTableEditor.this.btnDelete.setEnabled(false);
                BoardDescriptionTableEditor.this.refresh();
            }
        });
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BoardDescriptionTableEditor.this.saveBus();
                BoardDescriptionTableEditor.this.setBusModified(false);
                BoardDescriptionTableEditor.this._modified = true;
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    BoardDescriptionTableEditor.this.onEntryExit();
                }
                catch (Exception e) {
                    arg0.doit = false;
                    return;
                }
                BoardDescriptionTableEditor.this.setModifierVisiblity(false);
            }
        });
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BoardDescriptionTableEditor.this._i2cBdt.setBuses(BoardDescriptionTableEditor.this._busObjects);
                BoardDescriptionTableEditor.this._dataStore.getCurrentPdtFile().addBdtObject(BoardDescriptionTableEditor.this._i2cBdt);
                BoardDescriptionTableEditor.this._modified = false;
                BoardDescriptionTableEditor.this._parent.setModified();
                BoardDescriptionTableEditor.this.shlIc.close();
            }
        });
        this.btnCancel_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BoardDescriptionTableEditor.this.shlIc.close();
            }
        });
        this.spnStdHct.addModifyListener(busModifyCallback);
        this.spnStdLct.addModifyListener(busModifyCallback);
        this.spnStdHold.addModifyListener(busModifyCallback);
        this.spnFastHct.addModifyListener(busModifyCallback);
        this.spnFastLct.addModifyListener(busModifyCallback);
        this.spnFastHold.addModifyListener(busModifyCallback);
        this.spnHighHct.addModifyListener(busModifyCallback);
        this.spnHighLct.addModifyListener(busModifyCallback);
        this.spnHighHold.addModifyListener(busModifyCallback);
        int spinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)btnSave) * 1.5);
        int longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)btnSave) * 1.5);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)btnSave);
        int tableMinHeight = GuiUtils.getPixelSizeHeight((Control)this.table) * 10;
        ((GridData)this.spnBusInstance.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnStdHct.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnStdLct.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnStdHold.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnFastHct.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnFastLct.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnFastHold.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnHighHct.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnHighLct.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnHighHold.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)btnSave.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnOk.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnCancel_1.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.table.getLayoutData()).minimumHeight = tableMinHeight;
        ((GridData)this.table.getLayoutData()).heightHint = tableMinHeight;
        this._busModified = false;
        ((GridLayout)grpStandartSpeed.getLayout()).marginHeight = 0;
        ((GridLayout)grpStandartSpeed.getLayout()).marginWidth = 0;
        ((GridLayout)grpStandartSpeed.getLayout()).verticalSpacing = 5;
        ((GridLayout)grpFastSpeed.getLayout()).marginHeight = 0;
        ((GridLayout)grpFastSpeed.getLayout()).marginWidth = 0;
        ((GridLayout)grpFastSpeed.getLayout()).verticalSpacing = 5;
        ((GridLayout)grpHighSpeed.getLayout()).marginHeight = 0;
        ((GridLayout)grpHighSpeed.getLayout()).marginWidth = 0;
        ((GridLayout)grpHighSpeed.getLayout()).verticalSpacing = 5;
        ((GridLayout)compositeBusInfoButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeBusInfoButton.getLayout()).marginWidth = 0;
        ((GridLayout)compositeShellButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeShellButton.getLayout()).marginWidth = 0;
        GridData gridDataNote = (GridData)this.grpNote.getLayoutData();
        gridDataNote.heightHint = this.grpSelectedBusInformation.computeSize((int)-1, (int)-1).y - 20;
        gridDataNote.widthHint = this.grpSelectedBusInformation.computeSize((int)-1, (int)-1).x;
        GridData gridDataSelectedBusInformation = (GridData)this.grpSelectedBusInformation.getLayoutData();
        gridDataSelectedBusInformation.exclude = true;
        this.grpSelectedBusInformation.setVisible(false);
        this.shlIc.setSize(this.shlIc.computeSize(-1, -1));
        this.shlIc.setLocation(GuiUtils.getMiddleLocation(this.shlIc, this.display));
    }
}

