/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.PdtFile;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.MultiPdtEdit;

public class MultiPdtEditAddDevices {
    private static Display display;
    private DataBindingContext m_bindingContext;
    protected Shell shlAddDevices;
    private DataStore _dataStore = null;
    private Table table;
    private TableViewer tableViewer;
    private MultiPdtEdit _parent;
    private Button btnCreateNewPdt;
    private Button btnCreateNewDevices;

    public MultiPdtEditAddDevices(MultiPdtEdit parent, DataStore dataStore) {
        this._dataStore = dataStore;
        this._parent = parent;
    }

    public void open() {
        display = Display.getDefault();
        this.createContents();
        this.shlAddDevices.open();
        this.shlAddDevices.layout();
        while (!this.shlAddDevices.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void createNewPdtFile() {
        FileDialog fd = new FileDialog(this.shlAddDevices, 4096);
        fd.setText("Load PDT binary image");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.bin; *.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        this._dataStore.addPdtFile(new PdtFile(path));
    }

    public void createNewDevices() {
        TableItem[] selection = this.table.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            PdtFile pdt = (PdtFile)selection[i].getData();
            this._dataStore.addDevice(pdt, new Device(0, 0, 0, 0, this._dataStore));
        }
        this._parent.refresh();
        this.shlAddDevices.close();
    }

    protected void createContents() {
        this.shlAddDevices = new Shell(65760);
        this.shlAddDevices.setImage(SWTResourceManager.getImage(MultiPdtEditAddDevices.class, "/resources/Intel.ico"));
        this.shlAddDevices.setText("Add Devices To PDT Files");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlAddDevices, 1);
        this.tableViewer = new TableViewer((Composite)this.shlAddDevices, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MultiPdtEditAddDevices.this.table.getSelectionCount() == 0) {
                    MultiPdtEditAddDevices.this.btnCreateNewDevices.setEnabled(false);
                } else {
                    MultiPdtEditAddDevices.this.btnCreateNewDevices.setEnabled(true);
                }
            }
        });
        this.btnCreateNewPdt = GuiUtils.addButtonToComposite("Create New PDT File", "", (Composite)this.shlAddDevices, 0, 16384, 0x1000000, true, false, 1, 1);
        this.btnCreateNewDevices = GuiUtils.addButtonToComposite("Create New Devices For Selected PDTs", "", (Composite)this.shlAddDevices, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnCreateNewPdt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEditAddDevices.this.createNewPdtFile();
                MultiPdtEditAddDevices.this.tableViewer.refresh();
            }
        });
        this.btnCreateNewDevices.setEnabled(false);
        this.btnCreateNewDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEditAddDevices.this.createNewDevices();
            }
        });
        ((GridData)this.table.getLayoutData()).widthHint = GuiUtils.getButtonWidth((Control)this.btnCreateNewDevices) * 5;
        ((GridData)this.table.getLayoutData()).heightHint = GuiUtils.getButtonWidth((Control)this.btnCreateNewDevices) * 2;
        this.shlAddDevices.setSize(this.shlAddDevices.computeSize(-1, -1));
        this.shlAddDevices.setLocation(GuiUtils.getMiddleLocation(this.shlAddDevices, display));
        this.m_bindingContext = this.initDataBindings();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), PdtFile.class, (String)"displayedPath");
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.tableViewer.setContentProvider((IContentProvider)listContentProvider);
        IObservableList selfList = Properties.selfList(PdtFile.class).observe(this._dataStore.getPdtFiles());
        this.tableViewer.setInput((Object)selfList);
        return bindingContext;
    }
}

