/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.validation;

import pdtEditor.Device;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.SensorModifierOpener;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Issue;

public abstract class Fixer
implements CalibrationEditorOpener,
SensorModifierOpener {
    protected Sensor _sensor;
    protected Device _device;
    protected PdtFile _pdtFile;
    protected Issue _issue;
    private String _issueMessage;

    public Fixer(Sensor sensor) {
        this._sensor = sensor;
    }

    public Fixer(Sensor sensor, Issue issue) {
        this(sensor);
        this._issue = issue;
    }

    public Fixer(Device device) {
        this._device = device;
    }

    public Fixer(Device device, Issue issue) {
        this(device);
        this._issue = issue;
    }

    public Fixer(PdtFile pdtFile) {
        this._pdtFile = pdtFile;
    }

    public Fixer(PdtFile pdtFile, Issue issue) {
        this(pdtFile);
        this._issue = issue;
    }

    public Fixer(Sensor sensor, Device device, PdtFile pdtFile) {
        this._pdtFile = pdtFile;
        this._device = device;
        this._pdtFile = pdtFile;
    }

    public Fixer(Issue issue, Sensor sensor, Device device, PdtFile pdtFile) {
        this(sensor, device, pdtFile);
        this._issue = issue;
    }

    public abstract void fix();

    public abstract String getFixDescription();

    public PdtFile getModifiedPdtFile() {
        return this._pdtFile;
    }

    public Device getModifiedDevice() {
        return this._device;
    }

    public Sensor getModifiedSensor() {
        return this._sensor;
    }

    public String getIssueMessage() {
        return this._issueMessage != null ? this._issueMessage : "";
    }

    public void setIssueMessage(String text) {
        this._issueMessage = text;
    }

    @Override
    public void refreshCalibrationData() {
    }

    @Override
    public void addNewCalibration(Sensor sensor, CalibrationPayload calibration) {
        if (this._sensor != null) {
            this._sensor.addPayload(calibration);
        }
    }

    @Override
    public void setModified() {
    }

    @Override
    public boolean hasSensorInTable(Sensor sensor) {
        return sensor.equals(this._sensor);
    }

    @Override
    public Device getCurrentDevice() {
        return this._device;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void selectSensor(Sensor sensor) {
    }

    @Override
    public void onSensorModifierClose(SensorModifier modifier) {
    }

    @Override
    public void addSensor(Sensor sensor) {
    }
}

