/*
 * Decompiled with CFR 0.152.
 */
package manager.configure;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class Platform {
    @XmlAttribute
    private String name;
    @XmlElement
    private double value;
    @XmlElement
    private String issVersion;
    @XmlElement
    private String externalName;
    @XmlElement
    private boolean deprecated;
    @XmlElement
    private String alternativePlatform;
    public static final String GALILEO = "GALILEO";
    public static final String CHV = "CHV";
    public static final String KBL = "KBL";
    public static final String BXT = "BXT";
    public static final String GLK = "GLK";
    public static final String CNL = "CNL";
    public static final String ICL = "ICL";
    public static final String LKF = "LKF";
    public static final String UP2 = "UP2";
    public static final String UPX = "UPX";
    public static final String CML = "CML";
    public static final String TGL = "TGL";
    public static final String ADL = "ADL";
    public static final Double ISS_VALUE_3_1 = 3.1;
    public static final Double ISS_VALUE_4_1 = 4.1;
    public static final Double ISS_VALUE_1_1 = 1.1;

    public Platform() {
    }

    public Platform(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public String getIssVersion() {
        return this.issVersion;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getAlternativePlatform() {
        return this.alternativePlatform;
    }

    public String getISSFolderName() {
        String vv = Double.toString(this.value);
        if (this.name.equals(GALILEO)) {
            vv = "X.X";
        }
        if (this.value >= 5.4) {
            return "ISH" + vv + "_SI_multi_app_OPENRTOS";
        }
        return "ISH" + vv + "_SI_sensor_app_VIPER";
    }

    public boolean equalsValue(double val) {
        String vv;
        if (this.value == val) {
            return true;
        }
        if ((val == ISS_VALUE_3_1 || val == ISS_VALUE_4_1) && (vv = Double.toString(val).replace("1", "5")).equals(Double.toString(this.value))) {
            return true;
        }
        return val == ISS_VALUE_1_1 && (vv = Double.toString(val).replace("1.1", "1.0")).equals(Double.toString(this.value));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Platform)) {
            return false;
        }
        Platform toCompare = (Platform)obj;
        return this.name.equals(toCompare.getName());
    }

    public String dump() {
        return "[" + this.name + "|" + this.value + "|" + this.issVersion + "|" + this.externalName + "|" + this.deprecated + "|" + this.alternativePlatform + "]";
    }

    public String toString() {
        return this.name;
    }
}

