<?php
class ActionMediaPatrolPD extends UserAction 
{
	private $HD_IDs;
	private $Action;
	
	private $freeNotSpareHDIDs = array();
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->HD_IDs = getRequestPara("HDs");
		//$this->Action = getRequestPara("action");
	}
	
	private function doMediaPatrolPD()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/BlockList.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/HdDetail.class.php");
		
		$failNum = 0;
		$failMsg = '';
		
		#set id of pd disks in target vd
		#set to array
		$MP_HDIDs = array();
		$MP_HDs = explode(" ",$this->HD_IDs);
		foreach ($MP_HDs as $HDID)
		{
			if (trim($HDID) != "") {
				$MP_HDIDs[] = $HDID;
			}
		}
		
		#do mp for each pd
		foreach ($MP_HDIDs as $Hd)
		{
			$hdDetail = new HdDetail();
			$hdDetail->setAdapterID($this->getAdapterID());
			$hdDetail->setID($Hd);
			$hdDetail->toGetHDInfo();
			$hdDetail->toGetHdFreeInfo();
			$hdDetail->toGetHDRaidStatus();

			$hdDetailArray = $hdDetail->getBaseClasses();
			$hd = array_shift($hdDetailArray);

			if ((! $hd->isFree() || $hd->isAssigned() || $hd->isSpare())){
				#do mp
				$this->ApiCmd = new XMLAPICommand();
				$this->ApiCmd->setCommand(XMLAPICommand::MV_PD_StartMediaPatrol);
				$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
				$this->ApiCmd->setCommandPara("HD_ID",$Hd);
				//$bgaAction = BgaControl::getBgaControlValue($this->Action);
				//$this->ApiCmd->setCommandPara("Action",$bgaAction);
				$this->ApiCmd->issueCommand();
				
				if ($this->ApiCmd->getResult()->RetVal . "") {
					$failNum++;
					$err = ComError::getErrStr(intval($this->ApiCmd->getResult()->RetVal));
					$err = gettext($err);
					$failMsg .= "PD ".$Hd.": ".$err. "\n";
				}
			} else {
				#free pd can not do mp
				$failNum++;
				$err = gettext(AlertMsg::MP_FREE_PD_ERROR);
				$failMsg .= "PD ".$Hd.": ".$err. "\n";
			}
		}
		
		
		if($failNum > 0)
		{
			$this->setHDMPCmdXmlRetFail($failMsg);
		}
		else {
			$this->setHDCmdXmlRetSuccess();
		}
	}
		
	private function setHDMPCmdXmlRetFail($failMsg)
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Msg = $failMsg;
		$this->xmlRet->Url = getBaseURL()
			. "JumpPage.php?Target=" . Target::getHdDetail . "&ID=" . $this->HD_IDs . "&HBAID=" . $this->getAdapterID();
	}
	
	protected function doAction()
	{
		//$this->setfreeNotSpareHDIDs();
		$this->doMediaPatrolPD();
	}
}
?>