<?php
class CtnHBAList extends Container 
{
	private $toGetHBACount = false;
	private $toGetHBAInfo = false;
	private $toGetHBAConfig = false;
	
	public function toGetHBACount()
	{
		$this->toGetHBACount = true;
	}
	
	public function toGetHBAInfo()
	{
		$this->toGetHBAInfo = true;
	}
	
	public function toGetHBAConfig()
	{
		$this->toGetHBAConfig = true;
	}
	
	protected function setBase()
	{
		$this->base = new HBAList();
		
		if ($this->toGetHBACount) {
			$this->base->toGetHBACount();
		}
		if ($this->toGetHBAInfo) {
			$this->base->toGetHBAInfo();
		}
		if ($this->toGetHBAConfig) {
			$this->base->toGetHBAConfig();
		}
	}
	
	protected function setDataToPage()
	{
		$HBAList = array();
		$baseclasses = $this->base->getBaseClasses();
		foreach ($baseclasses as $HBA)
		{
			$hbaInfo = new HBAInfo();
			$hbaInfo->setHBAInfo($HBA);
			$HBAList[$hbaInfo->ID] = $hbaInfo;
		}
		
		ksort($HBAList);
		
		$this->setInfo($HBAList);
		$this->smarty->assign("HBAList",$HBAList);
	}
	
	protected function displayXML()
	{
		//won't be used
	}
}
?>