<?php

class CtnHdList extends Container 
{
	private $UseThorSizePolicy = 0;
	
	private $toGetHdInfo;
	private $toGetValidSize;
	private $toGetSpareInfo;
	private $toGetHdFreeInfo;
	private $toGetMPStatus;
	private $toGetStatus;
        private $toGetConfig;
	
	public function toGetMPStatus()
	{
		$this->toGetMPStatus = true;
	}
	
	public function toGetHdInfo()
	{
		$this->toGetHdInfo = true;
	}
	
	public function toGetValidSize()
	{
		$this->toGetValidSize = true;
	}
	
	public function toGetSpareInfo()
	{
		$this->toGetSpareInfo = true;
	}
	
	public function toGetHdFreeInfo()
	{
		$this->toGetHdFreeInfo = true;
	}
	
	public function toGetStatus()
	{
		$this->toGetStatus = true;
	}

        public function toGetConfig()
        {
                $this->toGetConfig = true;
        }
	
	protected function setBase()
	{
		$this->base = new HdList();
		$this->base->setAdapterID($this->getAdapterID());
		
		if ($this->toGetHdInfo) {
			$this->base->toGetHdInfo();
		}
		if ($this->toGetValidSize) {
			$this->base->toGetValidSize();
		}
		if ($this->toGetHdFreeInfo) {
			$this->base->toGetHdFreeInfo();
		}
		if ($this->toGetSpareInfo) {
			$this->base->toGetHDRaidStatus();
		}
		if ($this->toGetMPStatus) {
			$this->base->toGetMPStatus();
		}
		if ($this->toGetConfig) {
			$this->base->toGetConfig();
		}
		/*
		if ($this->toGetStatus) {
			$this->base->toGetHdStatus();
		}
		*/
	}
	
	public function displayXML()
	{
		$this->display("XML_PdList.tpl");
	}
	
	protected function setDataToPage()
	{		
		$sysFeature = AdapterFeature::getInstance($this->getAdapterID());
        if (isset($sysFeature))
            $this->UseThorSizePolicy = $sysFeature->isThor;
		
		$hdList = array();
		
		$TotalCapacity = 0;
		$TotalUsedCapacity = 0;
		$TotalValidCapacity = 0;
		
		$baseclasses = $this->filter($this->base->getBaseClasses());
		
		$allHDFree = true;
		foreach ($baseclasses as $HD)
		{
			if ( !$HD->isFree()) {
				$allHDFree = false;
			}
			
			//tape size not available
			if (!($HD->isTAPE()||$HD->isEnclosure())) 
			{
				$TotalCapacity += ConvertSize($HD->getSize(),$this->UseThorSizePolicy);
				$TotalValidCapacity += ConvertSize($HD->getValidSize(),$this->UseThorSizePolicy);
			}
			
			if($HD->isEnclosure())
			{
				continue;
			}
			
			//$HDInfo->setHDDtl($HD);
			$hbaId = $HD->getAdapterID();
			if (isset($hbaId))
			{
				$HDInfo = new HDInfo();
				$HDInfo->setHDInfo($HD);
				$HDInfo->setConnectInfo($HD);
				$hdList[$HDInfo->ID] = $HDInfo;
			}
		}
		
		ksort($hdList);
		
		if ($allHDFree) {
			$TotalUsedCapacity = "0.0";
		}
		else {
			$TotalUsedCapacity = $TotalCapacity - $TotalValidCapacity;
		}
		
		$TotalCapacity = number_format($TotalCapacity,1);
		$TotalValidCapacity = number_format($TotalValidCapacity,1);
		$TotalUsedCapacity = number_format($TotalUsedCapacity,1);
		
		$TotalCapacity = $TotalCapacity . " GB";
		$TotalValidCapacity = $TotalValidCapacity . " GB";
		$TotalUsedCapacity = $TotalUsedCapacity . " GB";
		
		$this->setInfo($hdList);
		
		$this->smarty->assign("TotalCapacity",$TotalCapacity);
		$this->smarty->assign("TotalUsedCapacity",$TotalUsedCapacity);
		$this->smarty->assign("TotalValidCapacity",$TotalValidCapacity);
		$this->smarty->assign("PdList",$hdList);
	}
}

?>