<?php
class MacMailer {
    private $userName;
	  
    const HelloMsg = 'Hello';
    const MailAutoSub = 'Email Setting Test';
    const MailAutoMsg = 'This mail is automatically sent out by Marvell Storage Utility.Please don\'t reply to this mail.';
    const MailHeadMsg = 'The following event(s) have ocurred on the machine';
    const MailEventSub = 'Marvell Storage Utility Event Notification';
    
    public function getUserName() {
        return $this->userName;
    }
    public function setUserName($userName) {
        $this->userName = $userName;
    }

    //send basic mail
    public function send($to,$subject,$content,$type='text/plain') {
        $command = "echo \"Subject:".$subject."\r\n".$content."\r\n\" | sendmail -t ".$to;
        exec($command);
    }

    public function sendTestMail($testAddr = null) {
    	  if($testAddr){
    	      $this->send($testAddr,self::MailAutoSub,self::MailAutoMsg);
    	  }
    }

    //send event notify mail(text/html)
    public function sendEventNotify($contacts,$eventsRelated) {
        if ($contacts && $eventsRelated) {
$fh = fopen("/tmp/myphp.log", 'a') or die("can't open file");
fwrite($fh, "send email to ".$contacts."\n");
fclose($fh);
            $this->send($contacts,self::MailEventSub,$this->formMultipartContent(gettext("MRU User"),$eventsRelated));
        }
    }

    private function formMultipartContent($name,$eventsRelated) {

        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $HostName = getenv('COMPUTERNAME');
        }
        else {
            $HostName = exec("hostname");
        }

        $txtContent = 'Hello'.', ' . $name .'.\r\n';
        $txtContent .= self::MailAutoMsg . '\r\n';
        $txtContent .= self::MailHeadMsg.'('. $HostName .').\r\n';

        foreach ($eventsRelated as $event) {
            $txtContent .=  $event->Date . " : ["
                    . $event->SeverityTitle . "] " . $event->Class . " : " . $event->Log .'\r\n';
        }

        return $txtContent;
    }
}
?>
