<?php

class Folder{
    public $name;
    public $path;
    public $controlLink;
    public $index;
    public $existInDb;
}

class GetFoldersList
{
    private $TplFile;
    private $smarty;
    private $currentPath;
    private $parentPath;
    private $FoldersList = array();
    private $parent = null;

    public function initPara()
    {
        //$this->parentPath = getRequestPara("currentPath");
        $this->currentPath = getRequestPara("parent");
    }

    public function setParent($currentPath)
    {
         $this->currentPath = $currentPath;
    }
    public function getSubFolders()
    {
        $currentPath = inter_mb_convert_utf8_path($this->currentPath);
        if($currentPath[mb_strlen($currentPath) - 1] == '\\')
            $currentPath = mb_substr($currentPath, 0, mb_strlen($currentPath) - 1);

        $newPath = $this->currentPath;
        if($newPath[mb_strlen($newPath) - 1] == '\\')
            $newPath = mb_substr($newPath, 0, mb_strlen($newPath) - 1);
        $arr =  explode("\\", $newPath);
        $currentLink = implode("\\\\", $arr);
        if(sizeof($arr) >= 1) {
            array_pop($arr);
        }
        if(! empty($arr))
            $parentControlLink = implode("\\\\", $arr) . "\\\\";
        else
            $parentControlLink = "";

        include_once("../phpsrc/model/ApplicationFileDataAccess.class.php");
        $fileDAO = new ApplicationFileDataAccess();
        $parentInDb = $fileDAO->checkFileExistInDB($newPath, true);
      
        $this->ApiCmd = new XMLAPICommand();
        $this->ApiCmd->setCommand(XMLAPICommand::MV_SYS_GetSubDirList);
        $this->ApiCmd->setCommandPara("ParentFolder",$this->currentPath);

        $foldersPathList = array();
        if ($this->ApiCmd->issueCommand() && $this->ApiCmd->getResult()) {
            $XMLRoot = $this->ApiCmd->getResult();
            $i = 0;
            foreach($XMLRoot->Path as $filepath)
            {
                //$pathArr = explode("\\", $filepath);
                //$fileName = $pathArr[sizeof($pathArr)-1];
                foreach($filepath->FolderName as $fileName)
                {
                        $folderInfo = new Folder();
                        $folderInfo->index = $i;
                        $folderInfo->name = $fileName;
                        $folderInfo->path = $currentPath . "\\" . $fileName;
                        $folderInfo->controlLink = $currentLink . "\\\\" . $fileName;
                        if($parentInDb)
                                $folderInfo->existInDb = true;
                        else
                                $folderInfo->existInDb = $fileDAO->checkSubFileExistInDB($folderInfo->path);
                        $this->FoldersList[$i] = $folderInfo;
                        $foldersPathList[$i] = $folderInfo->path;
                        $i++;
                }
            }
        }

        if ($this->smarty){
            $this->smarty->assign("parentControlLink", $parentControlLink);
            $displayCurrentPath = $newPath . "\\";
            $displayCurrentPath = str_replace("\\\\", "\\", $displayCurrentPath);
            $this->smarty->assign("displayCurrentPath", $displayCurrentPath);
            $this->smarty->assign("currentPath", $newPath . "\\");
            $this->smarty->assign("FoldersList", $this->FoldersList);
        }
        
        return $foldersPathList;
    }

    public function displayResultXML() {
        $this->TplFile = "XML_CustomizeFolders.tpl";
        $this->initPara();
        $this->getSubFolders();
        $this->smarty->display($this->TplFile);
        
    }

    public function smartyAssign($smarty) {
        $this->smarty = $smarty;
    }
}

?>
