<?php

class GetSSDAdapterCreateMaxSize {

    private $TplFile;
    private $smarty;

    private $HBAID = 0;
    private $maxSize = 0;
    private $startLBA = 0;

    private function initPara() {
        $this->HBAID = getRequestPara("HBAID");
    }
    
    public function getMaxSize() {
        return $this->maxSize;
    }

    public function setAdapterID($HBAID) {
        $this->HBAID = $HBAID;
    }

    public function setMaxSize() {
        $Cmd = new XMLAPICommand();
        $Cmd->setCommand(XMLAPICommand::MV_SSD_GetMaxSize);
        $Cmd->setCommandPara("AdapterID",$this->HBAID);

        //var_dump($Cmd);
        if ($Cmd->issueCommand()) {
            $this->maxSize = intval($Cmd->getResult()->MaxFreeSize);
            $this->startLBA = intval($Cmd->getResult()->startLBA);
            $this->smarty->assign("MaxSizeGB",FormatSize($this->maxSize));
            $this->smarty->assign("MaxSize", ConvertSize($this->maxSize));
            $this->smarty->assign("startLBA", $this->startLBA);
        }
    }

    private function setTestData() {
        $this->maxSize = 123333333;
        //$this->smarty->assign("MaxSizeGB",FormatSize($size));
        $this->smarty->assign("MaxSize",ConvertSize($this->maxSize));
    }

    public function displayResultXML() {
//        $this->TplFile = "XML_SSDCreateMaxSize.tpl";
//        if (BaseData::DebugTest) {
//            $this->setTestData();
//            $this->smarty->display($this->TplFile);
//            return;
//        }
//        $this->initPara();
//        $this->setMaxSize();
//        $this->smarty->display($this->TplFile);
    }

    public function smartyAssign($smarty) {
        $this->smarty = $smarty;
    }
}

?>
