<?php
//include_once("PageDisplayer.class.php");

class PgRebuildDisplayer extends BGAPageDisplayer
{
	protected function setDisplayInfo()
	{
		if ($this->cmdPara != null) {
			$HDID = getUrlPropertyValue($this->cmdPara,'HDID');			
			$this->smarty->assign('HDID',$HDID);
		}
		
		$this->setPageName(Target::RebuildPage . ".tpl");
		$this->smarty->assign("ScheduledBgaType",ScheduledBGAType::LD_BGA_REBUILD);
	}
	
	protected function setInfo()
	{
		$RebuildDG = 0;
		$ID = getRequestPara('ID');
		
		if ($ID == null) {
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$smarty = $this->smarty;
		
		$container = new CtnLdDetail();
		$container->setAdapterID($this->getAdapterID());
		$container->setLDID($ID);
		$container->toGetLDInfo();
		$container->toGetHdInfo();
		$container->toGetBlockInfo();
		$container->smartyAssign($smarty);
		$container->initContainer();
		
		$ldlst = $container->getBase()->getBaseClasses();
		if (!sizeof($ldlst)) {
			/*
			if ($type == 'saveModify') {
				$this->displayDefaultPage(Target::BgaSchedulePage);
			}
			else
			{
				//check for LD does not exist
				$this->displayDefaultPage(Target::LdListPage);
			}
			return;
			*/
			$Name = gettext('VD Not Exist');
			$smarty->assign('VDNotExist',1);
		}
		else {
			$ldDetail = array_shift($ldlst);
			$Name = $ldDetail->getName();
			$blklst = $ldDetail->getBlockList();
			if ($blklst) {
				$HDs =array();
				foreach ($blklst as $aBlk)
				{
					$aHd = $aBlk->belongHD();
					$HDs[] = $aHd;
				}
				
				$blk = array_shift($blklst);
				$blkSize = $blk->getSize();
				if ($HDs) {
					$filter = new HdRebuildFilter($blkSize,$HDs);
					$hdList = new CtnHdList();
					$hdList->setAdapterID($this->getAdapterID());
					$hdList->toGetHDInfo();
					$hdList->toGetValidSize();
					$hdList->toGetSpareInfo();
					$hdList->toGetHdFreeInfo();
					$hdList->setFilter($filter);
					$hdList->smartyAssign($smarty);
					$hdList->initContainer();
				}
			}
		}
		
    	$CancelAlert = gettext(AlertMsg::REBUILD_CANCEL)."?";
    	$smarty->assign("CancelAlert",$CancelAlert);
    	$smarty->assign("ID",$ID);
    	$smarty->assign("HBAID",$this->getAdapterID());
    	$smarty->assign("Name",$Name);
    	$smarty->assign("RebuildDG",$RebuildDG);
	}
}
?>