<?php
//include_once("Container.class.php");

class BGAJobDtl
{
	public $bgaName;
	public $bgaType;
	
	public $VDID;
	public $HDIDs;
	public $DiskClass;
	public $jobID;
	public $startTime;
	public $ScheduleStr;
	public $settingType;
	public $settingTypeStr;
	public $settingTime;
	public $settingTimeStr;
	public $settingDate;
	public $settingDateStr;
	public $settingDateSupplement;
	public $settingDateSupplementStr;
	public $status;
	public $statusStr;
	public $result;
	public $resultStr;
	public $resultText;
	
	public $AdapterID;
	public $modifyUrl;
	public $modifyMPUrl;

        public $diffTime;
	
	public function setBGAJobDtl($job)
	{
		$this->bgaType = $job->getBgaType();
		$this->bgaName = ScheduledBGAType::getBGATypeString($job->getBgaType());
		$this->bgaName = gettext($this->bgaName);
		
		//here changes
		$this->VDID = $job->getVDID();
		
		$this->AdapterID = getUrlPropertyValue($job->getCmdPara(), "HBAID");
		
		if($job->getBgaType() == ScheduledBGAType::LD_BGA_CONSISTENCY_CHECK
			|| $job->getBgaType() == ScheduledBGAType::LD_BGA_CONSISTENCY_FIX 
			|| $job->getBgaType() == ScheduledBGAType::LD_BGA_INIT_BACK 
			|| $job->getBgaType() == ScheduledBGAType::LD_BGA_MIGRATION 
			|| $job->getBgaType() == ScheduledBGAType::LD_BGA_REBUILD 
		){
			$this->DiskClass = gettext('VD');
		}
		else if ($job->getBgaType() == ScheduledBGAType::HD_BGA_MP) {
			$this->DiskClass = gettext('PD');
			$this->modifyMPUrl = PHPPageName::TargetPageName
			. '?jobID=' . $job->getIndex()
			. '&amp;HBAID=' . $this->AdapterID
			. '&amp;type=saveModify' . '&amp;Target=MediaPatrolPage';
			$HDs = explode(' ',trim($this->VDID));
			sort($HDs,SORT_NUMERIC);
			$this->VDID = "";
			foreach ($HDs as $HD)
			{
				$this->VDID .= $HD . ',';
			}
			$this->VDID = substr($this->VDID,0,strlen($this->VDID) - 1);
			if(sizeof($HDs) > 1)
			{
				$this->HDIDs = gettext('PDs id').' : '.$this->VDID;
				$this->VDID = gettext('Multi');
			}
		}
		else if ($job->getBgaType() == ScheduledBGAType::DG_BGA_MIGRATION
			|| $job->getBgaType() == ScheduledBGAType::DG_BGA_REBUILD){
			$this->DiskClass = gettext('DG');
		}
		else if($job->getBgaType() == ScheduledBGAType::BBU_BGA_RELEARN)
		{
			$this->DiskClass = gettext("BBU");
		}
		
		$this->jobID = $job->getIndex();
				
		$this->settingType = $job->getSettingType();
		
		$this->settingTime  = $job->getSettingTime();
		$this->settingTimeStr = date("H:i",strtotime($job->getSettingTime()));
		
		//
		$this->settingDate  = $job->getSettingDate();
		$this->settingDateStr  = date("m/d/Y", strtotime($job->getSettingDate()));

		$tmpTimeStr=$job->getSettingTime()-$this->gettimezone();
                $this->diffTime=strtotime(date("Hi",mktime(($tmpTimeStr-$tmpTimeStr%100)/100,$tmpTimeStr%100)))-strtotime("now");
		$this->settingDateSupplement  = $job->getSettingDateSupplement();
		
		//
		$this->status  = $job->getStatus();
		$this->result  = $job->getResult();
		$this->resultText  = $job->getResultText();
		
		//
		$startTime = $job->getStartTime();
		if ($startTime == 0) {
			$this->startTime = "";
		}
		else {
			$startTime = strtotime($job->getStartTime());
			$this->startTime = date("m/d/Y H:i", $startTime);
		}
		if ($job->isWeekRepeat())
		{
			$this->settingDateSupplementStr = gettext(WeekDay::getWeekDayStr($this->settingDateSupplement));
		}
		
		/*
		if ($job->isNoRepeat()) {
			//$this->ScheduleStr = gettext('Start at') . ' ' . $this->settingDateStr . ' ' . //$this->settingTimeStr;
		}
		else if ($job->isDayRepeat()) {
			//$this->ScheduleStr = gettext('Every') . ' ' 
			//	. $this->settingDate . ' ' .gettext('day(s) at') . ' ' . $this->settingTimeStr;
		}
		elseif ($job->isWeekRepeat())
		{
			//$this->ScheduleStr = gettext('Every') . ' ' . $this->settingDate . ' ' .gettext('week(s) on') . ' '
			//	. gettext(WeekDay::getWeekDayStr($this->settingDateSupplement))
			//	. gettext('at') . ' ' . $this->settingTimeStr;
		}
		else if ($job->isMonthRepeat()) {
			$this->ScheduleStr = gettext('Day') . ' ' . $this->settingDateSupplement 
				. ' ' . gettext('of Every') . ' ' . $this->settingDate . ' ' . gettext('month(s)') .' ' 
				. gettext('at') . ' ' . $this->settingTimeStr;
		}
		*/
		$this->modifyUrl = $this->getLink($this->VDID,$this->jobID);
		
	}
	
	private function getLink($VDID,$jobID)
	{
		if ($this->bgaType == ScheduledBGAType::ACCELERATOR_AUTO ) {
			return PHPPageName::TargetPageName 
				. '?jobID=' . $jobID
				. '&amp;type=saveModify' . '&amp;Target=AcceleratorNewSchedule';
			
		} else {
			return PHPPageName::TargetPageName 
				. '?ID=' . $VDID
				. '&amp;jobID=' . $jobID
				. '&amp;HBAID=' . $this->AdapterID
				. '&amp;type=saveModify' . '&amp;Target=NewTimesettingPage';
		}
	}
        
	private function gettimezone() {
				 $descriptorspec = array(
                	0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
                	1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
                	2 => array("pipe", "w") 	// stdout is a pipe that the child will write to
        	);

        	if(file_exists("/bin/date")){
        		$process = proc_open('date +%z', $descriptorspec, $pipes);

        		if (is_resource($process)) {
                	// $pipes now looks like this:
                	// 0 => writeable handle connected to child stdin
                	// 1 => readable handle connected to child stdout
                	// Any error output will be appended to /tmp/error-output.txt

                	$timezonegap=stream_get_line($pipes[1], 10, "\n");
                	fclose($pipes[1]);

               		// It is important that you close any pipes before calling
                	// proc_close in order to avoid a deadlock
                 	$return_value = proc_close($process);
                 	return $timezonegap;
        		}
        	}

        	if(file_exists('C:\Windows\timezonediff.exe')){
        		$process = proc_open('timezonediff.exe', $descriptorspec, $pipes);

        		if (is_resource($process)) {
                	// $pipes now looks like this:
                	// 0 => writeable handle connected to child stdin
                	// 1 => readable handle connected to child stdout
                	// Any error output will be appended to /tmp/error-output.txt

                	$timezonegap=stream_get_line($pipes[1], 10, "\n");
                	fclose($pipes[1]);

               		// It is important that you close any pipes before calling
                	// proc_close in order to avoid a deadlock
                 	$return_value = proc_close($process);
                 	return $timezonegap;
        		}
        	}
        	return 0;
	}
}

class CtnAcceleratorJobList
{
	protected $smarty;
	private $jobList = array();
	
	public function getJobListSize()
	{
		return sizeof($this->jobList);
	}

        public function getJobList()
        {
            return $this->jobList;
        }
	
	public function initContainer()
	{
		$da = new BGAJobDataAccess();
		$alljobs = $da->getJobsByType(ScheduledBGAType::ACCELERATOR_AUTO);
		
		$alljobs = array_reverse($alljobs);
		
		foreach ($alljobs as $job)
		{
			{				
				$jobDtl = new BGAJobDtl();
				$jobDtl->setBGAJobDtl($job);
				$this->jobList[] = $jobDtl;
			}
		}
		
		$this->smarty->assign('jobList',$this->jobList);
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
	
	public function display($TPLFile)
	{
		$this->smarty->display($TPLFile);
	}
}

class CtnBGAJobList
{
	protected $smarty;
	private $pageID;
	private $jobList = array();
	
	public function getJobListSize()
	{
		return sizeof($this->jobList);
	}
	
	public function setPageID($pageID)
	{
		$this->pageID = $pageID;
	}
	
	public function initContainer()
	{
		$da = new BGAJobDataAccess();
		$alljobs = $da->getAllBGAJobs();
		
		$alljobs = array_reverse($alljobs);
		
		//filter out BBU related
		$jobs = array();
		foreach ($alljobs as $job)
		{
			if($job->getBgaType() != ScheduledBGAType::BBU_BGA_RELEARN
                                && $job->getBgaType() != ScheduledBGAType::ACCELERATOR_AUTO)
				$jobs[] = $job;
		}
		
		//construct pager
		$pager = new Pager();
		$pager->setDataList($jobs);
		
		if ($this->pageID == null) {
			$jobs = $pager->goFirstPage();
		}else if ($this->pageID == -1) {
			$jobs = $pager->goLastPage();
		}
		else
		{
			$pager->setPageID($this->pageID);
			$jobs = $pager->getPage();
		}
	
		//convert to JobDtl
		//$jobList = array();
		$refreshTime=-1;
		foreach ($jobs as $job)
		{
			{				
				$jobDtl = new BGAJobDtl();
				$jobDtl->setBGAJobDtl($job);
				if($refreshTime<0){
					$refreshTime=$jobDtl->diffTime;
				}
				else if($jobDtl->diffTime>0){
					if($refreshTime>$jobDtl->diffTime)
						$refreshTime=$jobDtl->diffTime;
				}
				$this->jobList[] = $jobDtl;
			}
		}
		
		//set data to page
		if ($pager->pageCount() != 0) 
			$this->smarty->assign('curPageID',$pager->getPageID() + 1);
		else 
			$this->smarty->assign('curPageID',0);

		$this->smarty->assign('pageNum',$pager->pageCount());
		$this->smarty->assign('pageID',$pager->getPageID());
		$this->smarty->assign('isFirst',$pager->isFirst());
		$this->smarty->assign('isLast',$pager->isLast());
		$this->smarty->assign('jobList',$this->jobList);
                $this->smarty->assign('refreshTime',$refreshTime);
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
	
	public function display($TPLFile)
	{
		$this->smarty->display($TPLFile);
	}
}
class CtnBGAJobDtl
{
	protected $smarty;
	private $jobID;
	
	public function setJobID($jobID)
	{
		$this->jobID = $jobID;
	}
	
	public function initContainer()
	{
		$da = new BGAJobDataAccess();
		$job = $da->getBGAJobByID($this->jobID);
		
		$jobDtl = new BGAJobDtl();
		if ($job) {
			$jobDtl->setBGAJobDtl($job);
		}
		
		$this->smarty->assign('jobDtl',$jobDtl);
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
	
	public function display($TPLFile)
	{
		$this->smarty->display($TPLFile);
	}
}
?>
