<?php
abstract class BaseFactory {
    protected $BaseClasses = array();
    protected $reqSender;
    private $AdapterID;

    public function hasObj($id) {
        if (isset($this->BaseClasses[$id])) {
            return true;
        }

        return false;
    }

    public function setAdapterID($AdapterID) {
        $this->AdapterID = $AdapterID;
    }
    public function getAdapterID() {
        return $this->AdapterID;
    }

    public function getObj($id) {
        if (array_key_exists($id, $this->BaseClasses)) {
            return $this->BaseClasses[$id];
        }
        return false;
    }

    public function addObj($id, $obj) {
        $this->BaseClasses[$id] = $obj;
    }

    public function getBaseClasses() {
        return $this->BaseClasses;
    }

    public function getBaseDetail() {
        $arr = $this->BaseClasses;
        return array_shift($arr);
    }

    public function runCommand($xmlCmd, $handler) {
        if (! isset($this->reqSender)) {
            $this->setRequestSender();
        }

        $XMLApiCmd = new XMLAPICommand();
        $XMLApiCmd->setCommand($xmlCmd);
        if (strpos($XMLApiCmd->getCommand(), "AdapterID") !== false) {
            $XMLApiCmd->setCommandPara("AdapterID", $this->AdapterID);
        }
        $handler->setFactory($this);
        $XMLApiCmd->setXmlHandler($handler);
        $this->reqSender->runCommand($XMLApiCmd);
    }

    public function runCommandDirectly($xmlCmd, $handler) {
        if (! isset($this->reqSender)) {
            $this->setRequestSender();
        }
        $handler->setFactory($this);
        $xmlCmd->setXmlHandler($handler);
        $this->reqSender->runCommand($xmlCmd);
    }

    public function createObj($id) {
        $obj = $this->createObject();
        $this->addObj($id, $obj);
        return $obj;
    }

    protected abstract function createObject();
    protected abstract function setRequestSender();
}

?>