<?php
class ActionAddFileToGroup extends ActionAcceleratorGroupBase {
    private $appid;
    private $selectedPaths;

    protected function validatePara() {
    }

    protected function initActionPara() {
        $this->appid = getRequestPara("appid");
        $this->selectedPaths = getRequestPara("selectedPaths");
    }

    public function doSave() {
        $appFileDA = new ApplicationFileDataAccess();

        //add files to group
        $paths = explode("|", $this->selectedPaths);

        foreach ($paths as $path) {
            $appFile = new ApplicationFile();
            $appFile->setAppID($this->appid);
            $appFile->setFilePath($path);
            $appFileDA->addFileForApp($appFile);
        }

        $this->updateApplication($this->appid);
        
        $this->setCmdXmlRetSuccess();
    }

    private function setCmdXmlRetSuccess() {
        $this->xmlRet = new SuccessXMLRet();
        $this->xmlRet->Msg = "";
        $this->xmlRet->Url = "JumpPage.php?Target=" . Target::CustomizeWizardPage2 . "&appid=" . $this->appid . "&type=edit";
    }

    protected function doAction() {
        if (parent::checkAccStatus())
            $this->doSave();
        else
            parent::setGroupActionCmdXmlRetFail();
    }


}

?>
