<?php
class GetSSDVolumeAllocation {
	
	private $TplFile;
	private $smarty;
	private $HBAID = 0;
	private $ApiCmd;
	private $xmlRet;//the xml result
	private $status;
	private $writePerformance;
	private $dataProtection;
	private $HDIDs;
	
	
	private function initPara()
	{
		$this->HBAID = getRequestPara("HBAID");
		$this->dataProtection = getRequestPara("dataProtection");
		$this->writePerformance = getRequestPara("writePerformance");
		$this->HDIDs = getRequestPara("HDIDs");
	}
	
	public function setAdapterID($HBAID)
	{
		$this->HBAID = $HBAID;
	}
	
	public function setWritePerformance($wPerformance)
	{
		$this->writePerformance = $wPerformance;
	}
	
	public function setDataProtection($dataProtection)
	{
		$this->dataProtection = $dataProtection;
	}
	
	public function setHDIDs($hdids)
	{
		$this->HDIDs = $hdids;
	}	
	
	public function setSSDVolumeAllocation()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_SSD_GetVolumeAllocation );
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		$this->ApiCmd->setCommandPara("RaidMode",$this->dataProtection);
		$this->ApiCmd->setCommandPara("OpLevel",$this->writePerformance);
		$this->ApiCmd->setCommandPara("HDIDs",$this->HDIDs);
		
		$hds = split(" ", $this->HDIDs);
		$this->ApiCmd->setCommandPara("HDCount",sizeof($hds));
		
		//var_dump($this->ApiCmd);
		
		if ($this->ApiCmd->issueCommand()) {
			$performanceCapacity = $this->ApiCmd->getResult()->PerformanceCapacity;
			$protectionCapacity = $this->ApiCmd->getResult()->ProtectionCapacity;
			$useableCapacity = $this->ApiCmd->getResult()->UseableCapacity;
			
			$totalCapacity = $performanceCapacity + $protectionCapacity + $useableCapacity;
			$performancePercentage = ($performanceCapacity/$totalCapacity) * 100;
			$protectionPercentage = ($protectionCapacity/$totalCapacity) * 100;
			
			if ($performanceCapacity > 0)
				$this->smarty->assign("PerformanceCapacityGB",FormatSize($performanceCapacity));
			$this->smarty->assign("PerformancePercentage",$performancePercentage);
			if ($protectionCapacity > 0)
				$this->smarty->assign("ProtectionCapacityGB",FormatSize($protectionCapacity));
			$this->smarty->assign("ProtectionPercentage",$protectionPercentage);
			if ($useableCapacity > 0)
				$this->smarty->assign("UseableCapacityGB",FormatSize($useableCapacity));
			$this->smarty->assign("UseableCapacity",$useableCapacity);
		}
		
	}
	
	private function setGetAllocationCmdXmlRetFailed()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
		$errStatus = $this->ApiCmd->getResult()->SSDStatus->Status;
			if ($errStatus == ComError::ERR_INVALID_ADAPTER_ID 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage;
			}
			else
			{
				$this->xmlRet->Url = "";
			}
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
		
		$display = new XMLRetDisplayer();
		$display->assignSmarty($this->smarty);
		$display->display($this->xmlRet);
	}
	
	public function displayResultXML()
	{
		$this->TplFile = "SSDVolumeAllocationBar.tpl";
		$this->initPara();
		$this->setSSDVolumeAllocation();
		
		if ($this->ApiCmd->getResult() != null && $this->ApiCmd->getResult()->RetVal . "") {
			$this->setGetAllocationCmdXmlRetFailed();
		}
		else 
		{
			$this->smarty->display($this->TplFile);
		}
		
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}

?>