<?php
class CtnCreateLDMaxSize extends Container
{
	private $HDIDs = array();
	private $RaidMode;
	private $NumParityDisk;
	private $UseThorSizePolicy = 0;
	
	public function addHDID($HDID)
	{
		$this->HDIDs[] = $HDID;
	}
	
	public function setRaidMode($RaidMode)
	{
		$this->RaidMode = $RaidMode;
	}
	
	public function setNumParityDisk($NumParityDisk)
	{
		$this->NumParityDisk = $NumParityDisk;
	}
	
	protected function setBase()
	{
		$this->base = new CreateLDMaxSize();
		$this->base->setAdapterID($this->getAdapterID());
		
		foreach ($this->HDIDs as $HDID)
		{
			$this->base->addHDID($HDID);
		}
		
		//use 1024*1024*1024 if is Thor
	/*	if (sizeof($this->HDIDs)) {
			$hdid = $this->HDIDs[0];
			$hdDtl = new HdDetail();
			$hdDtl->setID($hdid);
			$hdDtl->toGetHDInfo();
			$hdDtl->initData();
			$base = $hdDtl->getBaseClasses();
			$hd = $base[0];
			$HBAID = $hd->getAdapterID();
			$sysFeature = AdapterFeature::getInstance($HBAID);
			$this->UseThorSizePolicy = $sysFeature->isThor;
		}*/
		$this->base->setRaidMode($this->RaidMode);
		$this->base->setNumParityDisk($this->NumParityDisk);
		$this->base->toGetMaxSize();
	}

	protected function setDataToPage()
	{
		$size = $this->base->getBaseDetail();
		if (isset($size)) {
			$sysFeature = AdapterFeature::getInstance($this->getAdapterID());
			$this->UseThorSizePolicy = $sysFeature->isThor;
			$this->smarty->assign("CreateLDMaxSizeGB",FormatSize($size,$this->UseThorSizePolicy));
			$MaxSize = ConvertSize($size,$this->UseThorSizePolicy);
			$this->smarty->assign("CreateLDMaxSize",$MaxSize);
		}
		else {
			$this->smarty->assign("CreateLDMaxSizeGB",gettext("Select disk(s)"));
		}
	}
	
	public function displayXML()
	{
		$this->display("CreateLDMaxSize.tpl");
	}
}
?>