
//Tree part
var MarvellRaidTree = new Object();
MarvellRaidTree.SYSTEM_LEAF = 0;
MarvellRaidTree.ADAPTER_TITLE_LEAF = 1;
MarvellRaidTree.ADAPTER_LEAF = 2;
MarvellRaidTree.ARRAY_TITLE_LEAF = 3;
MarvellRaidTree.ARRAY_LEAF = 4;
MarvellRaidTree.VDONARRAY_TITLE_LEAF = 5;
MarvellRaidTree.VDONARRAY_LEAF = 6;
MarvellRaidTree.HDONARRAY_TITLE_LEAF = 7;
MarvellRaidTree.HDONARRAY_LEAF = 8;
MarvellRaidTree.ENC_TITLE_LEAF = 9;
MarvellRaidTree.ENC_LEAF = 10;
MarvellRaidTree.HD_TITLE_LEAF = 11;
MarvellRaidTree.HD_LEAF = 12;
MarvellRaidTree.VD_TITLE_LEAF = 13;
MarvellRaidTree.VD_LEAF = 14;
MarvellRaidTree.BBU_TITLE_LEAF = 15;
MarvellRaidTree.BBU_LEAF = 16;    
MarvellRaidTree.HDONVD_TITLE_LEAF = 17;
MarvellRaidTree.HDONVD_LEAF = 18;
MarvellRaidTree.EXP_LEAF = 19;
MarvellRaidTree.PM_LEAF = 20;
MarvellRaidTree.AES_LEAF = 21;
MarvellRaidTree.AES_TITLE_LEAF = 22;
MarvellRaidTree.SSD_VOLUME_LEAF = 23;
MarvellRaidTree.SSD_VOLUME_LEAF = 23;
MarvellRaidTree.FLASH_SERVICE_LEAF = 30;
MarvellRaidTree.SCHEDULE_SETTING_LEAF = 38;
MarvellRaidTree.SSD_ADAPTER_LEAF = 50;
MarvellRaidTree.HYPER_SSD_LEAF = 51;


MarvellRaidTree.currentNodeTypeId = 00;

MarvellRaidTree.url = "";

MarvellRaidTree.oDiv = null;
MarvellRaidTree.currentNode = "treelink_"+MarvellRaidTree.SYSTEM_LEAF+0;

function openHelpFile(isLoginPage){
	var helpfile = "WebHelp/Help.htm#";
	window.open(helpfile, '',  'width=800, height=600, resizable=1, scrollbars=1, depended=1, alwaysRaised=1');
}

MarvellRaidTree.setCurrentNode = function(node){
	MarvellRaidTree.currentNode=node;
}

MarvellRaidTree.setXMLresult= function()
{
    if (MarvellRaidTree.xml != null)
    {    	
        MarvellRaidTree.oDiv.innerHTML = MarvellRaidTree.xml.responseText;
        ContentLoader.runScript(MarvellRaidTree.xml.responseText);
        
    }
    ContentLoader.returnBack(MarvellRaidTree.xml);
    MarvellRaidTree.xml=null;
	//alert(MarvellRaidTree.currentNode);
	clickTreeNode(MarvellRaidTree.currentNode);
}

MarvellRaidTree.run = function(){
	//alert(MarvellRaidTree.url);
    var urlPath = "JumpPage.php?ra="+RefreshControl.getSeq()+"&Target=getTreeNodes";
    if(MarvellRaidTree.url)
	urlPath += "&reqNodes="+MarvellRaidTree.url;
    ContentLoader.loadXMLDoc(MarvellRaidTree,urlPath);
    urlPath=null;
}

function sendChange(identify,expand)
{
    var s = oldURL.indexOf(identify);
    var tmpurl = oldURL.substr(0,s);
	expand = expand.substr(1,expand.length-1); //cut "_"
    tmpurl = tmpurl+ identify + expand;
    tmpurl += oldURL.substr(s+expand.length+identify.length);
    MarvellRaidTree.url = tmpurl;
    MarvellRaidTree.run();
    tmpurl = null;
}

function sendDetail(url)
{
	MarvellRaidDetail.partUrl = url;
	MarvellRaidDetail.run();
}

MarvellRaidTree.rescan=function(){
	MarvellRaidTree.run();
}

var preoA=null;

function highLight(oA)
{
    if (preoA!=null)
    {
        preoA.className  = "treeHyperlink";
    }
	if (oA)
	{
		oA.className ="treeSelectedHyperlink";

		//get current tree node type and id
		oAId = oA.id;
		oAIdArr = oAId.split("_");
		MarvellRaidTree.currentNodeTypeId = oAIdArr[1];
		MarvellRaidTree.currentNode="treelink_"+MarvellRaidTree.currentNodeTypeId;
		var cookieStr = getCookieValue(MarvellRaidDetail.reqID);
		if (cookieStr) {
			if (cookieStr.search(/TreeNodeType/) == -1){
				cookieStr += "&TreeNodeType:"+MarvellRaidTree.currentNodeTypeId;
			} else {
				var crumbValue = getCookieCrumbValue(cookieStr, "TreeNodeType");
				cookieStr=cookieStr.replace(crumbValue, MarvellRaidTree.currentNodeTypeId);
				crumbValue = getCookieCrumbValue(cookieStr, "TreeNodeType");
			}
			Remember_Cookie(MarvellRaidDetail.reqID+"="+cookieStr);
		}
	}
	preoA = oA;
}

saveCookie = function ()
{
	var strcookie = 'MSUTreeCookie=' + oldURL;
	if (preoA!=null)
	{
	    strcookie += ":"+ preoA.id;
	}
	document.cookie = strcookie;
}

loadCookie = function ()
{
		var strcookie = document.cookie.split('; ');

		for (var i=0; i < strcookie.length; i++) {
			var strkey = strcookie[i].split('=');
			if (('MSUTreeCookie' == strkey[0]) && (strkey.length > 1)) {
				var strValue = strkey[1].split(':');
				if (strValue.length>0)
				{
				    MarvellRaidTree.run(strValue[0]);
				}
				if (strValue.length>1)
				{
				    highLight(strValue[1]);
				}
			}
		}
}

function clickTreeNode(node){
	highLight(getObjectById(node));
}


//Dynamic detail part
var MarvellRaidDetail = new Object();
MarvellRaidDetail.supportDG = 0;
MarvellRaidDetail.oDiv = null;
MarvellRaidDetail.ID=255;
MarvellRaidDetail.partUrl='';  //use system page as default
MarvellRaidDetail.reqID="MV_REFRESH";
MarvellRaidDetail.currentPageObj=null;
MarvellRaidDetail.subPageRefresh=false;
MarvellRaidDetail.DefaultPage='';
//MarvellRaidDetail.needReflash=0;
  
MarvellRaidDetail.setXMLresult= function()
{
    if (MarvellRaidDetail.xml != null)
    {    	
        MarvellRaidDetail.oDiv.innerHTML = MarvellRaidDetail.xml.responseText;
        ContentLoader.runScript(MarvellRaidDetail.xml.responseText);
        
    }
    ContentLoader.returnBack(MarvellRaidDetail.xml);
    MarvellRaidDetail.xml=null;
}

MarvellRaidDetail.run = function(){
	var partUrl;
	if (MarvellRaidDetail.partUrl && MarvellRaidDetail.partUrl.search(/Target/) != -1)
	{
		partUrl = MarvellRaidDetail.partUrl;
	} else {
		partUrl = MarvellRaidDetail.DefaultPage; //default
	}
	//to cut the redundant string such as 'http://localhost:80'
	var pos = partUrl.search('JumpPage');
	partUrl = partUrl.substring(pos);

	//clear unuseful resize functions
	clearResize();
	ClearSplitterChangeResize();

	//remove bga refresh
	if (SSDVolume.runBGA == true) SSDVolume.stopBGA();
	if (PackageVDDetail.runBGA == true) PackageVDDetail.initialize();
	if (LDDetail.runBGA == true) LDDetail.initialize();
	if (PDDetail.runBGA == true) PDDetail.initialize();
	if (DgInfo.autoRefresh == true) DgInfo.initialize();
	if (PDDetail.SSDPageRefresh == true) {
		RefreshControl.removeFunction(PDDetail.selfRefresh);
		PDDetail.SSDPageRefresh = false;
	}
	if (Accelerator.runAcc == true) Accelerator.unload();
	CreateProgress.stopLoopProgress();

	//Accelerator.stopRefreshVolumePage();

	//remove bbu page refresh
	if (MarvellRaidDetail.subPageRefresh){
		LoopControl.removeLoop("BBUPageRefresh");
		MarvellRaidDetail.subPageRefresh = false;
	}
	//remove hyperssd page refresh
	LoopControl.removeLoop("HyperSSDRefresh");

	//remove event listener
	//DgInfo.removeXMLRun();
	//LDDetail.removeXMLRun();
	//PDDetail.removeXMLRun();

	var urlPath = partUrl + "&ra="+RefreshControl.getSeq();
	ContentLoader.loadXMLDoc(MarvellRaidDetail,partUrl);

	var URL = partUrl;
	var cookieStr=getCookieValue(MarvellRaidDetail.reqID);
	var TreeNodeType;

	if (cookieStr) {
	    TreeNodeType = getCookieCrumbValue(cookieStr, "TreeNodeType");
	} else {
		TreeNodeType = "00"; //default, system node
	}
	if (TreeNodeType && URL.search(/TreeNodeType/) == -1) {
		URL += "&TreeNodeType="+TreeNodeType;
	}
	URL= URL.replace(/=/g, ':');

	Remember_Cookie(MarvellRaidDetail.reqID+"="+URL);

	urlPath=null;
}

MarvellRaidDetail.runUrl = function(url){
	MarvellRaidDetail.partUrl = url;
	MarvellRaidDetail.run();
}

MarvellRaidDetail.enableGoBtn=function()
{
	var goBtn = document.getElementById("goBtn");
    goBtn.className="buttonChar";
    goBtn.onclick=MarvellRaidDetail.doOperation;
}

MarvellRaidDetail.disableGoBtn=function(){
	var goBtn = document.getElementById("goBtn");
    goBtn.className="disButtChar";
    goBtn.onclick=doNothing;

}

MarvellRaidDetail.doOperation=function(){
	MarvellRaidDetail.disableGoBtn();
	var CMD = getCheckedFromRadio('operationRadio');
	eval(CMD);
}


//Event list part
var EventList = new Object();

EventList.oDiv = null;
EventList.xml=null;
EventList.evHeight = null;
EventList.iEventStartID=-1;
EventList.MAX_LINE=20;
EventList.MSG_CLEAR_EVENT="Do you want to clear the event logs?";
    
EventList.setXMLresult= function()
{
    if (EventList.xml != null)
    {    	
        EventList.oDiv.innerHTML = EventList.xml.responseText;
        ContentLoader.runScript(EventList.xml.responseText);
        
    	EventList.evHeight = document.getElementById("EvBody");
    }
    ContentLoader.returnBack(EventList.xml);
    EventList.xml=null;
}

EventList.run = function()
{
	//alert('run event');
//start = -1 to get last 4 event
    var urlPath = "JumpPage.php?ra="+RefreshControl.getSeq()+"&Target=getEventList&start="+EventList.iEventStartID;
    ContentLoader.loadXMLDoc(EventList,urlPath);
    urlPath=null;
}

EventList.goFirstPage = function()
{
    EventList.iEventStartID = 0;
    EventList.run();
}

EventList.goLastPage = function()
{
    EventList.iEventStartID = -1;
    EventList.run();
}

EventList.goPrevPage = function(iStart)
{
    //event id start from 0
    EventList.iEventStartID = iStart - EventList.MAX_LINE - 1;
    if (EventList.iEventStartID<0) {EventList.iEventStartID=0}
    EventList.run();
}
EventList.goNextPage = function(iEnd,iLength)
{
    //event id start from 0
    EventList.iEventStartID = iEnd;
    if (EventList.iEventStartID>=iLength-EventList.MAX_LINE) {EventList.iEventStartID=iLength-EventList.MAX_LINE+1}
    EventList.run();
}

EventList.clearEvent = function()
{
    if (confirm(EventList.MSG_CLEAR_EVENT))
    {
        var clearCMD=new Command("command.php?cmdName=clearEvents");
        clearCMD.run();
        clearCMD=null;
		EventList.run();
    }
    return false;
}

EventList.saveEvent = function()
{
    var urlPath = "JumpPage.php?ra="+RefreshControl.getSeq()+"&Target=EventsSaveFilePage";
//    var win = null;
//    if (window.ActiveXObject)
//    {
//        win = window.open(urlPath,"SaveEvent","height=1,width=1,status=no,toolbar=no,menubar=no,location=no,top =1,left=1,titlebar=no");
//        win.moveTo(-10000,-10000);
//    }
//    else
//    {
//        win = window.open(urlPath,"Save Event","top=1,left=1,status=no,scrollbars=no,dialog=no,modal=no,width=1,height=1,resizable=no");
//        win.moveTo(self.outerWidth/2,self.outerHeight /2);
//    }
//    urlPath=null;

    //var oldPath = location.href;
    location = urlPath;
    //location = oldPath;
    urlPath=null;
}

function MarvellRaidPage() {
    //link to tree part
    MarvellRaidTree.url = oldURL;
    MarvellRaidTree.oDiv=document.getElementById("TreeHtmlScrollBody");

    MarvellRaidDetail.oDiv = document.getElementById("DynamicDetailHtmlBody");
    EventList.oDiv = document.getElementById("EventListHtmlBody");

    RefreshControl.addFunction(MarvellRaidTree.run,RefreshControl.ALL_EVENT);

    //link to detail part,default system page
    RefreshControl.addFunction(MarvellRaidDetail.run,0);
    
    //link to event list
    RefreshControl.addFunction(EventList.run,RefreshControl.ALL_EVENT);
    EventList.run();

    LoopControl.addLoop(RefreshControl.listenEvent,"RefreshControl.listenEvent");
    LoopControl.start();
	var subPageUrl = getCookieValue(MarvellRaidDetail.reqID);

	if (subPageUrl){
		var TreeNodeTypeId=getCookieCrumbValue(subPageUrl, "TreeNodeType");

		if (TreeNodeTypeId != "") {
			MarvellRaidTree.currentNodeTypeId = TreeNodeTypeId;
			MarvellRaidTree.currentNode="treelink_"+TreeNodeTypeId;
			clickTreeNode(MarvellRaidTree.currentNode);

		subPageUrl=subPageUrl.replace(/:/g,"=");
		}

	}
	MarvellRaidDetail.runUrl(subPageUrl);
}

function pageResize()
{
    var pageFrame = getObjectById("pageFrame");
    setWinWidth(pageFrame);
    setWinHeight(pageFrame,108);
	//treeResize();
	resizeSplitter();
}

/*function treeResize()
{
    var pageFrame = getObjectById("pageFrame");
    var totalHeight = setWinHeight(pageFrame,108);
    var eventPart = getObjectById("MarvellRaidEventPart");
	var bottomSection = getObjectById('bottomHTMLPart');
	var eventPartHeight=0;
	if (bottomSection.style.visibility != "hidden")
	{
		eventPartHeight = eventPart.offsetHeight;
	}

	var TreeHtmlScrollBody = getObjectById("TreeHtmlScrollBody");
	if (TreeHtmlScrollBody)
	{
		var height = totalHeight - eventPartHeight - 70;
		if (height >= 0) TreeHtmlScrollBody.style.height = height;
	}

}*/

function xmlPageResize()
{
	var ScrollPart = getObjectById("ScrollPart");

	if (ScrollPart)
	{
		var TreeHeight = getObjectById("TreeHtmlScrollBody").style.height;
		TreeHeight = TreeHeight.slice(0, -2);
		var height=TreeHeight - 23;
		if (height >= 0) ScrollPart.style.height = height;
	}

    EventList.evHeight = getObjectById("EvBody");
	var bottomSection = getObjectById('bottomHTMLPart');

	bottomPartHeight=bottomSection.style.height;
	bottomPartHeight=bottomPartHeight.slice(0,-2);
	if (EventList.evHeight)
	{
		 var height = bottomPartHeight - 53;
		 if (height >= 0 && bottomSection.style.visibility != 'hidden'){
			EventList.evHeight.style.height = height;//170-60
		 }
	}
	xmlPageSubResize();
}

function xmlPageSubResize(){
	var scrollPartObj = getObjectById("ScrollPart");
	var subScrollPartObj = getObjectById("subScrollPart");
	if (scrollPartObj && subScrollPartObj) {
		var scrollPartHeight = scrollPartObj.style.height;
		scrollPartHeight = scrollPartHeight.slice(0, -2);
		subScrollPartObj.style.height = scrollPartHeight - 30;
	}

}
/*
function ExpandOrHidden(id){
	obj = document.getElementById(id);
	if (obj.style.display == 'none') {
		obj.style.display = '';
	} else {
		obj.style.display = 'none';
	}
	//xmlPageResize();
	//treeResize();
	SplitterChangeResize();
}
*/
var splitterChangeResizeFunc = new Array();
function ClearSplitterChangeResize() {
	splitterChangeResizeFunc = new Array();
	//default
	AddSplitterChangeResize(xmlPageResize);
}
function AddSplitterChangeResize(func){
	splitterChangeResizeFunc[splitterChangeResizeFunc.length] = func;
}

function SplitterChangeResize(){
	for(var i = 0; i < splitterChangeResizeFunc.length; i++){ 
		try{
			splitterChangeResizeFunc[i].call();
		} catch(e) {}
	}
}

function refreshSubPage()
{
	if (MarvellRaidDetail.partUrl && MarvellRaidDetail.partUrl.search(/Target/) != -1)
	{
		partUrl = MarvellRaidDetail.partUrl;

		//to cut the redundant string such as 'http://localhost:80'
		var pos = partUrl.search('JumpPage');
		partUrl = partUrl.substring(pos);
		ContentLoader.loadXMLDoc(MarvellRaidDetail,partUrl);
	}
}

function displayEventWindowHint(display)
{
	EventList.eventWindowHintDiv = getObjectById("eventWindowHint");
	if (EventList.eventWindowHintDiv)
	{
		if (display) {
			EventList.eventWindowHintDiv.style.display = "";

			EventList.transpTime = 5000;
			EventList.transProcess = setInterval("eventWindowTransDown()", 50);
			EventList.transpStartValue = 99;
		}else {
			EventList.eventWindowHintDiv.style.display = "none";
		}
	}	
}

function eventWindowTransDown() {
    if (EventList.eventWindowHintDiv)
    {
        EventList.eventWindowHintDiv.style.filter="alpha(opacity="+EventList.transpStartValue+")";
        EventList.eventWindowHintDiv.style.opacity=EventList.transpStartValue/100;
        EventList.transpTime = EventList.transpTime - 50;
        EventList.transpStartValue = EventList.transpStartValue - 1;
        if (EventList.transpTime <= 0){
            EventList.eventWindowHintDiv.style.display="none";
            clearInterval(EventList.transProcess);
        }
    } else {
        clearInterval(EventList.transProcess);
    }

}

function RescanAdapter()
{
        var rescanCMD=new Command("command.php?cmdName=rescanAdapter");
        rescanCMD.run();
        rescanCMD=null;
		location.reload();
}

addResize(pageResize);
addResize(xmlPageResize);
addOnLoadListener(pageResize);
addOnLoadListener(MarvellRaidPage);
addOnLoadListener(loadCookie);

