<?php
class RCTRecordList extends BaseData
{
	private $HD_ID;
	private $StartNo;
	private $RecordNum;
	private $RecordMaxNum;
	
	public function setStartNo($startNo)
	{
		$this->StartNo = $startNo;
	}
	
	public function getStartNo()
	{
		return $this->StartNo;
	}
	
	public function setRecordNum($RecordNum)
	{
		$this->RecordNum = $RecordNum;
	}

	public function setRecordMaxNum($RecordMaxNum)
	{
		$this->RecordMaxNum = $RecordMaxNum;
	}
	
	public function getRecordMaxNum()
	{
		return $this->RecordMaxNum;
	}
	
	public function setHDID($HD_ID)
	{
		$this->HD_ID = $HD_ID;
	}
	
	public function getHDID()
	{
		return $this->HD_ID;
	}
	
	public static function GetMaxRecordNum($HBA_ID, $HD_ID)
	{
		if (parent::DebugTest) {
			return 28;
		}
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_PD_RCT_GetCount);
		//$XMLApiCmd->setCommandPara("Num", "0");// 0 stand for get event start no and end no
		//$XMLApiCmd->setCommandPara("Start", "0");
		//$XMLApiCmd->setCommandPara("End", "0");
		$XMLApiCmd->setCommandPara("HD_ID", $HD_ID);
		$XMLApiCmd->setCommandPara("AdapterID", $HBA_ID);
	
		if ($XMLApiCmd->issueCommand()) {
			$XMLRoot = $XMLApiCmd->getResult();
			return intval($XMLRoot->Count);
		}
		
		return 0;
	}
	
	/*   The StartNo >= 0 and <=$MaxNo - $len + 1   */
	public function checkPara()
	{
		/*$max = self::GetMaxRecordNum($this->getAdapterID(), $this->HD_ID);
		if ($max == 0) {
			$this->StartNo = 0;
			$this->RecordNum = 0;
			return;
		}
		
		$this->RecordMaxNum = $max;*/

		if ($this->RecordMaxNum == 0) {
			$this->StartNo = 0;
			$this->RecordNum = 0;
			return;
		}
		
		$MaxNo = $this->RecordMaxNum - 1;
		
		if ($this->StartNo == -1 or $this->StartNo + $this->RecordMaxNum > $MaxNo) {
			$this->StartNo = $MaxNo - $this->RecordNum + 1;
		}
		if ($this->StartNo < 0) {
			$this->StartNo = 0;
		}
	}
	
	public function prepareAPICommands()
	{
		$this->checkPara();
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_PD_GetRCT);
		$StartNo = $this->StartNo;
		
		if ($StartNo < 0 || $StartNo === null) {
			$StartNo = 0;
		}
		$EndNo = $StartNo + $this->RecordNum -1;

		$XMLApiCmd->setCommandPara("Num", $this->RecordMaxNum ."");
		$XMLApiCmd->setCommandPara("Start", $StartNo . "");
		$XMLApiCmd->setCommandPara("End", $EndNo . "");
		$XMLApiCmd->setCommandPara("HD_ID", $this->HD_ID);
		$XMLApiCmd->setCommandPara("AdapterID", $this->AdapterID);
		
		$this->XMLAPICommandList['setRecordsToBaseClass'] = $XMLApiCmd;
	}
	
	protected function setRecordsToBaseClass($data)
	{
		$XMLRoot = $data;
		if (isset($XMLRoot->Record)) {
			foreach ($XMLRoot->Record as $RecordInfo)
			{
				$rec = new RCTRecord();
				$rec->setRCTRecordInfo($RecordInfo);
				$this->BaseClasses[] = $rec;
			}
		}
	}
	
	public function setDataToBaseClass()
	{
		
	}
	
	public function loadTestData()
	{
		$Path = "../phpsrc/baseclass/testdata/hddetail/";
		$Files = array("MV_PD_GetRCT.xml");
		
		$this->EventMaxNum = self::GetMaxRecordNum(0, 0);
		$this->checkPara();
		
		foreach ($Files as $File)
		{
			$data = simplexml_load_file($Path . $File);
			$this->setRecordsToBaseClass($data);
		}
	}
}

?>