<?php
abstract class SSDVolumeBase extends BaseFactory 
{
	public function toGetSSDVolumeInfo()
	{
		$handler = new SSDVolumeXMLHandler();
		$this->runCommand(XMLAPICommand::MV_SSD_GetVolumnInfo, $handler);
	}
	
	public function toGetBlockInfo()
	{
		$blkList = new BlockList();
		$blkList->setAdapterID($this->getAdapterID());
		$blkList->toGetBlkInfo();
		
		foreach ($this->BaseClasses as $volume)
		{
			$blkIds = $volume->getBlockIDList();
			foreach ($blkIds as $id)
			{
				$blk = $blkList->getObj($id);
				if ($blk) {
					$volume->addBlock($blk);
				}
			}
		}
	}
	
	public function toGetHDInfo()
	{
		$hdList = new HdList();
		$hdList->setAdapterID($this->getAdapterID());
		$hdList->toGetHDInfo();
		
		foreach ($this->BaseClasses as $volume)
		{
			$blks = $volume->getBlockList();
			
			foreach ($blks as $blk)
			{
				$hd = $hdList->getObj($blk->getHDID());
				if($hd) {
					$blk->linkHD($hd);
				}
			}
		}
	}
	
	protected function createObject()
	{
		return new SSDVolume();
	}
}
?>