<?php

include_once("../phpsrc/include.php");

include_once("../phpsrc/action/UserAction.class.php");
include_once("../phpsrc/action/ActionOnDG.class.php");
include_once("../phpsrc/action/XMLRet.class.php");

include_once("../phpsrc/action/ActionInitLD.class.php");
include_once("../phpsrc/action/ActionCheckLD.class.php");
include_once("../phpsrc/action/ActionMigrateLD.class.php");
include_once("../phpsrc/action/ActionRebuildLD.class.php");
include_once("../phpsrc/action/ActionMediaPatrolPD.class.php");
include_once("../phpsrc/action/ActionMigrateDG.class.php");
include_once("../phpsrc/action/ActionRebuildDG.class.php");
include_once("../phpsrc/action/ActionAcceleratorMaintain.class.php");
include_once("../phpsrc/action/ActionRechargeBBU.class.php");

$index = getRequestPara('index');

if ($index != null) {
	$da = new BGAJobDataAccess();
	$job = $da->getBGAJobByID($index);
	if ($job) {
		setUrlParaToRequest($job);
		runBGAJob($job);
	}
}

//for action get parameter from request
//so here set para to $_GET
function setUrlParaToRequest($job)
{
	$cmdPara = $job->getCmdPara();
	$VDID = $job->getVDID();
	
	$cmdParaArr = explode('|',$cmdPara);
	
	foreach ($cmdParaArr as $para)
	{
		$idx = strpos($para,'-');
		
		if ($idx !== false) {
			$name = trim(substr($para,0,$idx));
			$value = trim(substr($para,$idx+1));
			$_GET[$name] = $value;
		}
	}
	
	//add LDID 
	$_GET['LDID'] = $VDID;
	$_GET['LD_ID'] = $VDID;
}

//run bga job
//by reuse action class.
function runBGAJob($job)
{
	$jobID = $job->getIndex();
	
	$bgaType = $job->getBgaType();
	
	$action = null;
	switch ($bgaType)
	{
		case ScheduledBGAType::LD_BGA_CONSISTENCY_CHECK :
		case ScheduledBGAType::LD_BGA_CONSISTENCY_FIX :
			$action = new ActionCheckLD();
			//may add ActionCheckVdOnDg
			break;
		case ScheduledBGAType::LD_BGA_INIT_BACK :
			$action = new ActionInitLD();
			//may add ActionInitVdOnDg
			break;
		case ScheduledBGAType::LD_BGA_MIGRATION :
			$action = new ActionMigrateLD();
			break;
		case ScheduledBGAType::LD_BGA_REBUILD :
			$action = new ActionRebuildLD();
			break;
		case ScheduledBGAType::HD_BGA_MP :
			$action = new ActionMediaPatrolPD();
                        break;
		case ScheduledBGAType::DG_BGA_MIGRATION :
			$action = new ActionRebuildDG();
                        break;
		case ScheduledBGAType::DG_BGA_REBUILD :
			$action = new ActionMigrateDG();
                        break;
		case ScheduledBGAType::BBU_BGA_RELEARN :
			$action = new ActionRechargeBBU();
                        break;
        case ScheduledBGAType::ACCELERATOR_AUTO :
            $action = new ActionAcceleratorMaintain();
                        break;
		default:
			break;
	}
	
	if ($action != null) {
		$xmlRet = $action->doBGAAction();
		
		//executed result to job
		if ($xmlRet->RetVal == XMLRet::Success) {
			$job->setResult(ScheduleResultType::SUCCESS);
			$job->setResultText('success');
		}
		else {
			$job->setResult(ScheduleResultType::FAILED);
			$job->setResultText($xmlRet->Msg);
		}
		$job->setStatus(ScheduleStatus::RUN);
		
		$nowTime = getNow();
		$now = date('YmdHi',strtotime($nowTime));
		$job->setStartTime($now);
		
		//update bga job schedule
		$da = new BGAJobDataAccess();
		$da->updateJobRunResultByID($jobID,$job);
	}
}
?>
<HTML>
<HEAD>
<meta http-equiv="pragma" content="no-cache">
<TITLE>Marvel RAID Application :- BGA Schedule Message</TITLE>
<SCRIPT language='JavaScript'>
	function doLoad(){ 
		setTimeout( 'closeMe()', 1000); 
	}
	function closeMe(){ 
		self.close();
	}
</SCRIPT>
</HEAD>
<BODY onload="closeMe()">
<center>
<font size="2">
</font>
<br><br><input type="button" value="Close" onClick="self.close();">
</center>
</BODY>
</HTML>

