/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.IMainWindow;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;

public class MoveSensors {
    protected static final int MINIMAL_COL_WIDTH = 50;
    private DataBindingContext m_bindingContext;
    protected Shell shlMoveSensorTo;
    private Display display;
    private Table devicesTable;
    private ArrayList<Device> _devices = null;
    private ArrayList<Sensor> _sensorsToMove = null;
    private TableViewer tableViewer;
    private IMainWindow _parent;
    private Button btnOk;

    public MoveSensors(IMainWindow parent, ArrayList<Sensor> sensors) {
        this._parent = parent;
        ArrayList<Device> pdtDevices = DataStore.getInstance().getCurrentPdtFile().getDevices();
        ArrayList<Device> sourceDevices = new ArrayList<Device>();
        for (Sensor sensor : sensors) {
            ArrayList<Device> devices = DataStore.getInstance().getDevicesOfSensor(sensor);
            for (Device device : devices) {
                if (sourceDevices.contains(device)) continue;
                sourceDevices.add(device);
            }
        }
        if (sourceDevices.size() == 0) {
            return;
        }
        this._devices = new ArrayList();
        for (Device device : pdtDevices) {
            if (sourceDevices.size() <= 1 && ((Device)sourceDevices.get(0)).equals(device)) continue;
            this._devices.add(device);
        }
        this._sensorsToMove = sensors;
    }

    public void moveSensors() {
        if (this.devicesTable.getSelectionCount() != 1 || this._sensorsToMove == null) {
            return;
        }
        Device selectedDevice = (Device)this.devicesTable.getSelection()[0].getData();
        for (Sensor sensor : this._sensorsToMove) {
            ArrayList<Device> devicesOfSensor = DataStore.getInstance().getDevicesOfSensor(sensor);
            if (devicesOfSensor != null) {
                for (Device device : devicesOfSensor) {
                    device.removeSensor(sensor);
                }
            }
            selectedDevice.addSensor(sensor);
        }
        this._parent.setModified();
        this.shlMoveSensorTo.close();
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.shlMoveSensorTo.open();
        this.shlMoveSensorTo.layout();
        while (!this.shlMoveSensorTo.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void createContents() {
        this.shlMoveSensorTo = new Shell(65632);
        this.shlMoveSensorTo.setImage(SWTResourceManager.getImage(SensorModifier.class, "/resources/Intel.ico"));
        this.shlMoveSensorTo.setText("Move Sensor(s) to Device");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlMoveSensorTo, 1);
        GuiUtils.addLabelToComposite("Please select the target device from the list below.\r\nTo add a new device, click \u2018Cancel\u2019, right-click on the sensor tree, and select \r\n\u2018Add Device\u2019.", (Composite)this.shlMoveSensorTo, 0, 16384, 0x1000000, false, false, 1, 1);
        this.tableViewer = new TableViewer((Composite)this.shlMoveSensorTo, 67584);
        this.devicesTable = this.tableViewer.getTable();
        this.devicesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.devicesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MoveSensors.this.devicesTable.getSelectionCount() > 0) {
                    MoveSensors.this.btnOk.setEnabled(true);
                } else {
                    MoveSensors.this.btnOk.setEnabled(false);
                }
            }
        });
        this.devicesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                MoveSensors.this.moveSensors();
            }
        });
        this.devicesTable.setLinesVisible(true);
        this.devicesTable.setHeaderVisible(true);
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDeviceName = tableViewerColumn.getColumn();
        tblclmnDeviceName.addControlListener((ControlListener)resizeColHandler);
        tblclmnDeviceName.setText("Device Name");
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnProductId = tableViewerColumn_1.getColumn();
        tblclmnProductId.addControlListener((ControlListener)resizeColHandler);
        tblclmnProductId.setText("Product ID");
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnVendorId = tableViewerColumn_2.getColumn();
        tblclmnVendorId.addControlListener((ControlListener)resizeColHandler);
        tblclmnVendorId.setText("Vendor ID (Hex)");
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlMoveSensorTo, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        this.btnOk = GuiUtils.addButtonToComposite("OK", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MoveSensors.this.shlMoveSensorTo.close();
            }
        });
        this.btnOk.setEnabled(false);
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MoveSensors.this.moveSensors();
            }
        });
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.btnOk);
        int longTableItemWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.btnOk) * 2.1);
        int shortTableItemWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.btnOk) * 1.8);
        ((GridData)this.btnOk.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        tblclmnDeviceName.setWidth(longTableItemWidth);
        tblclmnProductId.setWidth(shortTableItemWidth);
        tblclmnVendorId.setWidth(shortTableItemWidth);
        ((GridData)this.devicesTable.getLayoutData()).widthHint = GuiUtils.getButtonWidth((Control)this.btnOk) * 5;
        ((GridData)this.devicesTable.getLayoutData()).heightHint = (int)((double)GuiUtils.getButtonWidth((Control)this.btnOk) * 1.5);
        this.shlMoveSensorTo.setSize(this.shlMoveSensorTo.computeSize(-1, -1));
        this.shlMoveSensorTo.setLocation(GuiUtils.getMiddleLocation(this.shlMoveSensorTo, this.display));
        this.m_bindingContext = this.initDataBindings();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMap = PojoObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Device.class, (String[])new String[]{"deviceShortName", "productId", "hexVendorId"});
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.tableViewer.setContentProvider((IContentProvider)listContentProvider);
        IObservableList selfList = Properties.selfList(Device.class).observe(this._devices);
        this.tableViewer.setInput((Object)selfList);
        return bindingContext;
    }
}

