/* hardwareInterface.i */
%typemap(out) uint32_t * {
    uint32_t len = HW_BlockReadQueueSize();
    uint32_t i;

    $result = PyList_New(len);
    for (i = 0; i < len; ++i) {
        PyList_SetItem($result, i, PyInt_FromLong((long) $1[i]));
    }
}

/* standard hwInterface.h functions */
uint32_t HW_Initialize ();

void HW_SetExceptionObject(PyObject *);

uint32_t HW_NumberOfDevices ();		
%rename(HW_DeviceList) wrap_HW_DeviceList;
%inline %{
PyObject * wrap_HW_DeviceList()
{
    char **devices;
    uint32_t numDevices;
    uint32_t i;
    PyObject * retval;

    numDevices = HW_NumberOfDevices();
    retval = PyList_New(numDevices);

    devices = HW_DeviceList();
    for (i = 0; i < numDevices; i++)
    {
        PyList_SetItem(retval, i, PyString_FromString(devices[i]));
    }

    return retval;
}
%}
char* HW_Device (const uint32_t);
char* HW_Device_FullName (const uint32_t);
char* HW_Device_Revision (const uint32_t);
uint32_t HW_DeviceNumber (const char* boardName);
uint32_t HW_Open (const char* boardName);
void HW_Close ();
/* void AQ_API_MDIO_Write (uint32_t, uint32_t, uint32_t, uint32_t); */
/* uint32_t AQ_API_MDIO_Read (uint32_t, uint32_t, uint32_t); */

/* 
 * Extended functions 
 */
uint32_t  HW_GetDefaultAdapter ();
uint32_t  HW_SetDefaultAdapter ( const uint32_t adapterNumber);
uint32_t  HW_OpenAdapter(uint32_t adapterNumber);

void      HW_CloseAdapter (uint32_t adapterNumber);
uint32_t  HW_GetDeviceParameters( uint32_t adapterNumber, uint32_t param);
void	  HW_SetDeviceParameters( uint32_t adapterNumber, uint32_t param, uint32_t value );
void      HW_Write (uint32_t, uint32_t, uint32_t, uint32_t, uint32_t);
uint32_t  HW_Read (uint32_t, uint32_t, uint32_t, uint32_t);
void      HW_BlockRead (uint32_t, uint32_t, uint32_t);
void      HW_BlockWrite (uint32_t, uint32_t, uint32_t, uint32_t);
uint32_t* HW_BlockOperationExecute (uint32_t);
void      HW_BlockReadAdapter (uint32_t, uint32_t, uint32_t, uint32_t);
void      HW_BlockWriteAdapter (uint32_t, uint32_t, uint32_t, uint32_t, uint32_t);

%callback("%s_cb");
void      HW_Write8 (uint32_t, uint32_t, uint32_t, uint8_t);
void      HW_Write16 (uint32_t, uint32_t, uint32_t, uint16_t);
void      HW_Write32 (uint32_t, uint32_t, uint32_t, uint32_t);
uint8_t  HW_Read8 (uint32_t, uint32_t, uint32_t);
uint16_t  HW_Read16 (uint32_t, uint32_t, uint32_t);
uint32_t  HW_Read32 (uint32_t, uint32_t, uint32_t);
void      HW_API_Write8 (uint32_t, uint32_t, uint8_t);
void      HW_API_Write16 (uint32_t, uint32_t, uint16_t);
void      HW_API_Write32 (uint32_t, uint32_t, uint32_t);
uint8_t  HW_API_Read8 (uint32_t, uint32_t);
uint16_t  HW_API_Read16 (uint32_t, uint32_t);
uint32_t  HW_API_Read32 (uint32_t, uint32_t);
void      HW_BlockRead32 (uint32_t, uint32_t);
void      HW_BlockWrite32 (uint32_t, uint32_t, uint32_t);
void      HW_BlockRead32Adapter (uint32_t, uint32_t, uint32_t);
void      HW_BlockWrite32Adapter (uint32_t, uint32_t, uint32_t, uint32_t);

void      HW_Write64 (uint32_t, uint32_t, uint32_t, uint64_t);
uint64_t  HW_Read64 (uint32_t, uint32_t, uint32_t);
void      HW_API_Write64 (uint32_t, uint32_t, uint64_t);
uint64_t  HW_API_Read64 (uint32_t, uint32_t);
void      HW_BlockRead64 (uint32_t, uint32_t);
void      HW_BlockWrite64 (uint32_t, uint32_t, uint64_t);
void      HW_BlockRead64Adapter (uint32_t, uint32_t, uint32_t);
void      HW_BlockWrite64Adapter (uint32_t, uint32_t, uint32_t, uint64_t);

uint32_t *HW_BlockOperationExecuteAdapter (uint32_t, uint32_t);
%nocallback;
uint32_t  HW_Fail ();
char     *HW_Error ();

void      Board_Write (uint32_t address, uint32_t data);
uint32_t  Board_Read (uint32_t address);
void      Board_WriteAdapter (uint32_t address, uint32_t address, uint32_t data);
uint32_t  Board_ReadAdapter (uint32_t address, uint32_t address);

//void      Board_Write32 (uint32_t address, uint32_t data);
//uint32_t  Board_Read32 (uint32_t address);
//void      Board_Write32Adapter (uint32_t adapterNumber, uint32_t address, uint32_t data);
//uint32_t  Board_Read32Adapter (uint32_t adapterNumber, uint32_t address);

void      AQ_API_MDIO_Write (uint32_t, uint32_t, uint32_t, uint32_t);
uint32_t  AQ_API_MDIO_Read (uint32_t, uint32_t, uint32_t);

uint32_t  HW_GetDefault_PHY_ID ();
void      HW_SetDefault_PHY_ID (const uint32_t PHY_ID);
void      AQ_API_MDIO_Write_Default_PHY_ID (uint32_t MMD, uint32_t address, uint32_t data);
uint32_t  AQ_API_MDIO_Read_Default_PHY_ID (uint32_t MMD, uint32_t address);
void      AQ_API_MDIO_BlockWrite_Default_PHY_ID (uint32_t MMD, uint32_t address, uint32_t data);
void      AQ_API_MDIO_BlockRead_Default_PHY_ID (uint32_t MMD, uint32_t address);
void      HW_BlockRead_Default_PHY_ID (uint32_t MMD, uint32_t address);
void      HW_BlockWrite_Default_PHY_ID (uint32_t MMD, uint32_t address, uint32_t data);
uint32_t  HW_Read_Default_PHY_ID (uint32_t MMD, uint32_t address);
void      HW_Write_Default_PHY_ID (uint32_t MMD, uint32_t address, uint32_t data);

uint32_t  AQ_API_MDIO_MaxBlockOperations ();
uint32_t *AQ_API_MDIO_BlockOperationExecute(uint32_t DEV_ID);
void      AQ_API_MDIO_BlockWrite (uint32_t DEV_ID, uint32_t mmd, uint32_t address, uint32_t data);
void      AQ_API_MDIO_BlockRead (uint32_t DEV_ID, uint32_t mmd, uint32_t address);
uint32_t  HW_BlockReadQueueSize ();

/* 
 * Logging functions 
 */
/* Open a stdio FILE* for writing. */
%typemap(in) FILE* {
    if ( PyString_Check($input) ){
        $1 = fopen(PyString_AsString($input), "w");
        if (!$1) {
            PyErr_SetString(PyExc_TypeError, "Could not open log file for writing.");
            return NULL;
        }
    } else {
        PyErr_SetString(PyExc_TypeError, "$1_name must be a file name string.");
        return NULL;
    }
}

void HW_EnableLoggingStdout ();
void HW_EnableLoggingStderr ();
void HW_EnableLogging (FILE*);
void HW_DisableLogging (int);
void HW_EnablePyLogging( PyObject *logger, PyObject *levels );

void HW_LogMsg (const char* msg);

/* Translate a string describing a part number to the part number enum. */
%typemap(in) PartNumber {
    if ( PyString_Check($input) ){
        $1 = getPartNumber(PyString_AsString($input));
    } else {
        PyErr_SetString(PyExc_TypeError, "$1_name must be a valid PartNumber.");
        return NULL;
    }
}
#ifdef REGLIBLOGGING
uint32_t HW_Logging_SetPartNumberMapping (uint32_t adapterNumber, uint32_t PHY_ID, PartNumber pn);
#endif
