/* hwInterfaceExtendedUsb.h */

/*! \file
    This file contains the extended functionality function prototypes for interfacing with USB hardware boards.
    
*/




#ifndef HW_INTERFACE_EXTENDED_USB_TOKEN
#define HW_INTERFACE_EXTENDED_USB_TOKEN

#ifndef DLLEXPORT
#ifdef WIN32
#define DLLEXPORT __declspec(dllexport)
#else
#define DLLEXPORT
#endif
#endif

#ifdef __cplusplus
  extern "C" {
#endif

#include <stdio.h>
#include <stdint.h>

/*! \defgroup HW_Interface_Extended HW Interface Extended
This module contains the extended functionality function prototypes for interfacing with system hardware boards.
 @{
*/

#ifndef HWI_RUNTIME_DYNLINKING
	  DLLEXPORT int HW_USB_Control_Transfer(
		  uint8_t request_type, uint8_t bRequest, uint16_t wValue, uint16_t wIndex,
		  unsigned char *usbData, uint16_t wLength, unsigned int timeout);
#else
	  typedef int(__cdecl *HW_USB_Control_Transfer)(
		  uint8_t request_type, uint8_t bRequest, uint16_t wValue, uint16_t wIndex,
		  unsigned char *usbData, uint16_t wLength, unsigned int timeout);
#endif

#ifndef HWI_RUNTIME_DYNLINKING
	  DLLEXPORT int HW_USB_Bulk_Transfer(
		  uint8_t endpoint, unsigned char *usbData, int length, int *usb_actual_length, unsigned int timeout);
#else
	  typedef int(__cdecl *HW_USB_Bulk_Transfer)(
		  uint8_t endpoint, unsigned char *usbData, int length, int *usb_actual_length, unsigned int timeout);
#endif

#ifndef HWI_RUNTIME_DYNLINKING
	  DLLEXPORT int HW_USB_Interrupt_Transfer(
		  uint8_t endpoint, unsigned char *usbData, int length, int *usb_actual_length, unsigned int timeout);
#else
	  typedef int(__cdecl *HW_USB_Interrupt_Transfer)(
		  uint8_t endpoint, unsigned char *usbData, int length, int *usb_actual_length, unsigned int timeout);
#endif

#ifndef HWI_RUNTIME_DYNLINKING
	  DLLEXPORT void* HW_USB_Get_Device_Handle(void);
#else
	  typedef void*(__cdecl *HW_USB_Get_Device_Handle)();
#endif

#ifndef HWI_RUNTIME_DYNLINKING
	  DLLEXPORT void* HW_USB_Dev_Mem_Alloc(size_t length);
#else
	  typedef void*(__cdecl *HW_USB_Dev_Mem_Alloc)(size_t length);
#endif

#ifndef HWI_RUNTIME_DYNLINKING
	  DLLEXPORT int HW_USB_Dev_Mem_Free(unsigned char *buffer, size_t length);
#else
	  typedef int(__cdecl *HW_USB_Dev_Mem_Free)(unsigned char *buffer, size_t length);
#endif

#ifdef __cplusplus
  }
#endif

#endif
