/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.service;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.ObservableModel;
import com.intel.sensing.fdk.model.dao.DaoFactory;
import com.intel.sensing.fdk.model.dao.ModuleDao;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.persistence.cache.Impl.InstalledModuleCacheManager;
import com.intel.sensing.fdk.model.persistence.cache.api.ModuleFolderCache;
import com.intel.sensing.fdk.model.service.PersistenceServiceListenName;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class InstalledModuleService
extends ObservableModel
implements PropertyChangeListener {
    private List<ModuleEntity> installedModuleList;
    private static InstalledModuleService _instance;
    private InstalledModuleCacheManager _installedModuleCacheMgr;
    private ModuleDao _moduleDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InstalledModuleService init() throws ISSException, IOException {
        if (_instance != null) return _instance;
        Class<InstalledModuleService> clazz = InstalledModuleService.class;
        synchronized (InstalledModuleService.class) {
            if (_instance != null) return _instance;
            _instance = new InstalledModuleService();
            _instance._init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private void _init() throws ISSException, IOException {
        this._installedModuleCacheMgr = InstalledModuleCacheManager.init();
        this._moduleDao = DaoFactory.getDao(ModuleDao.class);
        this.setInstalledModuleList(this.parse(this._installedModuleCacheMgr.getCache()));
    }

    private List<ModuleEntity> parse(ModuleFolderCache cache) {
        List moduleStrList = cache.getModulelist().stream().map(moduleFile -> ManagerFileUtils.appendPath((String)moduleFile, (String)"module.json")).filter(moduleFilePath -> moduleFilePath != null && Files.exists(moduleFilePath, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
        List<ModuleEntity> moduleEntityList = moduleStrList.stream().map(modulePath -> {
            if (new File((String)modulePath).exists()) {
                return this._moduleDao.getEntityByFilePath((String)modulePath);
            }
            return null;
        }).filter(module -> module != null).collect(Collectors.toList());
        return moduleEntityList;
    }

    public List<ModuleEntity> getInstalledModuleEntity() {
        return this.installedModuleList;
    }

    public List<String> getInstalledPackageList() {
        return this.installedModuleList.stream().map(module -> module.getPackageName()).distinct().collect(Collectors.toList());
    }

    public void setInstalledModuleList(List<ModuleEntity> installedModuleList) {
        List<ModuleEntity> oldValue = this.installedModuleList;
        this.installedModuleList = installedModuleList;
        if (oldValue != null && !oldValue.equals(installedModuleList)) {
            this.firePropertyChange(PersistenceServiceListenName.InstalledModuleService.getServiceListenName(), oldValue, installedModuleList);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().contentEquals(PersistenceServiceListenName.ModuleCacheService.getServiceListenName())) {
            this.setInstalledModuleList(this.parse(this._installedModuleCacheMgr.getCache()));
        }
    }
}

