<?php
abstract class ActionSetSpare extends UserAction 
{
	protected $HD_ID;
	protected $DG_ID;
	private $mbrChecked;
	const   MBRCheckPara = "MBRCheck";
	
	protected abstract function doSetSpare();
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	
	protected function initActionPara()
	{
		$this->HD_ID = getRequestPara("HDID");
	}
	
	private function doMBRCheck()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/HdBase.class.php");
		include_once("../phpsrc/baseclass/HdDetail.class.php");
		
		$hd = new HdDetail(); 
		$hd->setAdapterID($this->getAdapterID());
		$hd->setID($this->HD_ID);
		$hd->toGetHDInfo();
		$hd->toGetMBRInfo();
		
		$hdDtl = $hd->getBaseDetail();
		
		if ($hdDtl->getHasMBR())
		{
			$cmdName = trim(getRequestPara("cmdName"));
			$this->mbrChecked = 1;
			
			$YesUrl = getBaseURL() . PHPPageName::CmdPageName 
				. "?cmdName=" . $cmdName ;
			$YesUrl .=  "&HDID" . "=" . $this->HD_ID . "&HBAID=" . $this->getAdapterID();
			$YesUrl .=  "&" . self::MBRCheckPara  . "=" . $this->mbrChecked . "&DGID=" . $this->DG_ID;
		
			$NoUrl = getBaseURL() 
					 . PHPPageName::TargetPageName ."?Target=" . Target::getHdDetail 
					 . "&ID=" . $this->HD_ID . "&HBAID=" . $this->getAdapterID();
					 
			$this->xmlRet = new ContXMLRet();
			$this->xmlRet->Msg = AlertMsg::ASSIGNSPARE_PD_MBR;
			$this->xmlRet->YesUrl = $YesUrl;
			$this->xmlRet->NoUrl = $NoUrl;
			$this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
			$this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;			
		}
		
	}
	
	protected function doAction()
	{
		if (getRequestPara(self::MBRCheckPara) == null){
			$this->doMBRCheck();
		}
	
		if ($this->xmlRet == null) {
			$this->doSetSpare();
		}
	}
}
?>