<?php
//the class for getting Migrated target LD size
class GetMigratedDgSize
{
	private $ApiCmd;
	private $TplFile;
	private $ApiCmdGetChange;
	private $smarty;
	
	private $HDs;
	private $RaidMode;
	private $DG_ID;
	private $HBAID = 0;
	private $NumOfParityDisk = 0; //default value
	
	private function initPara()
	{
		$this->DG_ID = getRequestPara("DGID");
		$this->HBAID = getRequestPara("HBAID");
		$this->HDs = getRequestPara("HDs");
		$this->RaidMode = getRequestPara("RaidMode");
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID6 
			|| $this->RaidMode == RAIDMode::LD_MODE_RAID60) {
			$this->NumOfParityDisk = getRequestPara("NumOfParityDisk");
		}
	}
	
	private function setMigrateDgSize()
	{
		$Cmd = new XMLAPICommand();
		$Cmd->setCommand(XMLAPICommand::MV_DG_GetSizeOnly );
		$Cmd->setCommandPara("AdapterID",$this->HBAID);
		$Cmd->setCommandPara("RaidMode",$this->RaidMode);
		$Cmd->setCommandPara("NumParityDisk",$this->NumOfParityDisk);
		$Cmd->setCommandPara("PDIDs",$this->HDs);
		$Cmd->setCommandPara("DGID",$this->DG_ID);
		$Cmd->setCommandPara("Name","");
		$Cmd->setCommandPara("SubVDCount",0);
		$Cmd->setCommandPara("StripeBlockSize",LDStripeSize::StripeSize64K);
		$Cmd->setCommandPara("Size",0);
		$Cmd->setCommandPara("BlockSize",512);
		$Cmd->setCommandPara("InitializationOption",0);
		
		//HDCount
		$HDCount = 0;
		$hds = explode(" ",$this->HDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$HDCount ++;
			}
		}
		$Cmd->setCommandPara("PDCount",$HDCount);
		
		if ($Cmd->issueCommand()) {
			$size = $Cmd->getResult()->CreateOrModify_DG_Param->Size;
			$this->smarty->assign("MigratedSizeGB",FormatSize($size));
			$this->smarty->assign("MigratedSize",ConvertSize($size));
		}
	}
	
	private function setTestData()
	{
		$size = 123333333;
		$this->smarty->assign("MigratedSizeGB",FormatSize($size));
		$this->smarty->assign("MigratedSize",ConvertSize($size));
	}
	
	public function displayResultXML()
	{
		$this->TplFile = "XML_MigratedDgSize.tpl";
		if (BaseData::DebugTest) {
			$this->setTestData();
			$this->smarty->display($this->TplFile);
			return;
		}
		$this->initPara();
		$this->setMigrateDgSize();
		$this->smarty->display($this->TplFile);
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}
?>
