/*
 * Decompiled with CFR 0.152.
 */
package manager.sensor;

import java.util.ArrayList;
import java.util.TreeMap;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;

public class Validator {
    public static TreeMap<String, ArrayList<String>> validateDependenciesInList(ArrayList<SensorData> sensorList, ValidationType validationType) {
        TreeMap<String, ArrayList<String>> errorList = new TreeMap<String, ArrayList<String>>();
        for (SensorData sensor : sensorList) {
            if (sensor.getObjectType() != ManagerEnums.ObjectTypes.VIRTUAL) continue;
            ArrayList<String> sensorsError = new ArrayList<String>();
            for (SensorData dep : sensor.getDependencies()) {
                String err;
                if (Validator.SensorListContains(sensor, sensorList, dep, validationType) || dep.getDependencyType() != ManagerEnums.DependencyTypes.MANDATORY || sensorsError.contains(err = Validator.getDependecyString(dep, validationType))) continue;
                sensorsError.add(err);
            }
            if (sensorsError.size() <= 0) continue;
            errorList.put(sensor.getName(), sensorsError);
        }
        return errorList;
    }

    private static String getDependecyString(SensorData dep, ValidationType validationType) {
        StringBuilder string = new StringBuilder();
        string.append("TypeName = " + dep.getTypeName());
        if (dep.getModelId() != -1) {
            string.append(", ModelID = " + dep.getModelId());
            if (dep.getModelName() != null && !dep.getModelName().isEmpty()) {
                string.append(", ModelName = " + dep.getModelName());
            }
        }
        if (dep.getVendorId() != -1) {
            string.append(", VendorName = " + dep.getVendorName());
        }
        if (dep.getFlags() != null) {
            string.append(", Flags = ");
            if (dep.getFlags().get(0) == ManagerEnums.Flags.SC_LUID_FLAG_NONE) {
                string.append("BEST");
            } else {
                string.append(dep.getFlags().get(0).getFriendlyName());
            }
        }
        return string.toString();
    }

    public static ArrayList<String> validateDependenciesInImage(String elfPath) {
        ArrayList<String> errorList = new ArrayList<String>();
        return errorList;
    }

    private static boolean SensorListContains(SensorData currentAlgo, ArrayList<SensorData> selectedSensors, SensorData dependency, ValidationType validationType) {
        for (SensorData sensor : selectedSensors) {
            if (sensor.getObjectType() == ManagerEnums.ObjectTypes.LIBRARY) continue;
            boolean wasFound = true;
            if (sensor.equals(currentAlgo)) continue;
            if (dependency.getTypeId() != sensor.getTypeId()) {
                wasFound = false;
            }
            if (dependency.getModelId() != -1 && dependency.getModelId() != sensor.getModelId()) {
                wasFound = false;
            }
            if (dependency.getVendorId() != -1 && dependency.getVendorId() != sensor.getVendorId()) {
                wasFound = false;
            }
            if (dependency.getFlags() != null) {
                ManagerEnums.Flags wantedFlag = dependency.getFlags().get(0);
                switch (wantedFlag) {
                    case SC_LUID_FLAG_PHYSICAL: {
                        if (sensor.getFlags().contains((Object)ManagerEnums.Flags.SC_LUID_FLAG_PHYSICAL)) break;
                        wasFound = false;
                        break;
                    }
                    case SC_LUID_FLAG_CALIBRATED: {
                        if (sensor.getFlags().contains((Object)ManagerEnums.Flags.SC_LUID_FLAG_CALIBRATED)) break;
                        wasFound = false;
                        break;
                    }
                }
            }
            if (!wasFound) continue;
            return true;
        }
        return false;
    }

    public static enum ValidationType {
        BuildStage,
        RunStage;

    }
}

