/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.HeciConfigurationTable;
import pdtEditor.InformationStore;
import pdtEditor.gui.BusInfo;
import pdtEditor.gui.DeviceProperties;
import pdtEditor.gui.GuiUtils;
import pdtEditor.payloads.BusPayload;

public class HeciConfiguration {
    protected Shell shlHostInterfaceheci;
    private Display display;
    private BusInfo busInfo;
    private HeciConfigurationTable _heciConfig;
    GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };

    public static void main(String[] args) {
        try {
            HeciConfiguration window = new HeciConfiguration();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlHostInterfaceheci.open();
        this.shlHostInterfaceheci.layout();
        while (!this.shlHostInterfaceheci.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (DataStore.getInstance().getCurrentPdtFile() == null) {
            System.err.println("null PDT file");
        }
        this._heciConfig = DataStore.getInstance().getCurrentPdtFile().getHeciConfigurationTable();
        if (this._heciConfig == null) {
            return;
        }
        this.busInfo.fillData(this._heciConfig.getBus());
        this._properties.setModified(false);
    }

    public void saveData() {
        HeciConfigurationTable heciConfig = this._heciConfig;
        if (heciConfig == null) {
            heciConfig = new HeciConfigurationTable();
        }
        try {
            BusPayload bus = this.busInfo.busPayloadFromFields();
            heciConfig.setBus(bus);
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlHostInterfaceheci, 513);
            messageBox.setText("Bus Information");
            messageBox.setMessage(e.getMessage() != null ? e.getMessage() : "Unknown Error: " + e.getStackTrace());
            messageBox.open();
            return;
        }
        if (heciConfig.getBus() != null) {
            DataStore.getInstance().getCurrentPdtFile().addBdtObject(heciConfig);
        }
        this._properties.setModified(false);
        this.shlHostInterfaceheci.close();
    }

    protected void createContents() {
        this.shlHostInterfaceheci = new Shell(65760);
        this.shlHostInterfaceheci.setImage(SWTResourceManager.getImage(DeviceProperties.class, "/resources/Intel.ico"));
        this.shlHostInterfaceheci.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (HeciConfiguration.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(HeciConfiguration.this.shlHostInterfaceheci, 296);
                    messageBox.setText("Closing without saving");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window without saving?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlHostInterfaceheci.setText("Host Interface Configuration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlHostInterfaceheci, 1);
        try {
            int shortButtonMinWidth;
            GuiUtils.addLabelToComposite("Enter the Bus information to be used by the host interface (HECI):", (Composite)this.shlHostInterfaceheci, 0, 16384, 0x1000000, false, false, 1, 1);
            this.busInfo = new BusInfo(this._properties);
            InformationStore infoStore = InformationStore.getInstance();
            this.busInfo.filterBusTypes(infoStore.getHeciConfigRelevantBusTypes());
            this.busInfo.setBusSpeedFilter(infoStore.getHeciConfigRelevantBusSpeeds());
            this.busInfo.drawBusInfo(this.shlHostInterfaceheci, (Composite)this.shlHostInterfaceheci);
            Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlHostInterfaceheci, 0, 131072, 0x1000000, false, false, 1, 1, 2);
            Button button_1 = GuiUtils.addButtonToComposite("OK", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
            Button button = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
            ((GridData)button_1.getLayoutData()).minimumWidth = shortButtonMinWidth = GuiUtils.getButtonWidth((Control)button);
            ((GridData)button.getLayoutData()).minimumWidth = shortButtonMinWidth;
            ((GridLayout)compositeShellButton.getLayout()).verticalSpacing = 0;
            ((GridLayout)compositeShellButton.getLayout()).marginHeight = 0;
            ((GridLayout)compositeShellButton.getLayout()).marginWidth = 0;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    HeciConfiguration.this.shlHostInterfaceheci.close();
                }
            });
            button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    HeciConfiguration.this.saveData();
                }
            });
            this.shlHostInterfaceheci.setSize(this.shlHostInterfaceheci.computeSize(-1, -1));
            this.shlHostInterfaceheci.setLocation(GuiUtils.getMiddleLocation(this.shlHostInterfaceheci, this.display));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._properties.setModified(false);
    }
}

