/*
 * Decompiled with CFR 0.152.
 */
package manager.app;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import manager.app.AppData;
import manager.utils.ManagerUtils;
import manager.utils.ManagerXMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ISSApps {
    private HashMap<String, AppData> issApps = new HashMap();
    public static final String CONFIG_FILE = "config.xml";
    public static final int MAX_NAME_LENGTH = 16;
    public static final int MAX_APP_NUM = 1;
    public static final String MAX_APP_OVER_FLOW = "You cannot add more than 1 apps to a single project image.";

    public void addIssApp(AppData appData) throws Exception {
        String name = appData.getName();
        String error = "Add the ISS application  " + name + " failed.";
        if (this.issApps.containsKey(name)) {
            throw new Exception(String.valueOf(error) + "ISS app with same name has been existed");
        }
        int selectedSize = this.getSelectedApps().size();
        this.issApps.put(appData.getName(), appData);
        if (selectedSize >= 1 && appData.getSelected().booleanValue()) {
            appData.setSelected(false);
            throw new Exception(String.valueOf(error) + MAX_APP_OVER_FLOW);
        }
    }

    public void removeIssApp(String name) throws Exception {
        String error = "Can't remove the ISS application";
        if (name == null || name.isEmpty()) {
            throw new Exception(String.valueOf(error) + ": App name isn't valid.");
        }
        if (!this.issApps.containsKey(name)) {
            throw new Exception(String.valueOf(error) + ": " + name + " is not existed.");
        }
        this.issApps.remove(name);
    }

    public List<AppData> getAvailableApps() {
        ArrayList<AppData> ret = new ArrayList<AppData>();
        for (AppData ad : this.issApps.values()) {
            ret.add(ad);
        }
        return ret;
    }

    public List<AppData> getSelectedApps() {
        ArrayList<AppData> ret = new ArrayList<AppData>();
        for (AppData ad : this.issApps.values()) {
            if (!ad.getSelected().booleanValue()) continue;
            ret.add(ad);
        }
        return ret;
    }

    public void clearApps() {
        this.issApps.clear();
    }

    public static AppData parseConfigFile(String configxml) throws Exception {
        String err = "Could not parse app configure file. ";
        try {
            String version;
            Document doc = ManagerXMLUtils.getXMLDocument(new File(configxml));
            String appName = null;
            NodeList nl = doc.getElementsByTagName("Name");
            if (nl != null && nl.getLength() > 0) {
                appName = nl.item(0).getTextContent();
            }
            if (appName == null || appName.isEmpty()) {
                throw new Exception("Name isn't invalid.");
            }
            if (appName.length() > 16) {
                throw new Exception("Name's length must not be long than 16.");
            }
            AppData ret = new AppData(appName);
            nl = doc.getElementsByTagName("Description");
            if (nl != null && nl.getLength() > 0) {
                String desc = nl.item(0).getTextContent();
                ret.setDesc(desc);
            }
            if ((nl = doc.getElementsByTagName("Version")) != null && nl.getLength() > 0 && (version = nl.item(0).getTextContent()) != null && !version.isEmpty()) {
                ret.parseVersion(version);
            }
            if ((nl = doc.getElementsByTagName("Build")) != null && nl.getLength() > 0) {
                Boolean build = Boolean.parseBoolean(nl.item(0).getTextContent());
                ret.setSelected(build);
            }
            return ret;
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(err) + ManagerUtils.parseException(e));
        }
    }

    public static void createConfigFile(AppData aData, String rootFolder) throws Exception {
        try {
            Document doc = ManagerXMLUtils.getNewDocument();
            Element eRoot = doc.createElement("ISSApplication");
            doc.appendChild(eRoot);
            Element eName = ManagerXMLUtils.createTextNode(doc, "Name", aData.getName());
            eRoot.appendChild(eName);
            String needBuild = Boolean.toString(aData.getSelected());
            Element eBuild = ManagerXMLUtils.createTextNode(doc, "Build", needBuild);
            eRoot.appendChild(eBuild);
            String version = aData.getVersion();
            Element eVersion = ManagerXMLUtils.createTextNode(doc, "Version", version);
            eRoot.appendChild(eVersion);
            String desc = aData.getDesc();
            Element eDesc = ManagerXMLUtils.createTextNode(doc, "Description", desc);
            eRoot.appendChild(eDesc);
            String configFile = String.valueOf(rootFolder) + File.separator + CONFIG_FILE;
            ManagerXMLUtils.createXMLFile(configFile, doc);
        }
        catch (Exception e) {
            String err = ManagerUtils.parseException(e);
            throw new Exception("Could not create configure file." + err);
        }
    }
}

