/*
 * Decompiled with CFR 0.152.
 */
package binTools;

import binTools.Common;
import binTools.XmlExporter;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BinWriter
implements XmlExporter {
    private ArrayList<Byte> _binaryFile = new ArrayList();
    private ArrayList<Common.Field> _sizeCounters = new ArrayList();
    private Document _doc;
    private Element _head;
    private boolean _littleEndian;

    public BinWriter(boolean littleEndian, String headName) {
        this._littleEndian = littleEndian;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (docBuilder != null) {
            this._doc = docBuilder.newDocument();
            this._head = this._doc.createElement(headName);
            this._doc.appendChild(this._head);
        }
    }

    public BinWriter(boolean littleEndian) {
        this(littleEndian, "File");
    }

    public int writeBinarydata(byte[] data) {
        int firstBytePos = this._binaryFile.size();
        for (int i = 0; i < data.length; ++i) {
            this._binaryFile.add(data[i]);
        }
        return firstBytePos;
    }

    private void updateData(int offset, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this._binaryFile.set(offset + i, data[i]);
        }
    }

    public void updateData(Common.Field field, int data) {
        byte[] binary = Common.intToByteArr(field.size, data);
        if (!this._littleEndian) {
            binary = Common.getReversedSubArray(binary, 0, binary.length);
        }
        this.updateData(field.offset, binary);
        field.value = data;
        if (field.xmlElement != null) {
            field.xmlElement.setTextContent(String.valueOf(data));
        }
    }

    private void updateSizes(int toAdd) {
        for (Common.Field field : this._sizeCounters) {
            this.updateData(field, field.value + toAdd);
        }
    }

    public Common.Field writerBinaryField(String name, byte[] data, Element parent) {
        Common.Field field = new Common.Field();
        field.name = name;
        field.size = data.length;
        field.offset = this.writeBinarydata(data);
        if (name != null && this._doc != null) {
            field.xmlElement = this._doc.createElement(name);
            field.xmlElement.setTextContent(Common.bytesToHex(data));
            field.xmlElement.setAttribute("Size", String.valueOf(data.length));
            if (parent != null) {
                parent.appendChild(field.xmlElement);
            }
        }
        this.updateSizes(field.size);
        return field;
    }

    public Common.Field writerBinaryField(String name, ArrayList<Byte> data, Element parent) {
        byte[] dataArray = new byte[data.size()];
        for (int i = 0; i < dataArray.length; ++i) {
            dataArray[i] = data.get(i);
        }
        return this.writerBinaryField(name, dataArray, parent);
    }

    public Common.Field writeNewField(String name, int size, long value, Node parent) {
        byte[] data = Common.longToByteArr(value);
        data = this._littleEndian ? Common.getSubArray(data, 0, size) : Common.getReversedSubArray(data, 0, size);
        Common.Field field = new Common.Field();
        field.name = name;
        field.size = size;
        field.value = (int)value;
        field.longValue = value;
        field.offset = this.writeBinarydata(data);
        if (name != null && this._doc != null) {
            field.xmlElement = this._doc.createElement(name);
            if (size > 0) {
                field.xmlElement.setAttribute("Size", String.valueOf(size));
                if (size == 4) {
                    field.xmlElement.setTextContent(String.format("%1$02X", (int)value));
                } else {
                    field.xmlElement.setTextContent(String.format("%1$02X", value));
                }
            }
            if (parent != null) {
                parent.appendChild(field.xmlElement);
            }
        }
        this.updateSizes(field.size);
        return field;
    }

    public Common.Field writeNewField(String name, int size, int value, Node parent) {
        byte[] data = Common.intToByteArr(value);
        data = this._littleEndian ? Common.getSubArray(data, 0, size) : Common.getReversedSubArray(data, 0, size);
        Common.Field field = new Common.Field();
        field.name = name;
        field.size = size;
        field.value = value;
        field.offset = this.writeBinarydata(data);
        if (name != null && this._doc != null) {
            field.xmlElement = this._doc.createElement(name);
            if (size > 0) {
                field.xmlElement.setAttribute("Size", String.valueOf(size));
                field.xmlElement.setTextContent(String.valueOf((long)value));
            }
            if (parent != null) {
                parent.appendChild(field.xmlElement);
            }
        }
        this.updateSizes(field.size);
        return field;
    }

    public Common.Field writeNewField(String name, int size, String text, Node parent) {
        byte[] data = text.getBytes();
        byte[] zeroPaddedData = new byte[size];
        for (int i = 0; i < zeroPaddedData.length; ++i) {
            zeroPaddedData[i] = i >= data.length ? (byte)0 : data[i];
        }
        Common.Field field = new Common.Field();
        field.name = name;
        field.size = zeroPaddedData.length;
        field.value = -1;
        field.offset = this.writeBinarydata(zeroPaddedData);
        if (name != null && this._doc != null) {
            field.xmlElement = this._doc.createElement(name);
            if (data.length > 0) {
                field.xmlElement.setAttribute("Size", String.valueOf(zeroPaddedData.length));
                field.xmlElement.setTextContent(text);
            }
            if (parent != null) {
                parent.appendChild(field.xmlElement);
            }
        }
        this.updateSizes(field.size);
        return field;
    }

    public Common.Field writeNewField(String name, Node parent) {
        return this.writeNewField(name, 0, -1, parent);
    }

    public Common.Field writeNewField(int size, int value) {
        return this.writeNewField((String)null, size, value, (Node)null);
    }

    public void addComment(String comment, Element parent) {
        if (this._doc != null) {
            parent.appendChild(this._doc.createComment(comment));
        }
    }

    public void addSizeCounter(Common.Field sizeCounter) {
        this._sizeCounters.add(sizeCounter);
    }

    public void removeSizeCounter(Common.Field sizeCounter) {
        this._sizeCounters.remove(sizeCounter);
    }

    public int calcCheckSumValue() {
        long checkSumValue = 0L;
        for (int i = 0; i < this._binaryFile.size(); ++i) {
            checkSumValue += (long)this._binaryFile.get(i).byteValue();
        }
        byte checkSumByte = (byte)(checkSumValue %= 256L);
        checkSumByte = ~checkSumByte;
        checkSumByte = (byte)(checkSumByte + 1);
        return checkSumByte;
    }

    public void createBin(String fileName) throws AccessDeniedException {
        Path path = Paths.get(fileName, new String[0]);
        byte[] data = this.getBinaryContent();
        try {
            Files.write(path, data, new OpenOption[0]);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e.toString());
        }
    }

    public byte[] getBinaryContent() {
        byte[] data = new byte[this._binaryFile.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this._binaryFile.get(i);
        }
        return data;
    }

    public Element getHeadElement() {
        return this._head;
    }

    public int getBinarySize() {
        return this._binaryFile.size();
    }

    @Override
    public void exportXML(String path) throws TransformerException {
        if (this._doc != null && path != null && !path.isEmpty()) {
            Common.exportXmlDoc(this._doc, path);
        }
    }

    public void replaceHead(Element replacedHead) {
        if (this._doc != null) {
            Node newHead = this._doc.importNode(replacedHead, true);
            this._doc.removeChild(this._head);
            this._doc.appendChild(newHead);
            this._head = (Element)newHead;
        }
    }
}

