/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Stack;
import pdtEditor.IComponent;

public class Logger {
    private static Logger instance = null;
    private ArrayList<LogLine> _logContent = new ArrayList();
    private Stack<Flow> _flowStack = new Stack();

    private Logger() {
        this.setFlow(Flow.GENERAL);
    }

    public static Logger instance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public void setFlow(Flow flow) {
        this._flowStack.push(flow);
    }

    public Flow endFlow() {
        if (this._flowStack.size() == 1) {
            String msg = "No flow to end";
            this.log(LogLevel.ERROR, msg);
            System.err.println(msg);
            return null;
        }
        return this._flowStack.pop();
    }

    public void log(LogLevel level, IComponent component, String line) {
        this._logContent.add(new LogLine(level, this._flowStack.peek(), component, line));
    }

    public void log(IComponent component, String line) {
        this._logContent.add(new LogLine(null, this._flowStack.peek(), component, line));
    }

    public void log(LogLevel level, String line) {
        this._logContent.add(new LogLine(level, this._flowStack.peek(), null, line));
    }

    public void log(String line) {
        this._logContent.add(new LogLine(null, this._flowStack.peek(), null, line));
    }

    private boolean doesGroupContains(int objectsGroup, GroupableEnum object) {
        return objectsGroup < 0 || (objectsGroup & object.value()) == object.value();
    }

    public String getLogStr(LogLevel level, int flows, ArrayList<IComponent> components, int columnsToPrint) {
        StringBuilder str = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss.SSS");
        if (level == null) {
            level = LogLevel.values()[LogLevel.values().length - 1];
        }
        for (LogLine line : this._logContent) {
            if (line.getLogLevel() != null && line.getLogLevel().value() > level.value() || line.getFlow() != null && !this.doesGroupContains(flows, line.getFlow()) || components != null && line.getComponent() != null && !components.contains(line.getComponent())) continue;
            if (this.doesGroupContains(columnsToPrint, Column.DATE)) {
                str.append("[" + sdf.format(line.getTimeStamp()) + "]\t");
            }
            if (this.doesGroupContains(columnsToPrint, Column.LOG_LEVEL)) {
                str.append("[Level: " + line.getLogLevel() + "],\t");
            }
            if (this.doesGroupContains(columnsToPrint, Column.FLOW)) {
                str.append("[Flow: " + line.getFlow() + "\t");
            }
            if (this.doesGroupContains(columnsToPrint, Column.COMPONENT)) {
                str.append("[Component: " + (line.getComponent() != null ? line.getComponent() : "None") + "]\t");
            }
            if (this.doesGroupContains(columnsToPrint, Column.MESSAGE)) {
                str.append(line.getLine());
            }
            str.append('\n');
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToFile(File file, LogLevel logLevel, int flows, ArrayList<IComponent> components, int columnsToPrint) throws IOException {
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(file));
            String logStr = this.getLogStr(logLevel, flows, components, columnsToPrint);
            writer.write(logStr);
            System.out.println("Log saved at: " + file.getAbsolutePath());
        }
    }

    public void exportToFile(File file, LogLevel logLevel, int flows, int columnsToPrint) throws IOException {
        this.exportToFile(file, logLevel, flows, null, columnsToPrint);
    }

    public void exportToFile(File file, int columnsToPrint) throws IOException {
        this.exportToFile(file, null, Integer.MAX_VALUE, null, columnsToPrint);
    }

    public void exportToFile(File file, int flows, int columnsToPrint) throws IOException {
        this.exportToFile(file, null, flows, null, columnsToPrint);
    }

    public static class LogLine {
        private Date _timeStamp = new Date();
        private LogLevel _logLevel;
        private Flow _flow;
        private Object _component;
        private String _line;

        private LogLine(LogLevel logLevel, Flow flow, Object component, String line) {
            this._logLevel = logLevel != null ? logLevel : LogLevel.NOFITICATION;
            this._flow = flow != null ? flow : Flow.GENERAL;
            this._component = component;
            this._line = line;
        }

        public Date getTimeStamp() {
            return this._timeStamp;
        }

        public LogLevel getLogLevel() {
            return this._logLevel;
        }

        public Flow getFlow() {
            return this._flow;
        }

        public String getLine() {
            return this._line;
        }

        public Object getComponent() {
            return this._component;
        }
    }

    public static enum Column implements GroupableEnum
    {
        DATE,
        LOG_LEVEL,
        FLOW,
        COMPONENT,
        MESSAGE;

        private int value = 1 << this.ordinal();

        @Override
        public int value() {
            return this.value;
        }
    }

    public static enum Flow implements GroupableEnum
    {
        GENERAL,
        PDT_LOADING,
        PDT_SAVING,
        PDT_FORMAT_UPGRADE;

        private int value = 1 << this.ordinal();

        @Override
        public int value() {
            return this.value;
        }
    }

    public static enum LogLevel implements GroupableEnum
    {
        ERROR,
        WARNING,
        NOFITICATION;

        private int value = 1 << this.ordinal();

        @Override
        public int value() {
            return this.value;
        }
    }

    public static interface GroupableEnum {
        public int value();
    }
}

