/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.CalibrationParser;
import pdtEditor.Device;
import pdtEditor.IMainWindow;
import pdtEditor.Luid;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.gui.calibration.NewCalibration;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.PayloadUtils;
import pdtEditor.payloads.calibrations.CalibrationPayload;

public class ViewCalibrations
implements CalibrationEditorOpener {
    private DataBindingContext m_bindingContext;
    protected Shell shlCalibrations;
    private IMainWindow _parent = null;
    private Device _device = null;
    private boolean _modified = false;
    private ArrayList<CalibrationPayload> _calibrationCopies = new ArrayList();
    private ArrayList<Sensor> _sensorOfCalibrationCopies = new ArrayList();
    private ArrayList<Sensor> _removedCalibrationSensors = new ArrayList();
    private Display display = null;
    private Table table;
    private TableViewer tableViewer;
    private Button btnEdit;
    private Button btnDelete;
    private ViewCalibrations thisInstance = this;
    private Button btnNew;

    public ViewCalibrations(IMainWindow parent, Device device) {
        this._device = device;
        this._parent = parent;
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    System.err.println("Run only from application");
                    ViewCalibrations window = new ViewCalibrations(null, new Device(0, 0, 0, 0, null));
                    window.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.shlCalibrations.open();
        this.fillCalibrationData();
        this.shlCalibrations.layout();
        while (!this.shlCalibrations.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    @Override
    public boolean hasSensorInTable(Sensor sensor) {
        return this._sensorOfCalibrationCopies.contains(sensor);
    }

    @Override
    public void addNewCalibration(Sensor sensor, CalibrationPayload calibration) {
        for (int i = 0; i < this._sensorOfCalibrationCopies.size(); ++i) {
            if (!this._sensorOfCalibrationCopies.get(i).equals(sensor)) continue;
            int[] toRemove = new int[]{i};
            this.deleteCalibrationFromTable(toRemove);
            break;
        }
        this._sensorOfCalibrationCopies.add(sensor);
        this._calibrationCopies.add(calibration);
        this._removedCalibrationSensors.remove(sensor);
        this.addCalibrationToTable(sensor, calibration, true);
        this.setModified();
    }

    @Override
    public Device getCurrentDevice() {
        return this._device;
    }

    public void saveCalibrationData() {
        for (int i = 0; i < this._calibrationCopies.size(); ++i) {
            Sensor sensor = this._sensorOfCalibrationCopies.get(i);
            CalibrationPayload calibrationPayload = (CalibrationPayload)sensor.getPayloadByClass(CalibrationPayload.class);
            sensor.replacePayload(calibrationPayload, this._calibrationCopies.get(i));
        }
        for (Sensor sensor : this._removedCalibrationSensors) {
            sensor.removeAllPayloadsByClass(CalibrationPayload.class);
        }
        this._parent.setModified();
        this._parent.refresh();
        this._modified = false;
        this.shlCalibrations.close();
    }

    public void openCalibrationEditorScreen() {
        int selectionIndex = this.table.getSelectionIndex();
        if (selectionIndex < 0 || this.table.getSelectionCount() > 1) {
            return;
        }
        CalibrationPayload calibration = this._calibrationCopies.get(selectionIndex);
        Sensor sensor = this._sensorOfCalibrationCopies.get(selectionIndex);
        try {
            PayloadUtils.openCalibrationWindow(calibration, sensor, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.refreshCalibrationData();
    }

    public void deleteCalibrationFromTable(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.table.remove(indices);
        int deleteCounter = 0;
        for (int i = 0; i < indices.length; ++i) {
            this._calibrationCopies.remove(indices[i] - deleteCounter);
            this._removedCalibrationSensors.add(this._sensorOfCalibrationCopies.remove(indices[i] - deleteCounter));
            ++deleteCounter;
        }
        this.setDeleteEnablement();
        this.btnEdit.setEnabled(false);
        this.setModified();
    }

    public void addCalibrationToTable(Sensor sensor, CalibrationPayload payload) {
        this.addCalibrationToTable(sensor, payload, false);
    }

    public void addCalibrationToTable(Sensor sensor, CalibrationPayload payload, boolean newCalibration) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(new String[]{sensor.getLuid().getSensorTypeIdStr(), sensor.getLuid().getSensorSubTypeIdStr(), sensor.getLuid().getFlagsStr(), String.valueOf(sensor.getLuid().getInstanceId()), payload.getCalibrationFormatString()});
        if (newCalibration) {
            Color green = new Color((org.eclipse.swt.graphics.Device)this.display, 0, 102, 0);
            item.setForeground(green);
            green.dispose();
        }
        this.setDeleteEnablement();
    }

    public void addCalibrationFromSensor(Sensor sensor) {
        Payload srcPayload = sensor.getPayloadByClass(CalibrationPayload.class);
        if (srcPayload != null) {
            CalibrationPayload payload = ((CalibrationPayload)srcPayload).clone();
            this._calibrationCopies.add(payload);
            this._sensorOfCalibrationCopies.add(sensor);
            this.addCalibrationToTable(sensor, payload);
        }
    }

    public void setDeleteEnablement() {
        if (this.table.getItemCount() > 0 && this.table.getSelectionCount() > 0) {
            this.btnDelete.setEnabled(true);
        } else {
            this.btnDelete.setEnabled(false);
        }
    }

    public void browseFromCalibrationFile() {
        int i;
        FileDialog fd = new FileDialog(this.shlCalibrations, 4096);
        fd.setText("Browse Calibration Data From File");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.xml"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        CalibrationParser parser = new CalibrationParser(path);
        try {
            parser.parse();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlCalibrations, 33);
            messageBox.setText("Operation Failed");
            messageBox.setMessage("Failed to browse calibration data from file");
            messageBox.open();
            return;
        }
        ArrayList<CalibrationPayload> loadedPayloads = parser.getLoadedPayloads();
        ArrayList<Luid> luidsOfLoadedPayloads = parser.getLuidsOfLoadedPayloads();
        StringBuilder luidsNotInDevice = new StringBuilder();
        for (i = 0; i < luidsOfLoadedPayloads.size(); ++i) {
            if (this._device.getSensorByLuid(luidsOfLoadedPayloads.get(i)) != null) continue;
            luidsNotInDevice.append("* " + luidsOfLoadedPayloads.get(i).toString() + "\n");
        }
        if (luidsNotInDevice.length() > 0) {
            MessageBox messageBox = new MessageBox(this.shlCalibrations, 33);
            messageBox.setText("Operation Failed");
            messageBox.setMessage("The calibration file contains data of sensors that do not exist in the PDT:\n" + luidsNotInDevice.toString() + "Browsing failed.");
            messageBox.open();
            return;
        }
        for (i = 0; i < loadedPayloads.size(); ++i) {
            Sensor sensor = this._device.getSensorByLuid(luidsOfLoadedPayloads.get(i));
            if (sensor == null) continue;
            this.addNewCalibration(sensor, loadedPayloads.get(i));
        }
        this.refreshCalibrationData();
    }

    @Override
    public void setModified() {
        this._modified = true;
    }

    private void fillCalibrationData() {
        this.shlCalibrations.setText(this._device.getDeviceName() + " - " + this.shlCalibrations.getText());
        for (Sensor sensor : this._device.getSensorsThatHasCalibrations()) {
            this.addCalibrationFromSensor(sensor);
        }
        this.refreshCalibrationData();
    }

    @Override
    public void refreshCalibrationData() {
        this.btnNew.setEnabled(false);
        for (Sensor sensor : this._device.getSensors()) {
            if (this.hasSensorInTable(sensor)) continue;
            this.btnNew.setEnabled(true);
            break;
        }
    }

    protected void createContents() {
        this.shlCalibrations = new Shell(65760);
        this.shlCalibrations.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (ViewCalibrations.this._modified) {
                    MessageBox messageBox = new MessageBox(ViewCalibrations.this.shlCalibrations, 296);
                    messageBox.setText("Closing the calibration window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the 'Calibrations' window?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlCalibrations.setImage(SWTResourceManager.getImage(ViewCalibrations.class, "/resources/Intel.ico"));
        this.shlCalibrations.setText("Calibrations");
        this.shlCalibrations.setLayout((Layout)new GridLayout(4, false));
        this.tableViewer = new TableViewer((Composite)this.shlCalibrations, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, false, true, 4, 1));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == null) {
                    ViewCalibrations.this.table.setSelection(-1);
                }
                if (ViewCalibrations.this.table.getSelectionCount() == 1) {
                    ViewCalibrations.this.btnEdit.setEnabled(true);
                } else {
                    ViewCalibrations.this.btnEdit.setEnabled(false);
                }
                ViewCalibrations.this.setDeleteEnablement();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ViewCalibrations.this.openCalibrationEditorScreen();
            }
        });
        this.table.setFont(SWTResourceManager.getFont("Segoe UI", 9, 0));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        ((GridData)this.table.getLayoutData()).widthHint = GuiUtils.getButtonWidth((Control)this.shlCalibrations) * 9;
        ((GridData)this.table.getLayoutData()).heightHint = (int)((double)GuiUtils.getButtonWidth((Control)this.shlCalibrations) * 3.5);
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        final TableColumn tblclmnSensorType = new TableColumn(this.table, 0);
        tblclmnSensorType.addControlListener((ControlListener)resizeColHandler);
        tblclmnSensorType.setText("Sensor Type");
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnSensorModel = tableViewerColumn.getColumn();
        tblclmnSensorModel.addControlListener((ControlListener)resizeColHandler);
        tblclmnSensorModel.setText("Sensor Model");
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnFlags = tableViewerColumn_1.getColumn();
        tblclmnFlags.addControlListener((ControlListener)resizeColHandler);
        tblclmnFlags.setText("Flags");
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnInstance = tableViewerColumn_3.getColumn();
        tblclmnInstance.addControlListener((ControlListener)resizeColHandler);
        tblclmnInstance.setText("Instance");
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnCalibrationFormat = tableViewerColumn_2.getColumn();
        tblclmnCalibrationFormat.addControlListener((ControlListener)resizeColHandler);
        tblclmnCalibrationFormat.setText("Calibration Format");
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((ViewCalibrations)ViewCalibrations.this).table.getClientArea().width / 100;
                tblclmnSensorType.setWidth(oneWidth * 25);
                tblclmnSensorModel.setWidth(oneWidth * 22);
                tblclmnFlags.setWidth(oneWidth * 15);
                tblclmnInstance.setWidth(oneWidth * 8);
                tblclmnCalibrationFormat.setWidth(oneWidth * 30);
            }
        });
        Button btnBrowse = new Button((Composite)this.shlCalibrations, 0);
        GridData gd_btnBrowse = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_btnBrowse.widthHint = GuiUtils.getButtonWidth((Control)this.shlCalibrations);
        btnBrowse.setLayoutData((Object)gd_btnBrowse);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewCalibrations.this.browseFromCalibrationFile();
            }
        });
        btnBrowse.setText("Browse");
        this.btnNew = new Button((Composite)this.shlCalibrations, 0);
        GridData gd_btnNew = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnNew.widthHint = GuiUtils.getButtonWidth((Control)this.shlCalibrations);
        this.btnNew.setLayoutData((Object)gd_btnNew);
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new NewCalibration(0, ViewCalibrations.this.thisInstance, null).open();
            }
        });
        this.btnNew.setText("New");
        this.btnEdit = new Button((Composite)this.shlCalibrations, 0);
        GridData gd_btnEdit = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnEdit.widthHint = GuiUtils.getButtonWidth((Control)this.shlCalibrations);
        this.btnEdit.setLayoutData((Object)gd_btnEdit);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewCalibrations.this.openCalibrationEditorScreen();
            }
        });
        this.btnEdit.setText("Edit");
        this.btnDelete = new Button((Composite)this.shlCalibrations, 0);
        GridData gd_btnDelete = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnDelete.widthHint = GuiUtils.getButtonWidth((Control)this.shlCalibrations);
        this.btnDelete.setLayoutData((Object)gd_btnDelete);
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(ViewCalibrations.this.shlCalibrations, 200);
                messageBox.setText("Deleting Calibration");
                messageBox.setMessage("Are you sure that you want to delete the calibration of the selected sensors?");
                if (messageBox.open() == 128) {
                    return;
                }
                ViewCalibrations.this.deleteCalibrationFromTable(ViewCalibrations.this.table.getSelectionIndices());
                ViewCalibrations.this.refreshCalibrationData();
            }
        });
        this.btnDelete.setText("Delete");
        Button btnSave = new Button((Composite)this.shlCalibrations, 0);
        GridData gd_btnSave = new GridData(131072, 0x1000000, false, false, 3, 1);
        gd_btnSave.widthHint = GuiUtils.getButtonWidth((Control)this.shlCalibrations) * 3 / 2;
        btnSave.setLayoutData((Object)gd_btnSave);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewCalibrations.this.saveCalibrationData();
            }
        });
        btnSave.setText("Save and Close");
        Button btnCancel = new Button((Composite)this.shlCalibrations, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlCalibrations);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewCalibrations.this.shlCalibrations.close();
            }
        });
        btnCancel.setText("Cancel");
        this.m_bindingContext = this.initDataBindings();
        this.shlCalibrations.setSize(this.shlCalibrations.computeSize(-1, -1));
        this.shlCalibrations.setLocation(GuiUtils.getMiddleLocation(this.shlCalibrations, this.display));
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

