/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.treeViewer;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.validation.IValidatable;
import pdtEditor.validation.Issue;

public class IssuesContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static ArrayList<IValidatable> getObjectsWithActiveIssues(ArrayList<IValidatable> input) {
        ArrayList<IValidatable> res = new ArrayList<IValidatable>();
        for (IValidatable object : input) {
            if (object.getAllActiveIssues().size() <= 0) continue;
            res.add(object);
        }
        return res;
    }

    public Object[] getChildren(Object arg0) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (arg0 instanceof PdtFile) {
            PdtFile pdtFile = (PdtFile)arg0;
            ArrayList<Issue> issues = pdtFile.getAllActiveIssues();
            if (issues.size() == 0) {
                return null;
            }
            res.addAll(pdtFile.getActiveIssues());
            res.addAll(IssuesContentProvider.getObjectsWithActiveIssues(new ArrayList<IValidatable>(pdtFile.getDevices())));
            return res.toArray();
        }
        if (arg0 instanceof Device) {
            Device device = (Device)arg0;
            ArrayList<Issue> issues = device.getAllActiveIssues();
            if (issues.size() == 0) {
                return new Object[0];
            }
            res.addAll(device.getActiveIssues());
            res.addAll(IssuesContentProvider.getObjectsWithActiveIssues(new ArrayList<IValidatable>(device.getSensors())));
            return res.toArray();
        }
        if (arg0 instanceof Sensor) {
            Sensor sensor = (Sensor)arg0;
            ArrayList<Issue> issues = sensor.getAllActiveIssues();
            if (issues.size() == 0) {
                return new Object[0];
            }
            res.addAll(sensor.getActiveIssues());
            return res.toArray();
        }
        if (arg0 instanceof ArrayList) {
            res.addAll((ArrayList)arg0);
            return res.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object arg0) {
        return this.getChildren(arg0);
    }

    public Object getParent(Object arg0) {
        PdtFile pdtFile = DataStore.getInstance().getCurrentPdtFile();
        if (arg0 instanceof PdtFile) {
            return DataStore.getInstance();
        }
        if (arg0 instanceof Device) {
            return pdtFile;
        }
        if (arg0 instanceof Sensor) {
            Sensor sensor = (Sensor)arg0;
            ArrayList<Device> devicesOfSensor = DataStore.getInstance().getDevicesOfSensor(sensor);
            if (devicesOfSensor.size() == 0) {
                return null;
            }
            return devicesOfSensor.get(0);
        }
        if (arg0 instanceof Issue) {
            Issue issue = (Issue)arg0;
            return issue.getObject();
        }
        return null;
    }

    public boolean hasChildren(Object arg0) {
        Object[] children = this.getChildren(arg0);
        if (children == null) {
            return false;
        }
        return children.length > 0;
    }
}

