/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.treeViewer;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;

public class PdtContentProvider
implements ITreeContentProvider {
    private TreeViewer _viewer;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object arg0) {
        if (arg0 instanceof DataStore) {
            DataStore dataStore = (DataStore)arg0;
            return dataStore.getPdtFiles().toArray();
        }
        if (arg0 instanceof PdtFile) {
            PdtFile pdtFile = (PdtFile)arg0;
            return pdtFile.getDevices().toArray();
        }
        if (arg0 instanceof Device) {
            Device device = (Device)arg0;
            return device.getSensors().toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object arg0) {
        return this.getChildren(arg0);
    }

    public Object getParent(Object arg0) {
        PdtFile pdtFile = DataStore.getInstance().getCurrentPdtFile();
        if (arg0 instanceof PdtFile) {
            return DataStore.getInstance();
        }
        if (arg0 instanceof Device) {
            return pdtFile;
        }
        if (arg0 instanceof Sensor) {
            Sensor sensor = (Sensor)arg0;
            ArrayList<Device> devices = DataStore.getInstance().getDevicesOfSensor(sensor);
            if (devices == null || devices.size() == 0) {
                return null;
            }
            return devices.get(0);
        }
        return null;
    }

    public boolean hasChildren(Object arg0) {
        return this.getChildren(arg0).length > 0;
    }
}

