/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads;

import binTools.BinReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Luid;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.calibration.AgmVirtualCalibrationEditor;
import pdtEditor.gui.calibration.AlsCalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.gui.calibration.CustomCalibrationEditor;
import pdtEditor.gui.calibration.GeneralCalibrationEditor;
import pdtEditor.gui.calibration.NewCalibration;
import pdtEditor.gui.calibration.OnTableDetectionCalibration;
import pdtEditor.gui.calibration.SimpleDmdCalibration;
import pdtEditor.gui.configuration.AngleRegulatorConfiguration;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.gui.configuration.DevicePostureConfiguration;
import pdtEditor.gui.configuration.DynamicKeyboardLightingConfiguration;
import pdtEditor.gui.configuration.DynamicSarConfiguration;
import pdtEditor.gui.configuration.EcConfiguration;
import pdtEditor.gui.configuration.FaceDetectionConfiguration;
import pdtEditor.gui.configuration.HingeAngleConfiguration;
import pdtEditor.gui.configuration.HingeConfiguration;
import pdtEditor.gui.configuration.HumanPresenceConfiguration;
import pdtEditor.gui.configuration.HumanPresenceStandardConfiguration;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.gui.configuration.NewConfiguration;
import pdtEditor.gui.configuration.OnlookerDetectionConfiguration;
import pdtEditor.gui.configuration.SdoConfiguration;
import pdtEditor.payloads.BusPayload;
import pdtEditor.payloads.GpioPayload;
import pdtEditor.payloads.GuidPayload;
import pdtEditor.payloads.Payload;
import pdtEditor.payloads.calibrations.AgmVirtualCalibrationPayload;
import pdtEditor.payloads.calibrations.AlsCalibrationPayload;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.CustomCalibrationPayload;
import pdtEditor.payloads.calibrations.GeneralCalibrationPayload;
import pdtEditor.payloads.calibrations.OnTableDetectionCalibrationPayload;
import pdtEditor.payloads.calibrations.SimpleDmdCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualAcclCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualGyroCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualMagCalibrationPayload;
import pdtEditor.payloads.configurations.AngleRegulatorConfigurationPayload;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.payloads.configurations.DevicePostureConfigurationPayload;
import pdtEditor.payloads.configurations.DynamicKeyboardLightingPayload;
import pdtEditor.payloads.configurations.DynamicSarConfigurationPayload;
import pdtEditor.payloads.configurations.EcConfigurationPayload;
import pdtEditor.payloads.configurations.FaceDetectionConfigurationPayload;
import pdtEditor.payloads.configurations.HingeAngleConfigurationPayload;
import pdtEditor.payloads.configurations.HingeConfigurationPayload;
import pdtEditor.payloads.configurations.HumanPresenceConfigurationPayload;
import pdtEditor.payloads.configurations.HumanPresenceStandardConfigurationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import pdtEditor.payloads.configurations.OnlookerDetectionConfigurationPayload;
import pdtEditor.payloads.configurations.SdoConfigurationPayload;

public class PayloadUtils {
    public static Payload createNewPayload(Luid luid, BinReader reader, Element payloadXmlNode) throws FeatureNotSupportedYetException {
        Payload payload;
        int payloadInfoId = reader.readNewField((String)"InfoId", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        reader.readNewField("Reserved", 1, false, payloadXmlNode);
        int dataLength = reader.readNewField((String)"DataLength", (int)2, (boolean)false, (Node)payloadXmlNode).value;
        block0 : switch (payloadInfoId) {
            case 0: {
                payload = BusPayload.newBusPayload(reader, payloadXmlNode);
                break;
            }
            case 1: {
                payload = new GpioPayload(reader, payloadXmlNode);
                break;
            }
            case 2: {
                int formatId = reader.readNewField((String)"FormatId", (int)1, (boolean)false, (Node)payloadXmlNode).value;
                switch (CalibrationPayload.getCalibrationType((Luid)luid, (int)formatId, (boolean)false).get((int)0).format) {
                    case 0: {
                        payload = new GeneralCalibrationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 1: {
                        payload = new AlsCalibrationPayload(formatId, dataLength, reader, payloadXmlNode);
                        break block0;
                    }
                    case 2: {
                        payload = new VirtualAcclCalibrationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 3: {
                        payload = new VirtualGyroCalibrationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 4: {
                        payload = new VirtualMagCalibrationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 100: {
                        payload = new LidModeConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 101: {
                        payload = new EcConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 103: {
                        payload = new SdoConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 104: {
                        payload = new AngleRegulatorConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 105: {
                        payload = new HingeConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 5: {
                        payload = new OnTableDetectionCalibrationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 6: {
                        payload = new SimpleDmdCalibrationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 106: {
                        payload = new DevicePostureConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 107: {
                        payload = new DynamicSarConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 108: {
                        payload = new HumanPresenceConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 109: {
                        payload = new FaceDetectionConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 110: {
                        payload = new DynamicKeyboardLightingPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 111: {
                        payload = new HingeAngleConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 112: {
                        payload = new HumanPresenceStandardConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                    case 113: {
                        payload = new OnlookerDetectionConfigurationPayload(formatId, reader, payloadXmlNode);
                        break block0;
                    }
                }
                payload = new CustomCalibrationPayload(formatId, dataLength, reader, payloadXmlNode);
                break;
            }
            case 3: {
                payload = new GuidPayload(reader, payloadXmlNode);
                break;
            }
            default: {
                throw new RuntimeException("Error: Unrecognized info ID of payload (" + payloadInfoId + ").");
            }
        }
        return payload;
    }

    public static CalibrationEditor getCalibrationEditor(int calibrationFormatId, Sensor sensor, CalibrationEditorOpener parent) {
        switch (calibrationFormatId) {
            case 0: {
                return new GeneralCalibrationEditor(parent, null, sensor);
            }
            case 1: {
                return new AlsCalibrationEditor(parent, null, sensor);
            }
            case 2: {
                return new AgmVirtualCalibrationEditor(parent, 2, sensor);
            }
            case 3: {
                return new AgmVirtualCalibrationEditor(parent, 3, sensor);
            }
            case 4: {
                return new AgmVirtualCalibrationEditor(parent, 4, sensor);
            }
            case 5: {
                return new OnTableDetectionCalibration(parent, null, sensor);
            }
            case 6: {
                return new SimpleDmdCalibration(parent, null, sensor);
            }
        }
        return null;
    }

    public static CalibrationEditor getCalibrationEditor(CalibrationPayload calibration, Sensor detailsHolderSensor, CalibrationEditorOpener parentWindow) {
        if (calibration instanceof GeneralCalibrationPayload) {
            return new GeneralCalibrationEditor(parentWindow, (GeneralCalibrationPayload)calibration, detailsHolderSensor);
        }
        if (calibration instanceof AlsCalibrationPayload) {
            return new AlsCalibrationEditor(parentWindow, (AlsCalibrationPayload)calibration, detailsHolderSensor);
        }
        if (calibration instanceof AgmVirtualCalibrationPayload) {
            return new AgmVirtualCalibrationEditor(parentWindow, (AgmVirtualCalibrationPayload)calibration, detailsHolderSensor);
        }
        if (calibration instanceof CustomCalibrationPayload) {
            return new CustomCalibrationEditor(parentWindow, (CustomCalibrationPayload)calibration, detailsHolderSensor);
        }
        if (calibration instanceof OnTableDetectionCalibrationPayload) {
            return new OnTableDetectionCalibration(parentWindow, (OnTableDetectionCalibrationPayload)calibration, detailsHolderSensor);
        }
        if (calibration instanceof SimpleDmdCalibrationPayload) {
            return new SimpleDmdCalibration(parentWindow, (SimpleDmdCalibrationPayload)calibration, detailsHolderSensor);
        }
        return null;
    }

    public static ConfigurationEditor getConfigurationEditor(int formatId, Sensor sensor, SensorModifier parent) {
        switch (formatId) {
            case 100: {
                return new LidModeConfiguration(parent, null, sensor);
            }
            case 101: {
                return new EcConfiguration(parent, null, sensor);
            }
            case 103: {
                return new SdoConfiguration(parent, null, sensor);
            }
            case 104: {
                return new AngleRegulatorConfiguration(parent, null, sensor);
            }
            case 105: {
                return new HingeConfiguration(parent, null, sensor);
            }
            case 106: {
                return new DevicePostureConfiguration(parent, null, sensor);
            }
            case 107: {
                return new DynamicSarConfiguration(parent, null, sensor);
            }
            case 108: {
                return new HumanPresenceConfiguration(parent, null, sensor);
            }
            case 109: {
                return new FaceDetectionConfiguration(parent, null, sensor);
            }
            case 110: {
                return new DynamicKeyboardLightingConfiguration(parent, null, sensor);
            }
            case 111: {
                return new HingeAngleConfiguration(parent, null, sensor);
            }
            case 112: {
                return new HumanPresenceStandardConfiguration(parent, null, sensor);
            }
            case 113: {
                return new OnlookerDetectionConfiguration(parent, null, sensor);
            }
        }
        return null;
    }

    public static ConfigurationEditor getConfigurationEditor(ConfigurationPayload payload, Sensor sensor, SensorModifier parentWindow) {
        if (payload instanceof LidModeConfigurationPayload) {
            return new LidModeConfiguration(parentWindow, (LidModeConfigurationPayload)payload, sensor);
        }
        if (payload instanceof EcConfigurationPayload) {
            return new EcConfiguration(parentWindow, (EcConfigurationPayload)payload, sensor);
        }
        if (payload instanceof SdoConfigurationPayload) {
            return new SdoConfiguration(parentWindow, (SdoConfigurationPayload)payload, sensor);
        }
        if (payload instanceof AngleRegulatorConfigurationPayload) {
            return new AngleRegulatorConfiguration(parentWindow, (AngleRegulatorConfigurationPayload)payload, sensor);
        }
        if (payload instanceof HingeConfigurationPayload) {
            return new HingeConfiguration(parentWindow, (HingeConfigurationPayload)payload, sensor);
        }
        if (payload instanceof DevicePostureConfigurationPayload) {
            return new DevicePostureConfiguration(parentWindow, (DevicePostureConfigurationPayload)payload, sensor);
        }
        if (payload instanceof DynamicSarConfigurationPayload) {
            return new DynamicSarConfiguration(parentWindow, (DynamicSarConfigurationPayload)payload, sensor);
        }
        if (payload instanceof HumanPresenceConfigurationPayload) {
            return new HumanPresenceConfiguration(parentWindow, (HumanPresenceConfigurationPayload)payload, sensor);
        }
        if (payload instanceof FaceDetectionConfigurationPayload) {
            return new FaceDetectionConfiguration(parentWindow, (FaceDetectionConfigurationPayload)payload, sensor);
        }
        if (payload instanceof DynamicKeyboardLightingPayload) {
            return new DynamicKeyboardLightingConfiguration(parentWindow, (DynamicKeyboardLightingPayload)payload, sensor);
        }
        if (payload instanceof HingeAngleConfigurationPayload) {
            return new HingeAngleConfiguration(parentWindow, (HingeAngleConfigurationPayload)payload, sensor);
        }
        if (payload instanceof HumanPresenceStandardConfigurationPayload) {
            return new HumanPresenceStandardConfiguration(parentWindow, (HumanPresenceStandardConfigurationPayload)payload, sensor);
        }
        if (payload instanceof OnlookerDetectionConfigurationPayload) {
            return new OnlookerDetectionConfiguration(parentWindow, (OnlookerDetectionConfigurationPayload)payload, sensor);
        }
        return null;
    }

    public static void openCalibrationWindow(CalibrationPayload calibration, Sensor detailsHolderSensor, CalibrationEditorOpener parentWindow) {
        if (calibration == null) {
            new NewCalibration(0, parentWindow, detailsHolderSensor).open();
        } else {
            CalibrationEditor editor = PayloadUtils.getCalibrationEditor(calibration, detailsHolderSensor, parentWindow);
            if (editor == null) {
                throw new RuntimeException("This sensor does not support any calibration.");
            }
            editor.open();
        }
    }

    public static void openConfigurationWindow(ConfigurationPayload payload, Sensor sensor, SensorModifier parentWindow) {
        boolean configurationAvailable = false;
        if (payload == null) {
            configurationAvailable = true;
            new NewConfiguration(0, parentWindow, sensor).open();
        } else if (payload instanceof LidModeConfigurationPayload) {
            configurationAvailable = true;
            new LidModeConfiguration(parentWindow, (LidModeConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof EcConfigurationPayload) {
            configurationAvailable = true;
            new EcConfiguration(parentWindow, (EcConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof SdoConfigurationPayload) {
            configurationAvailable = true;
            new SdoConfiguration(parentWindow, (SdoConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof AngleRegulatorConfigurationPayload) {
            configurationAvailable = true;
            new AngleRegulatorConfiguration(parentWindow, (AngleRegulatorConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof HingeConfigurationPayload) {
            configurationAvailable = true;
            new HingeConfiguration(parentWindow, (HingeConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof DevicePostureConfigurationPayload) {
            configurationAvailable = true;
            new DevicePostureConfiguration(parentWindow, (DevicePostureConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof DynamicSarConfigurationPayload) {
            configurationAvailable = true;
            new DynamicSarConfiguration(parentWindow, (DynamicSarConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof HumanPresenceConfigurationPayload) {
            configurationAvailable = true;
            new HumanPresenceConfiguration(parentWindow, (HumanPresenceConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof FaceDetectionConfigurationPayload) {
            configurationAvailable = true;
            new FaceDetectionConfiguration(parentWindow, (FaceDetectionConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof DynamicKeyboardLightingPayload) {
            configurationAvailable = true;
            new DynamicKeyboardLightingConfiguration(parentWindow, (DynamicKeyboardLightingPayload)payload, sensor).open();
        } else if (payload instanceof HingeAngleConfigurationPayload) {
            configurationAvailable = true;
            new HingeAngleConfiguration(parentWindow, (HingeAngleConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof HumanPresenceStandardConfigurationPayload) {
            configurationAvailable = true;
            new HumanPresenceStandardConfiguration(parentWindow, (HumanPresenceStandardConfigurationPayload)payload, sensor).open();
        } else if (payload instanceof OnlookerDetectionConfigurationPayload) {
            configurationAvailable = true;
            new OnlookerDetectionConfiguration(parentWindow, (OnlookerDetectionConfigurationPayload)payload, sensor).open();
        }
        if (!configurationAvailable) {
            throw new RuntimeException("This sensor does not support any configuration.");
        }
    }
}

