/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.validation.Validator;

public class SimpleDmdCalibrationPayload
extends CalibrationPayload {
    public static final int CALIBRATION_TYPE = 6;
    public static final String CALIBRATION_FORMAT_STRING = "Simple DMD Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    public static final int LATEST_FORMAT_ID = 1;
    public static final int SLOPE_THRESHOLD_DEFAULT_VALUE = 30;
    public static final int ENTER_DURATION_DEFAULT_VALUE = 5000;
    public static final boolean DISABLE_MEDIAN_FILTER_DEFAULT_VALUE = false;
    public static final int NOISE_THRESHOLD_DEFAULT_VALUE = 3;
    private int _formatID = 1;
    private int _version = 0;
    private int _slopeThreshold = 30;
    private int _enterDuration = 5000;
    private boolean _disableMedianFilter = false;
    private int _noiseThreshold = 3;

    public int getFormatID() {
        return this._formatID;
    }

    public void setFormatID(int _formatID) {
        this._formatID = _formatID;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int _version) {
        this._version = _version;
    }

    public int get_slopeThreshold() {
        return this._slopeThreshold;
    }

    public void set_slopeThreshold(int _slopeThreshold) {
        this._slopeThreshold = _slopeThreshold;
    }

    public int get_enterDuration() {
        return this._enterDuration;
    }

    public void set_enterDuration(int _enterDuration) {
        this._enterDuration = _enterDuration;
    }

    public boolean is_disableMedianFilter() {
        return this._disableMedianFilter;
    }

    public void set_disableMedianFilter(boolean _disableMedianFilter) {
        this._disableMedianFilter = _disableMedianFilter;
    }

    public int get_noiseThreshold() {
        return this._noiseThreshold;
    }

    public void set_noiseThreshold(int _noiseThreshold) {
        this._noiseThreshold = _noiseThreshold;
    }

    public SimpleDmdCalibrationPayload() {
    }

    public SimpleDmdCalibrationPayload(SimpleDmdCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._slopeThreshold = other._slopeThreshold;
        this._enterDuration = other._enterDuration;
        this._disableMedianFilter = other._disableMedianFilter;
        this._noiseThreshold = other._noiseThreshold;
    }

    public SimpleDmdCalibrationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 1) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element calibration = reader.readNewField((String)"SimpleDmdCalibration", (Node)payloadXmlNode).xmlElement;
        if (this._formatID == 0) {
            this._slopeThreshold = reader.readNewField((String)"SlopeThreshold", (int)2, (boolean)false, (Node)calibration).value;
            this._enterDuration = reader.readNewField((String)"EnterDuration", (int)2, (boolean)false, (Node)calibration).value;
            reader.readNewField("Reserved", 2, false, calibration);
            this._disableMedianFilter = reader.readNewField((String)"DisableMedianFilter", (int)1, (boolean)false, (Node)calibration).value == 1;
        } else if (this._formatID == 1) {
            this._noiseThreshold = reader.readNewField((String)"NoiseThreshold", (int)2, (boolean)false, (Node)calibration).value;
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element calibration = writer.writeNewField((String)"SimpleDmdCalibration", (Node)parent).xmlElement;
        if (this._formatID == 0) {
            writer.writeNewField("SlopeThreshold", 2, this._slopeThreshold, (Node)calibration);
            writer.writeNewField("EnterDuration", 2, this._enterDuration, (Node)calibration);
            writer.writeNewField("Reserved", 2, 0, (Node)calibration);
            writer.writeNewField("DisableMedianFilter", 1, this._disableMedianFilter ? 1 : 0, (Node)calibration);
        } else if (this._formatID == 1) {
            writer.writeNewField("NoiseThreshold", 2, this._noiseThreshold, (Node)calibration);
        }
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public SimpleDmdCalibrationPayload clone() {
        return new SimpleDmdCalibrationPayload(this);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof SimpleDmdCalibrationPayload)) {
            return false;
        }
        SimpleDmdCalibrationPayload other = (SimpleDmdCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._slopeThreshold == other._slopeThreshold && this._enterDuration == other._enterDuration && this._disableMedianFilter == other._disableMedianFilter && this._noiseThreshold == other._noiseThreshold;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

