/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.FormFactorTable;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.InteruptsModifier;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.gui.configuration.LidModeActionModifier;
import pdtEditor.gui.configuration.LidModeConfigurationModifier;
import pdtEditor.gui.configuration.LidModeHallConfiguration;
import pdtEditor.payloads.GpioPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;

public class LidModeConfiguration
implements InterruptsModifierOpener,
ConfigurationEditor {
    private static final int DEFAULT_MODE_MODE_ID = 0;
    private static final int DEFAULT_MODE_ANGLE_VALUE = LidModeConfigurationPayload.ANGLE_MAX_VALUE;
    private static final int DEFAULT_MODE_OTHER_VALUE = 0;
    private static final int DEFAULT_MODE_TIME_HYSTERESIS_VALUE = 250;
    private static final int GPIO_PURPOSE_ID_COL_INDEX = 1;
    private static final int LCD_DIRECTION_COL_INDEX = 6;
    private static final int BOOK_MODE_LCD_DIRECTION = 3;
    private LidModeConfiguration _thisInstance = this;
    private LidModeConfigurationPayload _payload = null;
    ArrayList<LidModeConfigurationPayload.PlmHallConfig> _hallConfig = new ArrayList();
    private Sensor _sensor = null;
    protected Shell shlLidMode;
    private Table configTable;
    private Table actionTable;
    private Display display;
    private Button btnConfigurationLineDelete;
    private Button btnConfigurationEditEntry;
    private Button btnDeleteAction;
    private Button btnAddAction;
    private Button btnEditAction;
    private boolean _modified = false;
    private Button btnAddEntry;
    private Table interruptsTable;
    private Table tblHallConfig;
    private Button btnAddGpio;
    private Button btnEditGpio;
    private Button btnRemoveGpio;
    private Button btnEditHall;
    private Button btnDeleteHall;
    private Button btnAddHall;
    TableViewer tableViewer;
    private SensorModifier _parent;
    private InformationStore infoStore = null;
    private Button btnSaveAndClose;
    private ControlAdapter resizeColHandler = new ControlAdapter(){

        public void controlResized(ControlEvent arg0) {
            if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                ((TableColumn)arg0.getSource()).setWidth(50);
            }
        }
    };

    public static void main(String[] args) {
        try {
            LidModeConfiguration window = new LidModeConfiguration(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LidModeConfiguration(SensorModifier parent, LidModeConfigurationPayload payload, Sensor sensor) {
        this._payload = payload;
        this._sensor = sensor;
        this._parent = parent;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlLidMode, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.fillData();
        this.shlLidMode.open();
        this.shlLidMode.layout();
        while (!this.shlLidMode.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    @Override
    public void setModified() {
        this._modified = true;
    }

    public void fillData() {
        if (this._payload == null) {
            return;
        }
        this.configTable.removeAll();
        this.interruptsTable.removeAll();
        this.actionTable.removeAll();
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = this._payload.getTableEntries();
        ArrayList<LidModeConfigurationPayload.ActionEntry> actionEntries = this._payload.getActionEntries();
        for (int i = 0; i < this._payload.getPlmHallConfig().size(); ++i) {
            this.addHallConfig(this._payload.getPlmHallConfig().get((int)i).instanceId, this._payload.getPlmHallConfig().get((int)i).sensorName);
        }
        for (LidModeConfigurationPayload.TableEntry tableEntry : tableEntries) {
            if (tableEntry.modeId == 0) continue;
            ArrayList<String> tempArray = new ArrayList<String>();
            tempArray.add(String.valueOf(tableEntry.modeId));
            tempArray.add(String.valueOf(tableEntry.entryAngle));
            tempArray.add(String.valueOf(tableEntry.exitAngle));
            tempArray.add(String.valueOf(tableEntry.t1Delta));
            tempArray.add(String.valueOf(tableEntry.t2Delta));
            tempArray.add(String.valueOf(tableEntry.th));
            tempArray.add(String.valueOf(tableEntry.lcdDirection));
            for (int i = 0; i < this._hallConfig.size(); ++i) {
                if (tableEntry.hallStates[i] == 0) {
                    tempArray.add("Inactive");
                    continue;
                }
                if (tableEntry.hallStates[i] == 1) {
                    tempArray.add("Active");
                    continue;
                }
                tempArray.add("Not Applicable");
            }
            String[] data = new String[]{};
            data = tempArray.toArray(data);
            this.addConfigurationLine(data);
        }
        if (this._parent != null) {
            TableItem[] gpioLines;
            for (TableItem gpioEntry : gpioLines = this._parent.getGpioInfo().getAllGpioLines()) {
                String[] data = new String[]{String.valueOf(gpioEntry.getText(0)), String.valueOf(gpioEntry.getText(1)), String.valueOf(gpioEntry.getText(2)), gpioEntry.getText(3)};
                this.addGpioLine(data);
            }
        }
        for (LidModeConfigurationPayload.ActionEntry actionEntry : actionEntries) {
            LidModeConfigurationPayload.ActionInfo actionInfo = this.infoStore.getPlmActionById(actionEntry.value);
            if (actionInfo == null) continue;
            String gpioPurposeId = actionInfo.needGpio ? String.valueOf(actionEntry.gpioPurposeId) : "-";
            String[] data = new String[]{String.valueOf(actionEntry.mode), gpioPurposeId, actionInfo.name};
            this.addActionLine(data);
        }
        this._modified = false;
    }

    public void saveData() {
        int i;
        boolean newConfiguration = false;
        if (DataStore.getInstance().getCurrentPdtFile() == null) {
            System.err.println("null PDT file");
        }
        ArrayList<LidModeConfigurationPayload.TableEntry> tableEntries = new ArrayList<LidModeConfigurationPayload.TableEntry>();
        ArrayList<LidModeConfigurationPayload.ActionEntry> actionEntries = new ArrayList<LidModeConfigurationPayload.ActionEntry>();
        if (this.configTable.getItemCount() > 0) {
            LidModeConfigurationPayload.TableEntry tableEntry = new LidModeConfigurationPayload.TableEntry();
            tableEntry.modeId = 0;
            tableEntry.entryAngle = DEFAULT_MODE_ANGLE_VALUE;
            tableEntry.exitAngle = DEFAULT_MODE_ANGLE_VALUE;
            tableEntry.t1Delta = 0;
            tableEntry.t2Delta = 0;
            tableEntry.th = 250;
            tableEntry.lcdDirection = 0;
            tableEntries.add(tableEntry);
        }
        for (int i2 = 0; i2 < this.configTable.getItemCount(); ++i2) {
            TableItem configTableItem = this.configTable.getItem(i2);
            LidModeConfigurationPayload.TableEntry tableEntry = new LidModeConfigurationPayload.TableEntry();
            tableEntry.modeId = Integer.valueOf(configTableItem.getText(0));
            tableEntry.entryAngle = Integer.valueOf(configTableItem.getText(1));
            tableEntry.exitAngle = Integer.valueOf(configTableItem.getText(2));
            tableEntry.t1Delta = Integer.valueOf(configTableItem.getText(3));
            tableEntry.t2Delta = Integer.valueOf(configTableItem.getText(4));
            tableEntry.th = Integer.valueOf(configTableItem.getText(5));
            tableEntry.lcdDirection = Integer.valueOf(configTableItem.getText(6));
            for (int j = 0; j < this._hallConfig.size(); ++j) {
                String currentHallState = configTableItem.getText(7 + j);
                tableEntry.hallStates[j] = currentHallState.equals("Inactive") ? 0 : (currentHallState.equals("Active") ? 1 : 255);
            }
            tableEntries.add(tableEntry);
        }
        FormFactorTable formFactorTable = DataStore.getInstance().getCurrentPdtFile().getFormFactorTable();
        for (i = 0; i < tableEntries.size(); ++i) {
            for (int j = i + 1; j < tableEntries.size(); ++j) {
                if ((((LidModeConfigurationPayload.TableEntry)tableEntries.get((int)i)).lcdDirection >= 3 || tableEntries.get((int)j).lcdDirection >= 3 || tableEntries.get((int)i).lcdDirection != tableEntries.get((int)j).lcdDirection && tableEntries.get((int)i).lcdDirection != 0 && tableEntries.get((int)j).lcdDirection != 0) && (formFactorTable == null || formFactorTable.getFormFactorType() != FormFactorTable.FormFactorType.MID || tableEntries.get((int)i).lcdDirection < 3 || tableEntries.get((int)j).lcdDirection < 3 || tableEntries.get((int)i).lcdDirection != tableEntries.get((int)j).lcdDirection && tableEntries.get((int)i).lcdDirection != 3 && tableEntries.get((int)j).lcdDirection != 3)) continue;
                boolean isHallStatesAllSame = true;
                for (int k = 0; k < tableEntries.get((int)i).hallStates.length && k < tableEntries.get((int)j).hallStates.length; ++k) {
                    if (tableEntries.get((int)i).hallStates[k] == 255 || tableEntries.get((int)j).hallStates[k] == 255 || tableEntries.get((int)i).hallStates[k] == tableEntries.get((int)j).hallStates[k]) continue;
                    isHallStatesAllSame = false;
                    break;
                }
                if (!isHallStatesAllSame) continue;
                if (tableEntries.get((int)j).entryAngle >= tableEntries.get((int)i).entryAngle - tableEntries.get((int)i).t1Delta && tableEntries.get((int)j).exitAngle <= tableEntries.get((int)i).exitAngle + tableEntries.get((int)i).t2Delta) {
                    MessageBox messageBox = new MessageBox(this.shlLidMode, 513);
                    messageBox.setText("Erro Message");
                    messageBox.setMessage("The Mode ID: " + tableEntries.get((int)j).modeId + " is covered by Mode ID: " + tableEntries.get((int)i).modeId + " !");
                    messageBox.open();
                    return;
                }
                if (tableEntries.get((int)i).entryAngle < tableEntries.get((int)j).entryAngle - tableEntries.get((int)j).t1Delta || tableEntries.get((int)i).exitAngle > tableEntries.get((int)j).exitAngle + tableEntries.get((int)j).t2Delta) continue;
                MessageBox messageBox = new MessageBox(this.shlLidMode, 513);
                messageBox.setText("Erro Message");
                messageBox.setMessage("The Mode ID: " + tableEntries.get((int)i).modeId + " is covered by Mode ID: " + tableEntries.get((int)j).modeId + " !");
                messageBox.open();
                return;
            }
        }
        for (i = 0; i < this.actionTable.getItemCount(); ++i) {
            TableItem actionItem = this.actionTable.getItem(i);
            LidModeConfigurationPayload.ActionInfo actionInfo = this.infoStore.getPlmActionByName(actionItem.getText(2));
            if (actionInfo == null) continue;
            LidModeConfigurationPayload.ActionEntry actionEntry = new LidModeConfigurationPayload.ActionEntry();
            actionEntry.value = actionInfo.value;
            actionEntry.mode = Integer.valueOf(actionItem.getText(0));
            if (actionInfo.needGpio) {
                actionEntry.gpioPurposeId = Integer.valueOf(actionItem.getText(1));
            }
            actionEntries.add(actionEntry);
        }
        if (this._payload == null) {
            this._payload = new LidModeConfigurationPayload();
            newConfiguration = true;
        }
        this._payload.setTableEntries(tableEntries);
        this._payload.setActionEntries(actionEntries);
        this._payload.setPlmHallConfig(this._hallConfig);
        if (this._parent != null) {
            this._parent.getGpioInfo().clear();
            for (i = 0; i < this.interruptsTable.getItemCount(); ++i) {
                TableItem gpioItem = this.interruptsTable.getItem(i);
                this._parent.getGpioInfo().addGpioToTable(gpioItem.getText(1), gpioItem.getText(2), gpioItem.getText(3));
            }
        } else {
            GpioPayload gpioPayload = (GpioPayload)this._sensor.getPayloadByClass(GpioPayload.class);
            if (gpioPayload == null) {
                gpioPayload = new GpioPayload(new ArrayList<GpioPayload.Gpio>());
            }
            for (int i3 = 0; i3 < this.interruptsTable.getItemCount(); ++i3) {
                int mode;
                TableItem gpioItem = this.interruptsTable.getItem(i3);
                try {
                    mode = Integer.valueOf(gpioItem.getText(3));
                }
                catch (NumberFormatException e) {
                    mode = this.infoStore.getGpioModeId(gpioItem.getText(3));
                }
                gpioPayload.addGpio(Integer.valueOf(gpioItem.getText(1)), Integer.valueOf(gpioItem.getText(2)), mode);
                this._sensor.addPayload(gpioPayload);
            }
        }
        if (newConfiguration) {
            if (this._sensor != null) {
                this._sensor.addPayload(this._payload);
            }
            if (this._parent != null) {
                this._parent.addNewConfiguration(this._payload);
            }
        }
        this._modified = false;
        if (this._parent != null) {
            this._parent.setModified();
        }
        this.shlLidMode.close();
    }

    public void addGPIO() {
        InteruptsModifier interMod = new InteruptsModifier(this, this._sensor);
        this.interruptsTable.deselectAll();
        interMod.open();
    }

    public void editGPIO() {
        TableItem[] selectedItems = this.interruptsTable.getSelection();
        for (int i = 0; i < selectedItems.length; ++i) {
            for (int j = 0; j < this.actionTable.getItemCount(); ++j) {
                if (!this.actionTable.getItem(j).getText(1).equals(selectedItems[i].getText(1))) continue;
                MessageBox messageBox = new MessageBox(this.shlLidMode, 513);
                messageBox.setText("Cannot Edit The GPIO Row");
                messageBox.setMessage("The 'Action Table' contains an entry with the 'purpose' value of the modified entry. Please remove the entry from the action table first.");
                messageBox.open();
                return;
            }
        }
        int selectedLine = this.interruptsTable.getSelectionIndex();
        if (selectedLine == -1) {
            return;
        }
        InteruptsModifier interMod = new InteruptsModifier(this, this._sensor, selectedLine);
        interMod.open();
    }

    public void removeGPIO() {
        this.interruptsTable.remove(this.interruptsTable.getSelectionIndices());
        this.btnRemoveGpio.setEnabled(false);
        this.btnEditGpio.setEnabled(false);
        this.refreshAddGpioEnablility();
    }

    public void refreshButtonsAfterConfNumChange() {
        if (this.configTable.getItemCount() < 1) {
            this.btnSaveAndClose.setEnabled(false);
        } else {
            this.btnSaveAndClose.setEnabled(true);
        }
        if (this.configTable.getItemCount() >= 15) {
            this.btnAddEntry.setEnabled(false);
        } else {
            this.btnAddEntry.setEnabled(true);
        }
    }

    public void refreshAddGpioEnablility() {
        if (this.interruptsTable.getItemCount() >= 15) {
            this.btnAddGpio.setEnabled(false);
        } else {
            this.btnAddGpio.setEnabled(true);
        }
    }

    public void refreshActionButtonsEnablility() {
        if (this.actionTable.getItemCount() >= 64) {
            this.btnAddAction.setEnabled(false);
        } else {
            this.btnAddAction.setEnabled(true);
        }
        if (this.actionTable.getSelectionCount() == 0) {
            this.btnEditAction.setEnabled(false);
            this.btnDeleteAction.setEnabled(false);
        } else {
            this.btnEditAction.setEnabled(true);
            this.btnDeleteAction.setEnabled(true);
        }
    }

    public void refreshHallConfigButtonsEnablility() {
        if (this.tblHallConfig.getItemCount() >= 6) {
            this.btnAddHall.setEnabled(false);
        } else {
            this.btnAddHall.setEnabled(true);
        }
        if (this.tblHallConfig.getSelectionCount() == 0) {
            this.btnEditHall.setEnabled(false);
            this.btnDeleteHall.setEnabled(false);
        } else {
            this.btnEditHall.setEnabled(true);
            this.btnDeleteHall.setEnabled(true);
        }
    }

    public void checkNewConfiguration(String[] data) {
        for (int i = 0; i < this.configTable.getItemCount(); ++i) {
            if (this.configTable.getSelectionIndex() == i || !this.configTable.getItem(i).getText(0).equals(data[0])) continue;
            throw new RuntimeException("The configuration table cannot contain two entries with the same mode ID.");
        }
    }

    public void addConfigurationLine(String[] data) {
        TableItem item = new TableItem(this.configTable, 0);
        item.setText(data);
        this.refreshButtonsAfterConfNumChange();
    }

    public void addGpioLine(String[] data) {
        TableItem item = new TableItem(this.interruptsTable, 0);
        item.setText(data);
        this.refreshAddGpioEnablility();
    }

    public void addActionLine(String[] data) {
        TableItem item = new TableItem(this.actionTable, 0);
        item.setText(data);
        this.refreshActionButtonsEnablility();
    }

    public void addHallConfig(int instanceId, String sensorName) {
        LidModeConfigurationPayload.PlmHallConfig hallConfig = new LidModeConfigurationPayload.PlmHallConfig();
        TableItem item = new TableItem(this.tblHallConfig, 0);
        TableViewerColumn tbvcNewSensorType = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewSensorType = tbvcNewSensorType.getColumn();
        int oneWidth = this.configTable.getClientArea().width / 20;
        String headText = sensorName + "(" + instanceId + ")";
        LidModeConfigurationPayload.PlmSupportSensorType supportSensorType = this.infoStore.getPlmSupportSensorTypeByName(sensorName);
        if (supportSensorType != null) {
            hallConfig.sensorType = supportSensorType.sensorType;
        }
        for (TableItem tbitmCurrentItem : this.configTable.getItems()) {
            tbitmCurrentItem.setText(this.configTable.getColumnCount() - 1, "Not Applicable");
        }
        hallConfig.instanceId = instanceId;
        hallConfig.sensorName = sensorName;
        this._hallConfig.add(hallConfig);
        item.setText(0, sensorName);
        item.setText(1, Integer.toString(instanceId));
        tblclmnNewSensorType.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnNewSensorType.setText(headText);
        tblclmnNewSensorType.setWidth(oneWidth * 4);
        this.refreshHallConfigButtonsEnablility();
    }

    public void editHallConfig(int instanceId, String sensorName, int rowIndex) {
        String headText = sensorName + "(" + instanceId + ")";
        LidModeConfigurationPayload.PlmSupportSensorType supportSensorType = this.infoStore.getPlmSupportSensorTypeByName(sensorName);
        if (supportSensorType != null) {
            this._hallConfig.get((int)rowIndex).sensorType = supportSensorType.sensorType;
        }
        this._hallConfig.get((int)rowIndex).sensorName = sensorName;
        this._hallConfig.get((int)rowIndex).instanceId = instanceId;
        this.tblHallConfig.getItem(rowIndex).setText(0, sensorName);
        this.tblHallConfig.getItem(rowIndex).setText(1, Integer.toString(instanceId));
        this.tableViewer.getTable().getColumn(7 + rowIndex).setText(headText);
    }

    public void deleteHallConfig() {
        int[] selectedIndices = this.tblHallConfig.getSelectionIndices();
        for (int i = 0; i < selectedIndices.length; ++i) {
            this.tableViewer.getTable().getColumn(7 + selectedIndices[i]).dispose();
            this.tblHallConfig.remove(selectedIndices[i]);
            this._hallConfig.remove(selectedIndices[i]);
        }
        this.refreshHallConfigButtonsEnablility();
        this.setModified();
    }

    public void checkHallConfigValues(int instanceId, String sensorName) {
        for (int i = 0; i < this._hallConfig.size(); ++i) {
            if (this._hallConfig.get((int)i).instanceId != instanceId || !this._hallConfig.get((int)i).sensorName.equals(sensorName)) continue;
            throw new RuntimeException("An instance has already been selected for this Sensor Type.");
        }
    }

    public void checkActionValues(int modeId) {
        this.checkActionValues(modeId, -1);
    }

    public void checkActionValues(int modeId, int purposeId) {
        TableItem[] actions = this.actionTable.getItems();
        for (int i = 0; i < actions.length; ++i) {
            if (i == this.actionTable.getSelectionIndex() || !actions[i].getText(0).equals(String.valueOf(modeId))) continue;
            if (purposeId == -1) {
                throw new RuntimeException("An action has already been selected for this Mode ID.");
            }
            if (!actions[i].getText(1).trim().equals("-") && !actions[i].getText(1).equals(String.valueOf(purposeId))) continue;
            throw new RuntimeException("An action has already been selected for this Mode ID and GPIO Purpose ID pair.");
        }
        boolean notFound = true;
        TableItem[] configs = this.configTable.getItems();
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getText(0).equals(String.valueOf(modeId))) continue;
            notFound = false;
            break;
        }
        if (notFound) {
            throw new RuntimeException("The Mode ID does not exist in the configuration table");
        }
        if (purposeId >= 0) {
            notFound = true;
            TableItem[] gpios = this.interruptsTable.getItems();
            for (int i = 0; i < gpios.length; ++i) {
                if (!gpios[i].getText(1).equals(String.valueOf(purposeId))) continue;
                notFound = false;
                break;
            }
            if (notFound) {
                throw new RuntimeException("The purpose ID does not exist in the GPIO table");
            }
        }
    }

    public void editConfigurationTableItem() {
        TableItem[] selectedItems = this.configTable.getSelection();
        for (int i = 0; i < selectedItems.length; ++i) {
            for (int j = 0; j < this.actionTable.getItemCount(); ++j) {
                if (!this.actionTable.getItem(j).getText(0).equals(selectedItems[i].getText(0))) continue;
                MessageBox messageBox = new MessageBox(this.shlLidMode, 513);
                messageBox.setText("Cannot Edit The Configuration Row");
                messageBox.setMessage("The 'Action Table' contains an entry with the 'mode ID' of the modified entry. Please remove the entry from the action table first.");
                messageBox.open();
                return;
            }
        }
        if (selectedItems.length != 1) {
            return;
        }
        new LidModeConfigurationModifier(this._thisInstance, selectedItems[0], this._hallConfig).open();
    }

    public void editGpioTableItem() {
        TableItem[] selectedItems = this.interruptsTable.getSelection();
        if (selectedItems.length != 1) {
            return;
        }
        new InteruptsModifier(this._thisInstance, this._sensor, this.interruptsTable.indexOf(selectedItems[0])).open();
    }

    public void editActionTableItem() {
        TableItem[] selectedItems = this.actionTable.getSelection();
        if (selectedItems.length != 1) {
            return;
        }
        new LidModeActionModifier(this._thisInstance, selectedItems[0]).open();
    }

    public static boolean chooseComboItemByValue(Combo combo) {
        return GuiUtils.chooseComboItemByValue(combo);
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return this.interruptsTable.getSelectionIndices();
    }

    @Override
    public int getGpioCount() {
        return this.interruptsTable.getItemCount();
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        HashMap<String, String> res = new HashMap<String, String>();
        TableItem item = this.interruptsTable.getItem(lineIndex);
        res.put("purpose", item.getText(0));
        res.put("purposeID", item.getText(1));
        res.put("pinNumber", item.getText(2));
        res.put("modeGpio", item.getText(3));
        return res;
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
        this.addGpioLine(new String[]{InteruptsModifier.getPurposeById(this._sensor, Integer.valueOf(purposeID)), String.valueOf(purposeID), String.valueOf(pinNumber), String.valueOf(modelGpio)});
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
        TableItem item = this.interruptsTable.getItem(lineIndex);
        item.setText(0, InteruptsModifier.getPurposeById(this._sensor, Integer.valueOf(values.get("purposeID"))));
        item.setText(1, values.get("purposeID"));
        item.setText(2, values.get("pinNumber"));
        item.setText(3, values.get("modeGpio"));
    }

    @Override
    public Shell getShell() {
        return this.shlLidMode;
    }

    protected void createContents() {
        this.shlLidMode = new Shell(65760);
        this.shlLidMode.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (LidModeConfiguration.this._modified) {
                    MessageBox messageBox = new MessageBox(LidModeConfiguration.this.shlLidMode, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlLidMode.setImage(SWTResourceManager.getImage(LidModeConfiguration.class, "/resources/Intel.ico"));
        this.shlLidMode.setText("Platform Lid Mode Configuration");
        GridLayout shlLidModegridLayout = new GridLayout(3, true);
        shlLidModegridLayout.marginWidth = 10;
        shlLidModegridLayout.marginHeight = 10;
        shlLidModegridLayout.horizontalSpacing = 10;
        shlLidModegridLayout.verticalSpacing = 10;
        this.shlLidMode.setLayout((Layout)shlLidModegridLayout);
        Group grpTable = new Group((Composite)this.shlLidMode, 0);
        grpTable.setText("Lid Mode Configuration Table");
        grpTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        GridLayout gridLayoutgrpTable = new GridLayout(3, false);
        gridLayoutgrpTable.marginWidth = 10;
        gridLayoutgrpTable.marginHeight = 10;
        gridLayoutgrpTable.horizontalSpacing = 10;
        gridLayoutgrpTable.verticalSpacing = 10;
        grpTable.setLayout((Layout)gridLayoutgrpTable);
        this.tableViewer = new TableViewer((Composite)grpTable, 67586);
        this.configTable = this.tableViewer.getTable();
        this.configTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = LidModeConfiguration.this.configTable.getSelectionCount();
                if (itemsSelected == 1) {
                    LidModeConfiguration.this.btnConfigurationEditEntry.setEnabled(true);
                    LidModeConfiguration.this.btnConfigurationLineDelete.setEnabled(true);
                } else {
                    LidModeConfiguration.this.btnConfigurationEditEntry.setEnabled(false);
                    if (itemsSelected > 1) {
                        LidModeConfiguration.this.btnConfigurationLineDelete.setEnabled(true);
                    } else {
                        LidModeConfiguration.this.btnConfigurationLineDelete.setEnabled(false);
                    }
                }
            }
        });
        this.configTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                LidModeConfiguration.this.editConfigurationTableItem();
            }
        });
        this.configTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.configTable.setHeaderVisible(true);
        this.configTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnModeId = tableViewerColumn.getColumn();
        tblclmnModeId.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnModeId.setText("Mode ID");
        TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnEntryAngle = tableViewerColumn_6.getColumn();
        tblclmnEntryAngle.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnEntryAngle.setText("Entry Angle");
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnExitAngle = tableViewerColumn_5.getColumn();
        tblclmnExitAngle.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnExitAngle.setText("Exit Angle");
        TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnDeltaT1 = tableViewerColumn_4.getColumn();
        tblclmnDeltaT1.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnDeltaT1.setText("Entry Angle Tolerance");
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnDeltaT2 = tableViewerColumn_3.getColumn();
        tblclmnDeltaT2.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnDeltaT2.setText("Exit Angle Tolerance");
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnTh = tableViewerColumn_2.getColumn();
        tblclmnTh.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnTh.setText("Time Hysteresis");
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        final TableColumn tblclmnLcdDirection = tableViewerColumn_1.getColumn();
        tblclmnLcdDirection.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnLcdDirection.setText("LCD Direction");
        this.configTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((LidModeConfiguration)LidModeConfiguration.this).configTable.getClientArea().width / 20;
                tblclmnModeId.setWidth(oneWidth * 2);
                tblclmnEntryAngle.setWidth(oneWidth * 2);
                tblclmnExitAngle.setWidth(oneWidth * 2);
                tblclmnDeltaT1.setWidth(oneWidth * 4);
                tblclmnDeltaT2.setWidth(oneWidth * 4);
                tblclmnTh.setWidth(oneWidth * 3);
                tblclmnLcdDirection.setWidth(oneWidth * 3);
            }
        });
        this.btnAddEntry = new Button((Composite)grpTable, 0);
        GridData gd_btnAddEntry = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddEntry.widthHint = GuiUtils.getButtonWidth((Control)grpTable);
        this.btnAddEntry.setLayoutData((Object)gd_btnAddEntry);
        this.btnAddEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.configTable.setSelection(new int[0]);
                new LidModeConfigurationModifier(LidModeConfiguration.this._thisInstance, null, LidModeConfiguration.this._hallConfig).open();
            }
        });
        this.btnAddEntry.setText("Add");
        this.btnConfigurationEditEntry = new Button((Composite)grpTable, 0);
        GridData gd_btnEditEntry = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnEditEntry.widthHint = GuiUtils.getButtonWidth((Control)grpTable);
        this.btnConfigurationEditEntry.setLayoutData((Object)gd_btnEditEntry);
        this.btnConfigurationEditEntry.setEnabled(false);
        this.btnConfigurationEditEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.editConfigurationTableItem();
            }
        });
        this.btnConfigurationEditEntry.setText("Edit");
        this.btnConfigurationLineDelete = new Button((Composite)grpTable, 0);
        this.btnConfigurationLineDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridData gd_btnDeleteEntry = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnDeleteEntry.widthHint = GuiUtils.getButtonWidth((Control)grpTable);
        this.btnConfigurationLineDelete.setLayoutData((Object)gd_btnDeleteEntry);
        this.btnConfigurationLineDelete.setEnabled(false);
        this.btnConfigurationLineDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = LidModeConfiguration.this.configTable.getSelectionIndices();
                TableItem[] selectedItems = LidModeConfiguration.this.configTable.getSelection();
                for (int i = 0; i < selectedItems.length; ++i) {
                    for (int j = 0; j < LidModeConfiguration.this.actionTable.getItemCount(); ++j) {
                        if (!LidModeConfiguration.this.actionTable.getItem(j).getText(0).equals(selectedItems[i].getText(0))) continue;
                        MessageBox messageBox = new MessageBox(LidModeConfiguration.this.shlLidMode, 513);
                        messageBox.setText("Cannot Delete The Configuration Row");
                        messageBox.setMessage("The 'Action Table' contains an entry with the 'mode ID' of one of the deleted entries. Please remove the entry from the action table first.");
                        messageBox.open();
                        return;
                    }
                }
                if (selectedIndices.length > 0) {
                    LidModeConfiguration.this.configTable.remove(selectedIndices);
                }
                LidModeConfiguration.this.btnConfigurationEditEntry.setEnabled(false);
                LidModeConfiguration.this.btnConfigurationLineDelete.setEnabled(false);
                LidModeConfiguration.this.refreshButtonsAfterConfNumChange();
                LidModeConfiguration.this.setModified();
            }
        });
        this.btnConfigurationLineDelete.setText("Delete");
        Label lblAfterSavingAn = new Label((Composite)grpTable, 0);
        lblAfterSavingAn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        lblAfterSavingAn.setText("* A default mode with mode ID 0 is automatically added to the table for undetected states.");
        Group grpInterrupts = new Group((Composite)this.shlLidMode, 0);
        grpInterrupts.setLayout((Layout)new GridLayout(3, false));
        grpInterrupts.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpInterrupts.setText("GPIO");
        TableViewer tableViewer_2 = new TableViewer((Composite)grpInterrupts, 67586);
        this.interruptsTable = tableViewer_2.getTable();
        this.interruptsTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.interruptsTable.setLinesVisible(true);
        this.interruptsTable.setHeaderVisible(true);
        this.interruptsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LidModeConfiguration.this.interruptsTable.getSelectionCount() > 0) {
                    LidModeConfiguration.this.btnRemoveGpio.setEnabled(true);
                    if (LidModeConfiguration.this.interruptsTable.getSelectionCount() == 1) {
                        LidModeConfiguration.this.btnEditGpio.setEnabled(true);
                    } else {
                        LidModeConfiguration.this.btnEditGpio.setEnabled(false);
                    }
                }
            }
        });
        this.interruptsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LidModeConfiguration.this.editGPIO();
            }
        });
        final TableColumn tblclmnPurposeName = new TableColumn(this.interruptsTable, 0);
        tblclmnPurposeName.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnPurposeName.setText("Purpose");
        final TableColumn tblclmnPurposeId = new TableColumn(this.interruptsTable, 0);
        tblclmnPurposeId.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnPurposeId.setText("Purpose ID");
        final TableColumn tblclmnGPIOID = new TableColumn(this.interruptsTable, 0);
        tblclmnGPIOID.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnGPIOID.setText("ISS GPIO ID");
        final TableColumn tblclmnMode = new TableColumn(this.interruptsTable, 0);
        tblclmnMode.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnMode.setText("Mode");
        this.interruptsTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((LidModeConfiguration)LidModeConfiguration.this).interruptsTable.getClientArea().width / 4;
                tblclmnPurposeName.setWidth(oneWidth);
                tblclmnPurposeId.setWidth(oneWidth);
                tblclmnGPIOID.setWidth(oneWidth);
                tblclmnMode.setWidth(oneWidth);
            }
        });
        this.btnAddGpio = new Button((Composite)grpInterrupts, 0);
        GridData gd_btnAddGpio = new GridData(131072, 4, false, false, 1, 1);
        gd_btnAddGpio.widthHint = GuiUtils.getButtonWidth((Control)grpInterrupts);
        this.btnAddGpio.setLayoutData((Object)gd_btnAddGpio);
        this.btnAddGpio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LidModeConfiguration.this.addGPIO();
            }
        });
        this.btnAddGpio.setText("Add");
        this.btnEditGpio = new Button((Composite)grpInterrupts, 0);
        GridData gd_btnEditGpio = new GridData(131072, 4, false, false, 1, 1);
        gd_btnEditGpio.widthHint = GuiUtils.getButtonWidth((Control)grpInterrupts);
        this.btnEditGpio.setLayoutData((Object)gd_btnEditGpio);
        this.btnEditGpio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LidModeConfiguration.this.editGPIO();
            }
        });
        this.btnEditGpio.setText("Edit");
        this.btnEditGpio.setEnabled(false);
        this.btnRemoveGpio = new Button((Composite)grpInterrupts, 0);
        GridData gd_btnRemoveGpio = new GridData(4, 4, false, false, 1, 1);
        gd_btnRemoveGpio.widthHint = GuiUtils.getButtonWidth((Control)grpInterrupts);
        this.btnRemoveGpio.setLayoutData((Object)gd_btnRemoveGpio);
        this.btnRemoveGpio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selectedItems = LidModeConfiguration.this.interruptsTable.getSelection();
                for (int i = 0; i < selectedItems.length; ++i) {
                    for (int j = 0; j < LidModeConfiguration.this.actionTable.getItemCount(); ++j) {
                        if (!LidModeConfiguration.this.actionTable.getItem(j).getText(1).equals(selectedItems[i].getText(1))) continue;
                        MessageBox messageBox = new MessageBox(LidModeConfiguration.this.shlLidMode, 513);
                        messageBox.setText("Cannot Delete The GPIO Row");
                        messageBox.setMessage("The 'Action Table' contains an entry with the 'purpose' of one of the deleted entries. Please remove the entry from the action table first.");
                        messageBox.open();
                        return;
                    }
                }
                LidModeConfiguration.this.removeGPIO();
            }
        });
        this.btnRemoveGpio.setText("Delete");
        this.btnRemoveGpio.setEnabled(false);
        Group grpActions = new Group((Composite)this.shlLidMode, 0);
        grpActions.setText("Action Table");
        grpActions.setLayout((Layout)new GridLayout(3, false));
        grpActions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewer tableViewer_1 = new TableViewer((Composite)grpActions, 67586);
        this.actionTable = tableViewer_1.getTable();
        this.actionTable.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.actionTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = LidModeConfiguration.this.actionTable.getSelectionCount();
                if (itemsSelected == 1) {
                    LidModeConfiguration.this.btnEditAction.setEnabled(true);
                    LidModeConfiguration.this.btnDeleteAction.setEnabled(true);
                } else {
                    LidModeConfiguration.this.btnEditAction.setEnabled(false);
                    if (itemsSelected > 1) {
                        LidModeConfiguration.this.btnDeleteAction.setEnabled(true);
                    } else {
                        LidModeConfiguration.this.btnDeleteAction.setEnabled(false);
                    }
                }
            }
        });
        this.actionTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                LidModeConfiguration.this.editActionTableItem();
            }
        });
        this.actionTable.setLinesVisible(true);
        this.actionTable.setHeaderVisible(true);
        final TableColumn tblclmnModeId_1 = new TableColumn(this.actionTable, 0);
        tblclmnModeId_1.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnModeId_1.setText("Mode ID");
        final TableColumn tblclmnGpioPurposeId = new TableColumn(this.actionTable, 0);
        tblclmnGpioPurposeId.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnGpioPurposeId.setText("GPIO Purpose ID");
        TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(tableViewer_1, 0);
        final TableColumn tblclmnGPIOValue = tableViewerColumn_7.getColumn();
        tblclmnGPIOValue.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnGPIOValue.setText("Action");
        this.actionTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((LidModeConfiguration)LidModeConfiguration.this).actionTable.getClientArea().width / 3;
                tblclmnModeId_1.setWidth(oneWidth);
                tblclmnGpioPurposeId.setWidth(oneWidth);
                tblclmnGPIOValue.setWidth(oneWidth);
            }
        });
        this.btnAddAction = new Button((Composite)grpActions, 0);
        GridData gd_btnAddAction = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddAction.widthHint = GuiUtils.getButtonWidth((Control)grpActions);
        this.btnAddAction.setLayoutData((Object)gd_btnAddAction);
        this.btnAddAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.actionTable.deselectAll();
                new LidModeActionModifier(LidModeConfiguration.this._thisInstance, null).open();
            }
        });
        this.btnAddAction.setText("Add");
        this.btnEditAction = new Button((Composite)grpActions, 0);
        GridData gd_btnEditAction = new GridData(4, 4, false, false, 1, 1);
        gd_btnEditAction.widthHint = GuiUtils.getButtonWidth((Control)grpActions);
        this.btnEditAction.setLayoutData((Object)gd_btnEditAction);
        this.btnEditAction.setEnabled(false);
        this.btnEditAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.editActionTableItem();
            }
        });
        this.btnEditAction.setText("Edit");
        this.btnDeleteAction = new Button((Composite)grpActions, 0);
        GridData gd_btnDeleteAction = new GridData(4, 4, false, false, 1, 1);
        gd_btnDeleteAction.widthHint = GuiUtils.getButtonWidth((Control)grpActions);
        this.btnDeleteAction.setLayoutData((Object)gd_btnDeleteAction);
        this.btnDeleteAction.setEnabled(false);
        this.btnDeleteAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = LidModeConfiguration.this.actionTable.getSelectionIndices();
                if (selectedIndices.length > 0) {
                    LidModeConfiguration.this.actionTable.remove(selectedIndices);
                }
                LidModeConfiguration.this.refreshActionButtonsEnablility();
                LidModeConfiguration.this.setModified();
            }
        });
        this.btnDeleteAction.setText("Delete");
        Group grpHallConfig = new Group((Composite)this.shlLidMode, 0);
        grpHallConfig.setText("Hall Config Table");
        grpHallConfig.setLayout((Layout)new GridLayout(3, false));
        grpHallConfig.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewer tvHallConfig = new TableViewer((Composite)grpHallConfig, 67586);
        this.tblHallConfig = tvHallConfig.getTable();
        this.tblHallConfig.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tblHallConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = LidModeConfiguration.this.tblHallConfig.getSelectionCount();
                if (itemsSelected == 1) {
                    LidModeConfiguration.this.btnEditHall.setEnabled(true);
                    LidModeConfiguration.this.btnDeleteHall.setEnabled(true);
                } else {
                    LidModeConfiguration.this.btnEditHall.setEnabled(false);
                    if (itemsSelected > 1) {
                        LidModeConfiguration.this.btnDeleteHall.setEnabled(true);
                    } else {
                        LidModeConfiguration.this.btnDeleteHall.setEnabled(false);
                    }
                }
            }
        });
        this.tblHallConfig.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TableItem[] selectedItems = LidModeConfiguration.this.tblHallConfig.getSelection();
                if (selectedItems.length != 1) {
                    return;
                }
                new LidModeHallConfiguration(LidModeConfiguration.this._thisInstance, selectedItems[0], LidModeConfiguration.this.tblHallConfig.getSelectionIndex()).open();
            }
        });
        this.tblHallConfig.setLinesVisible(true);
        this.tblHallConfig.setHeaderVisible(true);
        final TableColumn tblclmnSensorType = new TableColumn(this.tblHallConfig, 0);
        tblclmnSensorType.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnSensorType.setText("SensorType");
        final TableColumn tblclmnInstanceId = new TableColumn(this.tblHallConfig, 0);
        tblclmnInstanceId.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnInstanceId.setText("Instance ID");
        this.tblHallConfig.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((LidModeConfiguration)LidModeConfiguration.this).tblHallConfig.getClientArea().width / 3;
                tblclmnSensorType.setWidth(oneWidth * 2);
                tblclmnInstanceId.setWidth(oneWidth);
            }
        });
        this.btnAddHall = new Button((Composite)grpHallConfig, 0);
        GridData gd_btnAddHall = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddHall.widthHint = GuiUtils.getButtonWidth((Control)grpHallConfig);
        this.btnAddHall.setLayoutData((Object)gd_btnAddHall);
        this.btnAddHall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.tblHallConfig.deselectAll();
                if (LidModeConfiguration.this.tblHallConfig.getItemCount() < 6) {
                    new LidModeHallConfiguration(LidModeConfiguration.this._thisInstance, null, 0).open();
                } else {
                    GuiUtils.showErrorMessage(LidModeConfiguration.this.shlLidMode, "Error", "The hall config cannot exceed 6.");
                }
            }
        });
        this.btnAddHall.setText("Add");
        this.btnEditHall = new Button((Composite)grpHallConfig, 0);
        GridData gd_btnEditHall = new GridData(4, 4, false, false, 1, 1);
        gd_btnEditHall.widthHint = GuiUtils.getButtonWidth((Control)grpHallConfig);
        this.btnEditHall.setLayoutData((Object)gd_btnEditHall);
        this.btnEditHall.setEnabled(false);
        this.btnEditHall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableItem[] selectedItems = LidModeConfiguration.this.tblHallConfig.getSelection();
                if (selectedItems.length != 1) {
                    return;
                }
                new LidModeHallConfiguration(LidModeConfiguration.this._thisInstance, selectedItems[0], LidModeConfiguration.this.tblHallConfig.getSelectionIndex()).open();
            }
        });
        this.btnEditHall.setText("Edit");
        this.btnDeleteHall = new Button((Composite)grpHallConfig, 0);
        GridData gd_btnDeleteHall = new GridData(4, 4, false, false, 1, 1);
        gd_btnDeleteHall.widthHint = GuiUtils.getButtonWidth((Control)grpHallConfig);
        this.btnDeleteHall.setLayoutData((Object)gd_btnDeleteHall);
        this.btnDeleteHall.setEnabled(false);
        this.btnDeleteHall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.deleteHallConfig();
            }
        });
        this.btnDeleteHall.setText("Delete");
        Composite ButtonComposite = new Composite((Composite)this.shlLidMode, 0);
        ButtonComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        GridLayout gridLayoutButtonComposite = new GridLayout(2, false);
        ButtonComposite.setLayout((Layout)gridLayoutButtonComposite);
        this.btnSaveAndClose = new Button(ButtonComposite, 0);
        GridData gd_btnSaveAndClose = new GridData(131072, 4, true, false, 1, 1);
        gd_btnSaveAndClose.widthHint = GuiUtils.getButtonWidth((Control)ButtonComposite);
        this.btnSaveAndClose.setLayoutData((Object)gd_btnSaveAndClose);
        this.btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.saveData();
            }
        });
        this.btnSaveAndClose.setText("Save and Close");
        Button btnCancel = new Button(ButtonComposite, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)ButtonComposite);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeConfiguration.this.shlLidMode.close();
            }
        });
        btnCancel.setText("Cancel");
        ((GridData)this.configTable.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.configTable) * 10;
        ((GridData)this.interruptsTable.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.interruptsTable) * 10;
        ((GridData)this.actionTable.getLayoutData()).heightHint = GuiUtils.getPixelSizeHeight((Control)this.actionTable) * 10;
        this.shlLidMode.setSize(GuiUtils.getPixelSizeWidth((Control)this.shlLidMode) * 156, GuiUtils.getPixelSizeHeight((Control)this.shlLidMode) * 45);
        this.shlLidMode.setLocation(GuiUtils.getMiddleLocation(this.shlLidMode, this.display));
    }

    @Override
    public String getConfigurationFormatName() {
        return "Platform Lid Mode Configuration";
    }
}

