/*
 * Decompiled with CFR 0.152.
 */
package entity;

import com.intel.sensing.fdk.model.SensorDataModel;
import com.intel.sensing.fdk.model.entity.AddressesEntity;
import com.intel.sensing.fdk.model.entity.BusInfoEntity;
import com.intel.sensing.fdk.model.entity.InterruptEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import com.intel.sensing.fdk.model.entity.SupportedCalibrationFormatsEntity;
import entity.GpioEntity;
import entity.SensorEntity;
import java.util.ArrayList;
import java.util.List;
import manager.common.Interrupt;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;

public class SensorEntityUtils {
    public static SensorEntity convertSensorDataEntityToSensorEntity(SensorDataEntity sensorDataEntity) {
        List calibrationFormatList;
        List gpioOnputsList;
        List gpioInputsList;
        int flags;
        List busInfoList;
        List dependencyList;
        if (sensorDataEntity == null) {
            return null;
        }
        SensorEntity entity = new SensorEntity();
        entity.setSensorTypeId(SensorDataModel.getSensorTypeIdAsInt((SensorDataEntity)sensorDataEntity));
        entity.setVendorId(SensorDataModel.getVendorIdAsInt((SensorDataEntity)sensorDataEntity));
        entity.setModelId(SensorDataModel.getModelIdAsInt((SensorDataEntity)sensorDataEntity));
        entity.setInstanceId(SensorDataModel.getInstanceIdAsInt((SensorDataEntity)sensorDataEntity));
        entity.setFlags(SensorDataModel.getFlagsAsInteger((SensorDataEntity)sensorDataEntity));
        entity.setModelName(sensorDataEntity.getModelName());
        entity.setSensorTypeName(sensorDataEntity.getSensorTypeName());
        entity.setVendorName(sensorDataEntity.getVendorName());
        String dependencyType = sensorDataEntity.getDependencyType();
        if (dependencyType != null) {
            if (dependencyType.matches("\\d+")) {
                entity.setDependencyType(ManagerEnums.DependencyTypes.getDependencyByValue((int)Integer.parseInt(dependencyType)));
            } else {
                entity.setDependencyType(ManagerEnums.DependencyTypes.getValueByName((String)dependencyType));
            }
        }
        if ((dependencyList = sensorDataEntity.getDependencies()) != null) {
            for (SensorDataEntity data : dependencyList) {
                entity.addDependency(SensorEntityUtils.convertSensorDataEntityToSensorEntity(data));
            }
        }
        if ((busInfoList = sensorDataEntity.getBusInfo()) != null) {
            ArrayList<ManagerEnums.BusTypes> busTypes = new ArrayList<ManagerEnums.BusTypes>();
            for (BusInfoEntity busInfo : busInfoList) {
                busTypes.add(ManagerEnums.BusTypes.getValueByName((String)busInfo.getBusType()));
            }
            entity.setBusTypes(busTypes);
        }
        if ((flags = SensorDataModel.getFlagsAsInteger((SensorDataEntity)sensorDataEntity).intValue()) >= 0) {
            boolean customFlag;
            boolean notExposedFlag = (entity.getFlags() & 0x40) > 0;
            boolean bl = customFlag = (entity.getFlags() & 0x80) > 0;
            if (sensorDataEntity.getCustomFlagvalue() == null) {
                entity.setDefineCustomFlag(customFlag);
                entity.setContainsCustomFlag(customFlag || entity.isContainsCustomFlag());
            } else {
                entity.setDefineCustomFlag(!sensorDataEntity.getCustomFlagvalue().equals(ManagerEnums.FlagValues.DEFINE_IN_PDT.name()));
                if (entity.isDefineCustomFlag()) {
                    entity.setContainsCustomFlag(customFlag);
                }
            }
            if (sensorDataEntity.getNotExposedFlagValue() == null) {
                entity.setDefineNotExposedFlag(notExposedFlag);
                entity.setContainsNotExposedFlag(notExposedFlag || entity.isContainsNotExposedFlag());
            } else {
                entity.setDefineNotExposedFlag(!sensorDataEntity.getNotExposedFlagValue().equals(ManagerEnums.FlagValues.DEFINE_IN_PDT.name()));
                if (entity.isDefineNotExposedFlag()) {
                    entity.setContainsNotExposedFlag(notExposedFlag);
                }
            }
        }
        List list = gpioInputsList = sensorDataEntity.getGpInputEntity() != null ? sensorDataEntity.getGpInputEntity().getInterruptEntity() : null;
        if (gpioInputsList != null) {
            ArrayList<GpioEntity> addInputList = new ArrayList<GpioEntity>();
            for (Object input : gpioInputsList) {
                addInputList.add(new GpioEntity(input.getName(), input.getPurposeId()));
            }
            entity.setGpioInput(addInputList);
        }
        List list2 = gpioOnputsList = sensorDataEntity.getGpOutputEntity() != null ? sensorDataEntity.getGpOutputEntity().getInterruptEntity() : null;
        if (gpioOnputsList != null) {
            ArrayList<GpioEntity> addOnputList = new ArrayList<GpioEntity>();
            for (InterruptEntity input : gpioOnputsList) {
                addOnputList.add(new GpioEntity(input.getName(), input.getPurposeId()));
            }
            entity.setGpioOutput(addOnputList);
        }
        if (busInfoList != null) {
            ArrayList<Integer> addAddressList = new ArrayList<Integer>();
            for (BusInfoEntity busInfo : busInfoList) {
                List addressStringList;
                AddressesEntity addessEntity = busInfo.getAddresses();
                if (addessEntity == null || (addressStringList = addessEntity.getAddress()) == null) continue;
                for (String temp : addressStringList) {
                    addAddressList.add(Integer.parseInt(temp));
                }
            }
            entity.setAddresses(addAddressList);
        }
        if ((calibrationFormatList = sensorDataEntity.getSupportedCalibrationFormats()) != null) {
            ArrayList<Integer> addCalibrationFormatList = new ArrayList<Integer>();
            for (SupportedCalibrationFormatsEntity format : calibrationFormatList) {
                addCalibrationFormatList.add(Integer.parseInt(format.getFormatId()));
            }
            entity.setCalibrationFormats(addCalibrationFormatList);
        }
        return entity;
    }

    public static SensorEntity convertSensorDataToSensorEntity(SensorData sensorData) {
        ArrayList calibrationFormatList;
        ArrayList addressList;
        ArrayList gpioOnputsList;
        boolean customFlag;
        if (sensorData == null) {
            return null;
        }
        SensorEntity entity = new SensorEntity();
        entity.setSensorTypeId(sensorData.getTypeId());
        entity.setVendorId(sensorData.getVendorId());
        entity.setModelId(sensorData.getModelId());
        entity.setInstanceId(sensorData.getInstanceId());
        entity.setFlags(sensorData.getFlagsAsInteger());
        entity.setModelName(sensorData.getModelName());
        entity.setSensorTypeName(sensorData.getTypeName());
        entity.setVendorName(sensorData.getVendorName());
        entity.setDependencyType(sensorData.getDependencyType());
        ArrayList dependencyList = sensorData.getDependencies();
        if (dependencyList != null) {
            for (SensorData data : dependencyList) {
                entity.addDependency(SensorEntityUtils.convertSensorDataToSensorEntity(data));
            }
        }
        entity.setBusTypes(sensorData.getBusTypes());
        boolean notExposedFlag = (entity.getFlags() & 0x40) > 0;
        boolean bl = customFlag = (entity.getFlags() & 0x80) > 0;
        if (sensorData.getCustomFlagvalue() == null) {
            entity.setDefineCustomFlag(customFlag);
            entity.setContainsCustomFlag(customFlag || entity.isContainsCustomFlag());
        } else {
            entity.setDefineCustomFlag(!sensorData.getCustomFlagvalue().equals((Object)ManagerEnums.FlagValues.DEFINE_IN_PDT));
            if (entity.isDefineCustomFlag()) {
                entity.setContainsCustomFlag(customFlag);
            }
        }
        if (sensorData.getNotExposedFlagvalue() == null) {
            entity.setDefineNotExposedFlag(notExposedFlag);
            entity.setContainsNotExposedFlag(notExposedFlag || entity.isContainsNotExposedFlag());
        } else {
            entity.setDefineNotExposedFlag(!sensorData.getNotExposedFlagvalue().equals((Object)ManagerEnums.FlagValues.DEFINE_IN_PDT));
            if (entity.isDefineNotExposedFlag()) {
                entity.setContainsNotExposedFlag(notExposedFlag);
            }
        }
        ArrayList gpioInputsList = sensorData.getGPInputs();
        if (gpioInputsList != null) {
            ArrayList<GpioEntity> addInputList = new ArrayList<GpioEntity>();
            for (Interrupt input : gpioInputsList) {
                addInputList.add(new GpioEntity(input.getName(), input.getPurposeId()));
            }
            entity.setGpioInput(addInputList);
        }
        if ((gpioOnputsList = sensorData.getGPOutputs()) != null) {
            ArrayList<GpioEntity> addOnputList = new ArrayList<GpioEntity>();
            for (Interrupt input : gpioOnputsList) {
                addOnputList.add(new GpioEntity(input.getName(), input.getPurposeId()));
            }
            entity.setGpioOutput(addOnputList);
        }
        if ((addressList = sensorData.getAddresses()) != null) {
            ArrayList<Integer> addAddressList = new ArrayList<Integer>();
            for (Integer address : addressList) {
                addAddressList.add(address);
            }
            entity.setAddresses(addAddressList);
        }
        if ((calibrationFormatList = sensorData.getCalibrationFormats()) != null) {
            ArrayList<Integer> addCalibrationFormatList = new ArrayList<Integer>();
            for (Integer format : calibrationFormatList) {
                addCalibrationFormatList.add(format);
            }
            entity.setCalibrationFormats(addCalibrationFormatList);
        }
        return entity;
    }

    public static List<SensorEntity> convertSensorDataListToSensorEntityList(List<SensorData> sensorDataList) {
        ArrayList<SensorEntity> sensorEntityList = new ArrayList<SensorEntity>();
        if (sensorDataList != null) {
            for (SensorData data : sensorDataList) {
                SensorEntity addEntity = SensorEntityUtils.convertSensorDataToSensorEntity(data);
                if (addEntity == null) continue;
                sensorEntityList.add(addEntity);
            }
        }
        return sensorEntityList;
    }

    public static List<String> getAddressArrayWithHex(SensorEntity entity, boolean isPrefix) {
        ArrayList<String> addressHexList = new ArrayList<String>();
        List<Integer> addressList = entity.getAddresses();
        if (addressList != null) {
            for (Integer address : addressList) {
                String hex = Integer.toHexString(address);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                if (isPrefix) {
                    addressHexList.add("0x" + hex);
                    continue;
                }
                addressHexList.add(hex);
            }
        }
        return addressHexList;
    }
}

