<?php
class HBA extends Device
{
	private $DriverVersion;
	private $BIOSVersion;
	private $FirmwareVersion;
	private $BootLoaderVersion;
	private $SystemIOBusNumber;
	private $SlotNumber;
	private $InterruptLevel;
	private $InterruptVector;
	
	//added 
	private $MaxPDPerVD;
	private $MaxPDPerDG;
	private $MaxVDPerDG;
	private $MaxParityDisks;
	
	private $PortCount;
	private $PortSupportType;
	
//	private $RAMSupport;
	private $MaxBlockPerPD;
	private $MaxHD;
        private $MaxAESEntry;
        private $MaxAESPort;
	private $MaxExpander;
	private $MaxPM;
	private $MaxLogicalDrive;
	private $LogicalDriverMode;
	private $DiskGroupSupport;
	
	//added
	private $Features;
	private $AlarmSupport;
	
	private $AdvancedFeatures;
	
	//config 
	private $AlarmOn;
	private $AutoRebuildOn;
	private $BGARate;
	//added 3-19
	private $SyncRate;
	private $InitRate;
	private $RebuildRate;
	private $MigrationRate;
	private $CopybackRate;
	private $ModelNumber;
	private $SSDCount;

	private $PollSMARTStatus;
	private $MediaPatrolRate;
	private $CopyBack;

//	private $SuspendMode;
	//added 3-12
	private $InterruptCoalescing;
	private $ModuleConsolidate;
        private $MaxSSDPerHyperDuo;
	
	/*
	private $VenDevID;
	private $SubVenDevID;
	*/
	
	#changed vendev id
	private $VenID;
	private $SubVenID;
	private $DevID;
	private $SubDevID;
	
	#chip version
	private $RevisionID;
	
	private $portSasAddr = array();
	private $serialNo;
	private $StripeSizeSupported;
	private $MaxSpeed;
	private $CurrentSpeed;
	private $MaxLinkWidth;
	private $CurrentLinkWidth;
	private $MediaPatrolSupport;
	private $ScheduleSupport;
	private $BGASupport;
	private $SpareSupport;
	private $IsSSDAdapter;
//for oem lenovo
    private $PartNumber;
    private $WWN;
    private $CardSKU;

	public function getMaxSSDPerHyperDuo()
	{
		return $this->MaxSSDPerHyperDuo;
	}

	public function isSSDAdapter()
	{
		return $this->IsSSDAdapter;
	}
	
	public function supportBGA()
	{
		return $this->BGASupport;
	}
	
	public function supportMediaPatrol()
	{
		return $this->MediaPatrolSupport;
	}
	
	public function supportSchedule()
	{
		return $this->ScheduleSupport;
	}
	
	public function supportSpare()
	{
		return $this->SpareSupport;
	}
	
	public function getStripeSizeSupported()
	{
		return $this->StripeSizeSupported;
	}
	
	public function supportStripeSize16()
	{
		return $this->StripeSizeSupported & SupportStripeSize::STRIPE_SIZE_16;
	}
	
	public function supportStripeSize32()
	{
		return $this->StripeSizeSupported & SupportStripeSize::STRIPE_SIZE_32;
	}
	
	public function supportStripeSize64()
	{
		return $this->StripeSizeSupported & SupportStripeSize::STRIPE_SIZE_64;
	}
	
	public function supportStripeSize128()
	{
		return $this->StripeSizeSupported & SupportStripeSize::STRIPE_SIZE_128;
	}
	
	public function supportStripeSize256()
	{
		return $this->StripeSizeSupported & SupportStripeSize::STRIPE_SIZE_256;
	}
	
	public function supportStripeSize512()
	{
		return $this->StripeSizeSupported & SupportStripeSize::STRIPE_SIZE_512;
	}
	
	public function supportStripeSize1024()
	{
		return $this->StripeSizeSupported & SupportStripeSize::STRIPE_SIZE_1024;
	}
	
	public function getMaxSpeed()
	{
		return $this->MaxSpeed;
	}
	
	public function supportPCIEStatus()
	{
		return ($this->MaxSpeed != PCIESpeed::PCIE_SPEED_UNKNOWN);
	}
	
	public function getCurrentSpeed()
	{
		return $this->CurrentSpeed;
	}
	
	public function getMaxLinkWidth()
	{
		return $this->MaxLinkWidth;
	}
	
	public function getCurrentLinkWidth()
	{
		return $this->CurrentLinkWidth;
	}
	
	public function getSerialNo()
	{
		return $this->serialNo;
	}
	public function setSerialNo($serialNo)
	{
		$this->serialNo = $serialNo;
	}
	
	public function getPortSasAddr()
	{
		return $this->portSasAddr;
	}
	public function setPortSasAddr($portSasAddr)
	{
		$this->portSasAddr = $portSasAddr;
	}
	
	public function getRevisionID()
	{
		return $this->RevisionID;
	}
	
	public function getVenID()
	{
		return $this->VenID;
	}
	public function getSubVenID()
	{
		return $this->SubVenID;
	}
	public function getDevID()
	{
		return $this->DevID;
	}
	public function getSubDevID()
	{
		return $this->SubDevID;
	}
	
	
	public function __construct()
	{
		$this->setDevType(DeviceType::DEVICE_TYPE_PORT);
	}
	
	public function isSAS()
	{
		return false;
	}
	
	public function getBGARate()
	{
		return $this->BGARate;
	}
	public function setBGARate($BGARate)
	{
		$this->BGARate = $BGARate;
	}
	
	public function getCopyBack()
	{
		return $this->CopyBack;
	}
	public function setCopyBack($CopyBack)
	{
		$this->CopyBack = $CopyBack;
	}
	
	public function getSyncRate()
	{
		return $this->SyncRate;
	}
	public function setSyncRate($SyncRate)
	{
		$this->SyncRate = $SyncRate;
	}
	
	public function getInitRate()
	{
		return $this->InitRate;
	}
	public function setInitRate($InitRate)
	{
		$this->InitRate = $InitRate;
	}
	
	public function getRebuildRate()
	{
		return $this->RebuildRate;
	}
	public function setRebuildRate($RebuildRate)
	{
		$this->RebuildRate = $RebuildRate;
	}
	
	public function getMigrationRate()
	{
		return $this->MigrationRate;
	}
	public function setMigrationRate($MigrationRate)
	{
		$this->MigrationRate = $MigrationRate;
	}
	
	public function getCopybackRate()
	{
		return $this->CopybackRate;
	}
	public function setCopybackRate($CopybackRate)
	{
		$this->CopybackRate = $CopybackRate;
	}
	
	public function getModelNumber()
	{
		return $this->ModelNumber;
	}
	
	public function getSSDCount()
	{
		return $this->SSDCount;
	}
	
	public function getMediaPatrolRate()
	{
		return $this->MediaPatrolRate;
	}
	public function setMediaPatrolRate($MediaPatrolRate)
	{
		$this->MediaPatrolRate = $MediaPatrolRate;
	}
	
	public function getModuleConsolidate()
	{
		return $this->ModuleConsolidate;
	}
	public function setModuleConsolidate($ModuleConsolidate)
	{
		$this->ModuleConsolidate = $ModuleConsolidate;
	}
	public function getInterruptCoalescing()
	{
		return $this->InterruptCoalescing;
	}
	public function setInterruptCoalescing($InterruptCoalescing)
	{
		$this->InterruptCoalescing = $InterruptCoalescing;
	}
	
	public function isPollSMARTOn()
	{
		return $this->PollSMARTStatus;
	}
	
	public function setPollSMARTOn()
	{
		$this->PollSMARTStatus = 1;
	}
	
	public function setPollSMARTOff()
	{
		$this->PollSMARTStatus = 0;
	}
	
	public function isAutoRebuildOn()
	{
		return $this->AutoRebuildOn;
	}
	
	public function setAutoRebuildOn()
	{
		$this->AutoRebuildOn = 1;
	}
	
	public function setAutoRebuildOff()
	{
		$this->AutoRebuildOn = 0;
	}
	
/*	public function isSuspendModeOn()
	{
		return $this->SuspendMode;
	}
	
	public function setSuspendModeOn()
	{
		$this->SuspendMode = 1;
	}
	
	public function setSuspendModeOff()
	{
		$this->SuspendMode = 0;
	}*/
	
	public function isAlarmOn()
	{
		return $this->AlarmOn;
	}
	
	public function setAlarmOn()
	{
		$this->AlarmOn = 1;
	}
	
	public function setAlarmOff()
	{
		$this->AlarmOn = 0;
	}
	
	public function supportRAID()
	{
		return $this->LogicalDriverMode != 0;
	}
	
	public function supportLDRaid0()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID0;
	}
	
	public function supportLDRaid1()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID1;
	}
	
	public function supportLDRaid10()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID10;
	}
	
	public function supportLDRaid1E()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID1E;
	}
	
	public function supportLDRaid5()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID5;
	}
	
	public function supportLDRaid50()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID50;
	}
	
	public function supportLDRaid6()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID6;
	}
	
	public function supportLDRaid60()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_RAID60;
	}
	
	public function supportLDRaidJBOD()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_JBOD;
	}
	
	public function supportLDRaidHyperHDD()
	{
		return ($this->supportHyperHDDSpan() || $this->supportHyperHDDMirror());
	}
	
	public function supportHyperHDDSpan()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_CROSS_SATA_SSD;
	}
	
	public function supportHyperHDDMirror()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_HYPPER_HDD_MIRROR;
	}

	public function supportHybrid()
	{
		return $this->LogicalDriverMode & SupportLdRaidMode::SUPPORT_LD_MODE_HYBRID_HDD_MIRROR;
	}

	/*public function supportMediaPatrol()
	{
		return $this->Features & HBAFeature::FEATURE_BGA_MEDIAPATROL_SUPPORT;
	}
	*/
	public function supportMigration()
	{
		return $this->Features & HBAFeature::FEATURE_BGA_MIGRATION_SUPPORT;
	}
	
	public function supportRebuild()
	{
		return $this->Features & HBAFeature::FEATURE_BGA_REBUILD_SUPPORT;
	}
	
	public function supportForegroundInit()
	{
		return $this->Features & HBAFeature::FEATURE_BGA_FEINIT_SUPPORT ;
	}
	
	public function supportBackgroundInit()
	{
		return $this->Features & HBAFeature::FEATURE_BGA_BKINIT_SUPPORT ;
	}
	
	public function supportSyncronization()
	{
		return $this->Features & HBAFeature::FEATURE_BGA_SYNC_SUPPORT ;
	}
	
	public function supportCopyback()
	{
		return $this->Features & HBAFeature::FEATURE_BGA_COPY_BACK_SUPPORT ;
	}
		
	public function supportSameTypePDsForCreate()
	{
		return $this->Features & HBAFeature::FEATURE_PD_OF_SAME_TYPE_WHEN_CREATE_VD ;
	}

        public function supportBGARateChange()
        {

            return !($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_NO_BGA_RATE_CHANGE);
        }
	
	public function supportSPC4()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_SPC_4_BUFFER;
	}
	
	public function supportBigStripe()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_BIG_STRTPE_SUPPORT;
	}
	
	public function supportEventSenseCode()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_EVENT_WITH_SENSE_CODE;
	}
	
	public function supportBiosOption()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_BIOS_OPTION_SUPPORT;
	}
	
	public function supportBBU()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_HAS_BBU ;
	}
	
	public function supportOptimizeCpuEfficiency()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_CPU_EFFICIENCY_SUPPORT ;
	}

	public function supportModuleConsolidate()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_MODULE_CONSOLIDATE  ;
	}
	
	public function supportCrypto()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_CRYPTO_SUPPORT;
	}
	
	public function supportVDWriteCache()
	{
		return !($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_NO_VD_WRITE_CACHE_SUPPORT);
	}
	
	public function supportVDReadCache()
	{
		return !($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_NO_VD_READ_CACHE_SUPPORT);
	}
    
    public function supportMultiSSDForHyperDuo()
	{
		return ($this->MaxSSDPerHyperDuo > 1);
	}

	public function supportHybridSwitch()
	{
		return ($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_HYBRID_SWITCH_SUPPORT);
	}

	public function supportHDSmart()
	{
		return !($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_NO_HD_SMART_SUPPORT);
	}
	
	public function supportVDRounding()
	{
		return !($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_NO_VD_ROUNDING_SUPPORT);
	}
	
	public function supportHDSetFree()
	{
		return !($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_NO_HD_SETFREE_SUPPORT);
	}	

	public function supportHDWriteCache()
	{
		return !($this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_NO_HD_WRITE_CACHE_SUPPORT);
	}	
        
	public function supportIntelligentKeep()
	{
		return $this->AdvancedFeatures & HBAAdvFeature::ADV_FEATURE_HYPERDUO_INTELLIGENT_INIT;
	}


	public function supportAlarm()
	{
		return $this->AlarmSupport;
	}
	
	public function supportDG()
	{
		return $this->DiskGroupSupport > 0;
	}
	
	public function getDriverVersion()
	{
		return $this->DriverVersion;
	}
	
	public function getBIOSVersion()
	{
		return $this->BIOSVersion;
	}
	
	public function getFirmwareVersion()
	{
		return $this->FirmwareVersion;
	}
	
	public function getBootLoaderVersion()
	{
		return $this->BootLoaderVersion;
	}
	
	public function getSystemIOBusNumber()
	{
		return $this->SystemIOBusNumber;
	}
	public function getSlotNumber()
	{
		return $this->SlotNumber;
	}
	
	/*
	public function getSubVenDevID()
	{
		return $this->SubVenDevID;
	}
	
	public function getVenDevID()
	{
		return $this->VenDevID;
	}
	*/
	
	public function getInterruptLevel()
	{
		return $this->InterruptLevel;
	}
	public function getInterruptVector()
	{
		return $this->InterruptVector;
	}
	public function getMaxPDPerVD()
	{
		return $this->MaxPDPerVD;
	}
	public function getMaxPDPerDG()
	{
		return $this->MaxPDPerDG;
	}
	public function getMaxVDPerDG()
	{
		return $this->MaxVDPerDG;
	}	
	public function getMaxParityDisks()
	{
		return $this->MaxParityDisks;
	}	
	public function getPortCount()
	{
		return $this->PortCount;
	}
	public function getPortSupportType()
	{
		return $this->PortSupportType;
	}
	public function getRAMSupport()
	{
		return $this->RAMSupport;
	}
	public function getMaxBlockPerPD()
	{
		return $this->MaxBlockPerPD;
	}
	public function getMaxHD()
	{
		return $this->MaxHD;
	}
	public function getMaxExpander()
	{
		return $this->MaxExpander;
	}
	public function getMaxPM()
	{
		return $this->MaxPM;
	}
	public function getMaxLogicalDrive()
	{
		return $this->MaxLogicalDrive;
	}
	public function getLogicalDriverMode()
	{
		return $this->LogicalDriverMode;
	}
	public function getDiskGroupSupport()
	{
		return $this->DiskGroupSupport;
	}
	
	public function getAdvancedFeatures()
	{
		return $this->AdvancedFeatures;
	}
	
	public function getFeatures()
	{
		return $this->Features;
	}	
	public function getAlarmSupport()
	{
		return $this->AlarmSupport;
	}

	public function getPartNumber()
	{
		return $this->PartNumber;
	}
	public function getWWN()
	{
		return $this->WWN;
	}
	public function getCardSKU()
	{
		return $this->CardSKU;
	}
	public function setHBAConfig($Config)
	{
		//config 
		if (isset($Config->AlarmOn)) {
			if (trim($Config->AlarmOn)) 
			{
				$this->setAlarmOn(); 
			}
			else 
				$this->setAlarmOff(); 
		}
		
		if (isset($Config->AutoRebuildOn)) {
			if (trim($Config->AutoRebuildOn)) 
			{
				$this->setAutoRebuildOn(); 
			}
			else 
				$this->setAutoRebuildOff(); 
		}
		if (isset($Config->InterruptCoalescing)) {
			$this->InterruptCoalescing = trim($Config->InterruptCoalescing);
		}
		if (isset($Config->ModuleConsolidate)) {
			$this->ModuleConsolidate = trim($Config->ModuleConsolidate);
		}
		if (isset($Config->BGARate)) {
			$this->BGARate = trim($Config->BGARate);
		}
		
		if (isset($Config->MediaPatrolRate)) {
			$this->MediaPatrolRate = trim($Config->MediaPatrolRate);
		}
		
		if (isset($Config->PollSMARTStatus)) {
			if (trim($Config->PollSMARTStatus)) 
			{
				$this->setPollSMARTOn(); 
			}
			else 
				$this->setPollSMARTOff();
		}
		//added 3-19
		if (isset($Config->CopyBack)) {
			$this->CopyBack = trim($Config->CopyBack);
		}
		if (isset($Config->SyncRate)) {
			$this->SyncRate = trim($Config->SyncRate);
		}
		if (isset($Config->InitRate)) {
			$this->InitRate = trim($Config->InitRate);
		}
		if (isset($Config->RebuildRate)) {
			$this->RebuildRate = trim($Config->RebuildRate);
		}
		if (isset($Config->MigrationRate)) {
			$this->MigrationRate = trim($Config->MigrationRate);
		}
		if (isset($Config->CopybackRate)) {
			$this->CopybackRate = trim($Config->CopybackRate);
		}
	}

	public function setHBAInfo($Info)
	{
		foreach ($Info->DriverVersion as $Version)
		{
			$this->setDriverVersion($Version);
		}
		
		foreach ($Info->BIOSVersion as $Version)
		{
			$this->setBIOSVersion($Version);
		}
		
		foreach ($Info->FirmwareVersion as $Version)
		{
			$this->setFirmwareVersion($Version);
		}
		
		foreach ($Info->BootLoaderVersion as $Version)
		{
			$this->setBootLoaderVersion($Version);
		}
		
		$this->setName( trim($Info->VenID) . " ". trim($Info->DevID));
		
		if (isset($Info->VenID)) {
			$this->VenID = trim($Info->VenID);
		}
		
		if (isset($Info->SubVenID)) {
			$this->SubVenID = trim($Info->SubVenID);
		}
		
		if (isset($Info->DevID)) {
			$this->DevID = trim($Info->DevID);
		}
		
		if (isset($Info->SubDevID)) {
			$this->SubDevID = trim($Info->SubDevID);
		}
		
		if (isset($Info->RevisionID)) {
			$this->RevisionID = trim($Info->RevisionID);
		}
		
		if (isset($Info->SystemIOBusNumber)) {
			$this->SystemIOBusNumber = trim($Info->SystemIOBusNumber);
		}
		if (isset($Info->SlotNumber)) {
			$this->SlotNumber = trim($Info->SlotNumber);
		}
		if (isset($Info->InterruptLevel)) {
			$this->InterruptLevel = trim($Info->InterruptLevel);
		}
		if (isset($Info->InterruptVector)) {
			$this->InterruptVector = trim($Info->InterruptVector);
		}
		if (isset($Info->MaxPDPerVD)) {
			$this->MaxPDPerVD = trim($Info->MaxPDPerVD);
		}
		if (isset($Info->MaxPDPerDG)) {
			$this->MaxPDPerDG = trim($Info->MaxPDPerDG);
		}
		if (isset($Info->MaxVDPerDG)) {
			$this->MaxVDPerDG = trim($Info->MaxVDPerDG);
		}
		if (isset($Info->MaxParityDisks)) {
			$this->MaxParityDisks = trim($Info->MaxParityDisks);
		}		
		if (isset($Info->PortCount)) {
			$this->PortCount = trim($Info->PortCount);
		}
		if (isset($Info->PortSupportType)) {
			$this->PortSupportType = trim($Info->PortSupportType);
		}
/*		if (isset($Info->RAMSupport)) {
			$this->RAMSupport = trim($Info->RAMSupport);
		}
*/
		if (isset($Info->MaxBlockPerPD)) {
			$this->MaxBlockPerPD = trim($Info->MaxBlockPerPD);
		}
		if (isset($Info->MaxExpander)) {
			$this->MaxExpander = trim($Info->MaxExpander);
		}
		if (isset($Info->MaxHD_Ext)) {
			$this->MaxHD = trim($Info->MaxHD_Ext);
		}
		if (isset($Info->MaxAESPort)) {
			$this->MaxAESPort = trim($Info->MaxAESPort);
		}
		if (isset($Info->MaxAESEntry)) {
			$this->MaxAESEntry = trim($Info->MaxAESEntry);
		}
		if (isset($Info->MaxLogicalDrive)) {
			$this->MaxLogicalDrive = trim($Info->MaxLogicalDrive);
		}
		if (isset($Info->MaxPM)) {
			$this->MaxPM = trim($Info->MaxPM);
		}
		if (isset($Info->LogicalDriverMode)) {
			$this->LogicalDriverMode = trim($Info->LogicalDriverMode);
		}
		if (isset($Info->DiskGroupSupport)) {
			$this->DiskGroupSupport = trim($Info->DiskGroupSupport);
		}
		
		if (isset($Info->Features)) {
			$this->Features = trim($Info->Features);
		}
		if (isset($Info->AdvancedFeatures)) {
			$this->AdvancedFeatures = (float)$Info->AdvancedFeatures;
		}
		if (isset($Info->AlarmSupport)) {
			$this->AlarmSupport = trim($Info->AlarmSupport);
		}
		
		if (isset($Info->StripeSizeSupported)) {
			$this->StripeSizeSupported = trim($Info->StripeSizeSupported);			
		}
		
		if (isset($Info->MaxSpeed)) {
			$this->MaxSpeed = trim($Info->MaxSpeed);			
		}
		
		if (isset($Info->CurrentSpeed)) {
			$this->CurrentSpeed = trim($Info->CurrentSpeed);			
		}
		
		if (isset($Info->MaxLinkWidth)) {
			$this->MaxLinkWidth = trim($Info->MaxLinkWidth);			
		}
		
		if (isset($Info->CurrentLinkWidth)) {
			$this->CurrentLinkWidth = trim($Info->CurrentLinkWidth);			
		}
		
		for($i = 0; $i < $this->PortCount; $i++)
		{
			$port = "PortSasAddress" . $i;
			if (isset($Info->$port)) {
				$this->portSasAddr[$i] = $this->char8toSas(trim($Info->$port));
			}
		}
		
		if (isset($Info->MediaPatrolSupport)) {
			$this->MediaPatrolSupport = trim($Info->MediaPatrolSupport);			
		}
		
		if (isset($Info->ScheduleSupport)) {
			$this->ScheduleSupport = trim($Info->ScheduleSupport);			
		}
		
		if (isset($Info->BGASupport)) {
			$this->BGASupport = trim($Info->BGASupport);			
		}
		
		if (isset($Info->SpareSupport)) {
			$this->SpareSupport = trim($Info->SpareSupport);			
		}
		
		if (isset($Info->IsSSDAdapter)) {
			$this->IsSSDAdapter = trim($Info->IsSSDAdapter);			
		}
		
		if (isset($Info->SSDCount)){
			$this->SSDCount = trim($Info->SSDCount);
		}

		if (isset($Info->MaxSSDPerHyperDuo)){
			$this->MaxSSDPerHyperDuo = trim($Info->MaxSSDPerHyperDuo);
		}
//
		if (isset($Info->SerialNo)) {
			$this->serialNo = trim($Info->SerialNo);
		}

		if (isset($Info->ModelNumber)) {
			$this->ModelNumber = trim($Info->ModelNumber);
		}
//for oem lenovo
		if (isset($Info->PartNumber)) {
			$this->PartNumber = trim($Info->PartNumber);
		}

		if (isset($Info->WWN)) {
			$this->WWN = trim($Info->WWN);
		}

		if (isset($Info->CardSKU)) {
			$this->CardSKU = trim($Info->CardSKU);
		}
	}
	
	private function char8toSas($char8)
	{
		$sasAddr = new SASAddress();
		$charsContainSpace = explode(" ", $char8);
		$chars = array();
		foreach ($charsContainSpace as $char)
		{
			if (trim($char) !== "") {
				$chars[] = $char;
			}
		}
		$high = sprintf("%02X%02X%02X%02X", $chars[0], $chars[1], $chars[2], $chars[3]);
		$low = sprintf("%02X%02X%02X%02X", $chars[4], $chars[5], $chars[6], $chars[7]);

		$sasAddr->setHigh(hexdec($high));
		$sasAddr->setLow(hexdec($low));
		
		return $sasAddr;
	}
	
	private function  setDriverVersion($DriverVersion)
	{
		$this->DriverVersion = 
			$DriverVersion->VerMajor . "."
			. $DriverVersion->VerMinor . "."
			. $DriverVersion->VerOEM . "."
			. $this->getBuildVersion($DriverVersion->VerBuild);
	}
	private function setBIOSVersion($BIOSVersion)
	{
		$this->BIOSVersion = 
			$BIOSVersion->VerMajor . "."
			. $BIOSVersion->VerMinor . "."
			. $BIOSVersion->VerOEM . "."
			. $this->getBuildVersion($BIOSVersion->VerBuild);
	}
	private function setFirmwareVersion($Version)
	{
		$this->FirmwareVersion = 
			$Version->VerMajor . "."
			. $Version->VerMinor . "."
			. $Version->VerOEM . "."
			. $this->getBuildVersion($Version->VerBuild);
	}
	private function setBootLoaderVersion($Version)
	{
		$this->BootLoaderVersion = 
			$Version->VerMajor . "."
			. $Version->VerMinor . "."
			. $Version->VerOEM . "."
			. $this->getBuildVersion($Version->VerBuild);
	}
	
	private function getBuildVersion($version)
	{
		return sprintf("%04d", intval($version));
	}
}
?>