<?php
//include_once("PageDisplayer.class.php");

class PgBgaScheduleDisplayer extends PageDisplayer
{
	protected function initPage()
	{
		//if (!getSessionPara('isAdmin')) 
		//{
	        //$this->displayDefaultPage(Target::LoginPage);
	        //return;
		//}
				
		$smarty = $this->smarty;		
		$type = getRequestPara('type');
		$pageID = getRequestPara('pageID');
		$bgaType = getRequestPara('bgaType');
		
		$selectedJobIDs = trim(getRequestPara('selectedJobIDs'));
		
		if ($selectedJobIDs && $type == 'modifyTime') {
			//modify job time
			$this->modifyJobTime();
			return;
		}
		
		if ($type == 'delete') {
			$selectedJobIDs = getRequestPara('selectedJobIDs');
			//do delete
			if (trim($selectedJobIDs)) {
				$selectedJobIDs = trim($selectedJobIDs);
				$idArr = explode(' ',$selectedJobIDs);
				$DA = new BGAJobDataAccess();
				foreach ($idArr as $id)
				{
					$DA->deleteBGAJobByID($id);
				}
			}
			//$this->displayDefaultPage(Target::BgaSchedulePage);
			$this->jumptoPage('Target=BgaSchedulePage&pageID=' . $pageID);
		}
		else if ($type == 'bgaSave') {		
			// no job id,so new job
			//new bga schedule
			//will pop up window for time setting.
			$this->addBGAJob();
		}
		else if ($type == 'saveModify') {
			//submit from bga save page
			$JobID = getRequestPara('jobID');
			if ($JobID) {				
				$da = new BGAJobDataAccess();
				$modifyJob = $da->getBGAJobByID($JobID);
				if ($modifyJob) {
					$status = $modifyJob->getStatus();
					$settingType = $modifyJob->getSettingType();
					if( $status != ScheduleStatus::NOT_RUN && ScheduleSettingType::No_REPEAT == $settingType)
					{
						//can not modify
						//$CanNotModify = gettext('Can not modify!');
						//$smarty->assign("CanNotModify",$CanNotModify);
						//return ;
						$this->jumptoPage('Target=BgaSchedulePage&CanNotModify=1&pageID=' . $pageID);
					}else {
						//will only modify bga type
						$this->modifyBGAJob();
					}
				}
			}
		}
		
		if (getRequestPara('refresh') != null) {
			//when time is setted,must refresh for update display out.
			//so redirecting may fix this problem.
			$this->jumptoPage('Target=BgaSchedulePage&pageID=' . $pageID);
		}
		
		if (getRequestPara('CanNotModify') != null) {
			$smarty->assign("CanNotModify",1);
		}
		
		//for ScheduleSupport flag
		$SysDtl = new CtnSystemDetail();
		$SysDtl->toGetSysInfo();
		$SysDtl->smartyAssign($smarty);
		$SysDtl->initContainer();
		
		$jobs = new CtnBGAJobList();
		$jobs->smartyAssign($smarty);
		$jobs->setPageID($pageID);
		$jobs->initContainer();
		$this->setPageName(Target::BgaSchedulePage . ".tpl");
		
	}
	
	private function modifyBGAJob()
	{
		$pageID = getRequestPara('pageID');
		$JobID = getRequestPara('jobID');
		$VDID = getRequestPara('VDID');
		$bgaType = getRequestPara('bgaType');
		$cmdPara = getRequestPara('cmdPara');
		
		$settingType = getRequestPara('settingType');
		$settingTime = trim(getRequestPara('settingTime'));
		
		$job = new BGAJob();
		
		if($settingType != '' && $settingTime != '')
		{
			$settingTime = substr($settingTime,0,2) . substr($settingTime,3,2);
			//only once
			if ($settingType == ScheduleSettingType::No_REPEAT) {
				$settingDate = getRequestPara('settingDate1');
				$month = substr($settingDate,0,2);
				$day = substr($settingDate,3,2);
				$year = substr($settingDate,6,4);
				$settingDate = date('Ymd',mktime(0,0,0,$month,$day,$year));
				$settingDateSupplement = 0;
			}
			else if ($settingType == ScheduleSettingType::DAY_REPEAT) {
				$settingDate = getRequestPara('settingDate2');
				$settingDateSupplement = getRequestPara('settingDateSupplement2');
			}
			else if ($settingType == ScheduleSettingType::WEEK_REPEAT) {
				$settingDate = getRequestPara('settingDate3');
				$settingDateSupplement = getRequestPara('settingDateSupplement3');
			}
			else if ($settingType == ScheduleSettingType::MONTH_REPEAT) {
				$settingDate = getRequestPara('settingDate4');
				$settingDateSupplement = getRequestPara('settingDateSupplement4');
			}
			$job->setSettingType($settingType);
			$job->setSettingTime($settingTime);
			$job->setSettingDate($settingDate);
			$job->setSettingDateSupplement($settingDateSupplement);
		}
		
		$job->setBgaType($bgaType);
		if($bgaType == ScheduledBGAType::HD_BGA_MP)
		{
			$HDs = getUrlPropertyValue($cmdPara,'HDs');
			$job->setVDID($HDs);
		}
		else
		{
			//DG and VD
			$job->setVDID($VDID);
		}
		$job->setCmdPara($cmdPara);
		
		$DA = new BGAJobDataAccess();
		$JobID = $DA->updateBGAJobByID($JobID,$job);
		
		//$this->jumptoPage('Target=BgaSchedulePage&pageID=' . $pageID);
	}
	
	private function addBGAJob()
	{
		$VDID = getRequestPara('VDID');
		$bgaType = getRequestPara('bgaType');
		$cmdPara = getRequestPara('cmdPara');
		
		$settingType = getRequestPara('settingType');
		$settingTime = trim(getRequestPara('settingTime'));
		$settingTime = substr($settingTime,0,2) . substr($settingTime,3,2);
		//only once
		if ($settingType == ScheduleSettingType::No_REPEAT) {
			$settingDate = getRequestPara('settingDate1');
			$month = substr($settingDate,0,2);
			$day = substr($settingDate,3,2);
			$year = substr($settingDate,6,4);
			$settingDate = date('Ymd',mktime(0,0,0,$month,$day,$year));
			$settingDateSupplement = 0;
		}
		else if ($settingType == ScheduleSettingType::DAY_REPEAT) {
			$settingDate = getRequestPara('settingDate2');
			$settingDateSupplement = getRequestPara('settingDateSupplement2');
		}
		else if ($settingType == ScheduleSettingType::WEEK_REPEAT) {
			$settingDate = getRequestPara('settingDate3');
			$settingDateSupplement = getRequestPara('settingDateSupplement3');
		}
		else if ($settingType == ScheduleSettingType::MONTH_REPEAT) {
			$settingDate = getRequestPara('settingDate4');
			$settingDateSupplement = getRequestPara('settingDateSupplement4');
		}
		
		$now = getNow();
		$nowTime = strtotime($now);
		$startTime = date('YmdHi',$nowTime);
		$status = ScheduleStatus::NOT_RUN;
		$result = '0';
		$resultText = 'Not Run';
		
		$job = new BGAJob();
		
		$job->setBgaType($bgaType);
		if($bgaType == ScheduledBGAType::HD_BGA_MP)
		{
			$HDs = getUrlPropertyValue($cmdPara,'HDs');
			$job->setVDID($HDs);
		}
		else
		{
			//VD and DG
			$job->setVDID($VDID);
		}
		$job->setCmdPara($cmdPara);
		
		$job->setSettingType($settingType);
		$job->setSettingTime($settingTime);
		$job->setSettingDate($settingDate);
		$job->setSettingDateSupplement($settingDateSupplement);
		
		$job->setStartTime($startTime);
		$job->setStatus($status);
		$job->setResult($result);
		$job->setResultText($resultText);
		
		$DA = new BGAJobDataAccess();
		$JobID = $DA->addJob($job);
		
		//$this->jumptoPage('Target=BgaSchedulePage&pageID=0');
	}
	
	private function modifyJobTime()
	{
		$selectedJobIDs = trim(getRequestPara('selectedJobIDs'));
		
		//submit for modification
		$settingType = getRequestPara('settingType');
		$settingTime = trim(getRequestPara('settingTime'));
		$settingTime = substr($settingTime,0,2) . substr($settingTime,3,2);
		//only once
		if ($settingType == ScheduleSettingType::No_REPEAT) {
			$settingDate = getRequestPara('settingDate1');
			$month = substr($settingDate,0,2);
			$day = substr($settingDate,3,2);
			$year = substr($settingDate,6,4);
			$settingDate = date('Ymd',mktime(0,0,0,$month,$day,$year));
			$settingDateSupplement = 0;
		}
		else if ($settingType == ScheduleSettingType::DAY_REPEAT) {
			$settingDate = getRequestPara('settingDate2');
			$settingDateSupplement = getRequestPara('settingDateSupplement2');
		}
		else if ($settingType == ScheduleSettingType::WEEK_REPEAT) {
			$settingDate = getRequestPara('settingDate3');
			$settingDateSupplement = getRequestPara('settingDateSupplement3');
		}
		else if ($settingType == ScheduleSettingType::MONTH_REPEAT) {
			$settingDate = getRequestPara('settingDate4');
			$settingDateSupplement = getRequestPara('settingDateSupplement4');
		}
		
		$job = new BGAJob();
		$job->setSettingType($settingType);
		$job->setSettingTime($settingTime);
		$job->setSettingDate($settingDate);
		$job->setSettingDateSupplement($settingDateSupplement);
		
		$idArr = explode(' ',$selectedJobIDs);//
		
		if (sizeof($idArr)) {
			$da = new BGAJobDataAccess();
			foreach ($idArr as $id)
			{
				if (trim($id) !== "") {
					$da->updateBGAJobTimeByID($id,$job);
				}
			}
		}
	}
}
?>