<?php

abstract class LdXmlHandler extends XmlHandler
{
	
}

class SSDVolumeCreateMaxSizeXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->Size)) {
			$factory->addObj(0, floatval(trim($XMLRoot->Size)));
		}
	}
}

class LdCreateMaxSizeXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->CreateLDParam->Size)) {
			$factory->addObj(0, floatval(trim($XMLRoot->CreateLDParam->Size)));
		}
	}
}

class LdMigrateMaxSizeXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		
		if (isset($XMLRoot->CreateLDParam->Size)) {
			$factory->addObj(0, floatval(trim($XMLRoot->CreateLDParam->Size)));
		}
	}
}

class PackageVDInfoXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		if (isset($XMLRoot->PackageVD_Info) && !empty($XMLRoot->PackageVD_Info))
		{
			foreach($XMLRoot->PackageVD_Info as $info)
		 	{
		 		$id = intval($info->ID);
		 		if ($factory->hasObj($id)) {
		 			$LD = $factory->getObj($id);
		 			$LD->setLdInfo($info);
		 		}
		 		else
		 		{
		 			$LD = $this->getFactory()->createObj($id);
					$LD->setLdInfo($info);
		 		}
		 	}
		}
	}
}

class PackageVDConfigXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		if (isset($XMLRoot->PVD_Config))
		{
			foreach ($XMLRoot->PVD_Config as $ldConfig)
	 		{
	 			$id = intval($ldConfig->LDID);
		 		if ($factory->hasObj($id)) {
		 			$LD = $factory->getObj($id);
		 			$LD->setLdConfig($ldConfig);
		 		}
		 		else
		 		{
		 			$LD = $this->getFactory()->createObj($id);
					$LD->setLdConfig($ldConfig);
		 		}
	 		}
		}
	}
}

class LdInfoXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		if (isset($XMLRoot->LDInfo) && !empty($XMLRoot->LDInfo))
		{
			foreach($XMLRoot->LDInfo as $info)
		 	{
		 		$id = intval($info->ID);
		 		if ($factory->hasObj($id)) {
		 			$LD = $factory->getObj($id);
		 			$LD->setLdInfo($info);
		 		}
		 		else
		 		{
		 			$LD = $this->getFactory()->createObj($id);
					$LD->setLdInfo($info);
		 		}
		 	}
		}
	}
}

class LdConfigXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		if (isset($XMLRoot->LDConfig))
		{
			foreach ($XMLRoot->LDConfig as $ldConfig)
	 		{
	 			$id = intval($ldConfig->LDID);
		 		if ($factory->hasObj($id)) {
		 			$LD = $factory->getObj($id);
		 			$LD->setLdConfig($ldConfig);
		 		}
		 		else
		 		{
		 			$LD = $this->getFactory()->createObj($id);
					$LD->setLdConfig($ldConfig);
		 		}
	 		}
		}
	}
}

class LdStatusXmlHandler extends LdXmlHandler
{
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		if (isset($XMLRoot->Status)  && !empty($XMLRoot->Status))
		{
			foreach ($XMLRoot->Status as $ldStatus)
	 		{
	 			$id = intval($ldStatus->LDID);
		 		if ($factory->hasObj($id)) {
		 			$LD = $factory->getObj($id);
		 			$LD->setLdStatus($ldStatus);
		 		}
		 		else
		 		{
		 			$LD = $this->getFactory()->createObj($id);
					$LD->setLdStatus($ldStatus);
					//$factory->addObj($id, $LD);
		 		}
	 		}
		}
	}
}

class LdTargetXmlHandler extends LdXmlHandler
{
	const TargetLDID = "TargetLDID";
	public function handle($XMLRoot)
	{
		$factory = $this->getFactory();
		if (isset($XMLRoot->LDInfo) && !empty($XMLRoot->LDInfo))
		{
			$id = self::TargetLDID;
			if ($factory->hasObj($id)) {
				$TargetLD = $factory->getObj($id);
				$TargetLD->setLdInfo($info);
			}
			else 
			{
				foreach($XMLRoot->LDInfo as $info)
			 	{
			 			$TargetLD = $factory->createObj($id);
						$TargetLD->setLdInfo($info);
						break;
			 	}
			}			
		}
	}
}



?>