<?php

define('USERID','UserID');
define('LOCAL_LAUNCH_ID', 'FirstLaunch');

function getLoginUserName() {
    $user="Administrator";
    $retVal = -1;

    $XMLApiCmd = new XMLAPICommand();
    $XMLApiCmd->setCommand(XMLAPICommand::MV_GetUserName);
    if ($XMLApiCmd->issueCommand()) {
        $XMLRoot = $XMLApiCmd->getResult();
        $retVal = $XMLRoot->RetVal;
        if (intval($retVal) == 0) {
            if (strlen($XMLRoot->DomainName) ==0) {
                $user = $XMLRoot->UserName;
            }
            else {
                $user = $XMLRoot->DomainName . '\\' .$XMLRoot->UserName;
            }
        }
    }
    return $user;
}

function checkUserInSys($name, $domain, $passwd) {
    $XMLApiCmd = new XMLAPICommand();
    $XMLApiCmd->setCommand(XMLAPICommand::MV_LogonUser);
    $XMLApiCmd->setCommandPara("lpszUsername", $name);
    $XMLApiCmd->setCommandPara("lpszDomain", $domain);
    $XMLApiCmd->setCommandPara("lpszPassword", $passwd);

    $retVal = -1;
    if ($XMLApiCmd->issueCommand()) {
        $XMLRoot = $XMLApiCmd->getResult();
        $retVal = $XMLRoot->RetVal;
    }

    if (intval($retVal) == 0) {
        return true ;
    }

    return false;
}

function checkUserGroupInSys($name, $domain) {
	$_SESSION['isAdmin'] = 0;
	$XMLApiCmd = new XMLAPICommand();
	$XMLApiCmd->setCommand(XMLAPICommand::MV_GetUserGroup);
	$XMLApiCmd->setCommandPara("lpszUsername", $name);
	$XMLApiCmd->setCommandPara("lpszDomain", $domain);

	$retVal = -1;
	if ($XMLApiCmd->issueCommand()) {
		$XMLRoot = $XMLApiCmd->getResult();
		$retVal = $XMLRoot->RetVal;
	}

	if (intval($retVal) == 0) {
		if (!strcmp($XMLRoot->UserGroup,'Administrator')) {
			$_SESSION['isAdmin'] = 1;
		}
	}
}

function checkUserInXML($name, $domain, $remember) {
    $DA = new UserDataAccess();

    //in case computer name is changed
    //so it's commented
//	if (trim($domain) == "") {
//		$domain = getenv('COMPUTERNAME');
//	}

    $curUser = $DA->getUserByName($name, $domain);

    //for compability with previous versions
    if (! sizeof($curUser)) {
        if (trim($domain) == "" ) {
            $curUser = $DA->getUserByName($name, getenv('COMPUTERNAME'));
        }
        if (strcasecmp($domain, getenv('COMPUTERNAME')) == 0) {
            $curUser = $DA->getUserByName($name, "");
        }
    }

    if (strcasecmp($domain, getenv('COMPUTERNAME')) == 0) {
        $domain = "";
    }

    $user = new User();

    if (sizeof($curUser)) {
        $tmpArr = $curUser;
        $user = array_shift($tmpArr);
    }

    $user->setLoginName($name);
    $user->setDomain($domain);
    if ($_SESSION['isAdmin']) {
        $user->setAdmin();
    }
    else {
        $user->setGuest();
    }
    $userId = 0;
    if (sizeof($curUser)) {
        $userId = $user->getID();
        $DA->updateUserByID($userId, $user);
    } else {
        $userId = $DA->addUser($user);
        if (! $userId) {
            return false;
        }
        $user->setID($userId);
    }

    $_SESSION[USERID] = $userId;       //
    //setcooki isLogUser instead of USERID, 
    //for enter user ID and password every time when enter MSU in winndows.
     setcookie("isLogUser", 1 );
    //record the login status
    $_SESSION['loginName'] = $name;
    $_SESSION['domain'] = $domain;

    //set cookie if want to remember password
    if ($remember) {
        $value = setcookie(USERID,$userId ,time() + 3600 * 24 * 30);
    }

    return $userId;
}

function recordHTTPs($isHTTPs) {
    $_SESSION["isHTTPsLogin"] = $isHTTPs;
}

//login user
function loginUser($name,$domain,$passwd,$remember) {
    if (checkUserInSys($name, $domain, $passwd)) {
        checkUserGroupInSys($name, $domain);
    	$userId = checkUserInXML($name,$domain,$remember);
        //save local lunch id
        if(check_whether_from_local() && trim(getRequestPara(LOCAL_LAUNCH_ID)) != "") {
            setcookie(LOCAL_LAUNCH_ID,trim(getRequestPara(LOCAL_LAUNCH_ID)) . ';' .  $userId,time() + 3600 * 24 * 30);
        }

        return true;
    }

    return false;
}

//logout user from MRU
function logoutUser() {
    //clear login status
    $_SESSION[USERID] = null;
    $_COOKIE[USERID] = null;
    $_COOKIE["isLogUser"] = null;
    $_SESSION['domain'] = null;
    $_SESSION['isAdmin'] = null;
    $_SESSION['loginName'] = null;

    //clear cookie
    //setcookie(USERID,0,false,'/',false,0);
    setcookie(USERID,0,false);
    if(check_whether_from_local()) {
        setcookie(LOCAL_LAUNCH_ID,0,false);
    }
}

//check permisson
function checkAuthorizeValues() {
    $UserID = null;
    $isAdmin = 0;

    if (getSessionPara(USERID)) {
        $UserID = getSessionPara(USERID);
    } else if(getCookiePara(USERID)) {
        $UserID = getCookiePara(USERID);
        $_SESSION[USERID] = $UserID;
    } else if(check_whether_from_local() && isset($_COOKIE[LOCAL_LAUNCH_ID])) {
        //add more check for localhost
        //get user id
        $arr = explode(";", $_COOKIE[LOCAL_LAUNCH_ID]);
        if(sizeof($arr) > 1) {
            if(trim(getRequestPara(LOCAL_LAUNCH_ID)) != "") {
                if($arr[0] == trim(getRequestPara(LOCAL_LAUNCH_ID))) {
                    $UserID = $arr[1];
                    $_SESSION[USERID] = $UserID;
                } else {
                    //cookie be clear
                    setcookie(LOCAL_LAUNCH_ID,0,false);
                }
            }
        }
    }
    
    if(! isset($UserID)) {
        logoutUser();
        return;
    }

	if(check_whether_from_local())
	{
		return;
	}

    $dataAccess = new UserDataAccess();
    $users = $dataAccess->getUserByID($UserID);

    if ($users) {
        $user = array_shift($users);

        $domain = $user->getDomain();
        $loginName = $user->getLoginName();
        $isAdmin = $user->isAdmin();

        //won't check domain users
        if (strcasecmp($domain, getenv('COMPUTERNAME')) != 0 && trim($domain) !== "") {
            return;
        }

        //check whether the user exists
        $cmd = new XMLAPICommand();
        $cmd->setCommand(XMLAPICommand::MV_GetUserGroup);
        $cmd->setCommandPara("lpszUsername", $loginName);
        $cmd->setCommandPara("lpszDomain", $domain);
        $cmd->issueCommand();

        $changed = false;
        $deleted = false;
        if(strcmp($cmd->getResult()->UserGroup . "", "Administrator") == 0 && $isAdmin == false) {
            //user privilidge changed
            $isAdmin = true;
            $user->setAdmin();
            $changed = true;
        }else if(strcmp($cmd->getResult()->UserGroup . "", "ValidUser") == 0 && $isAdmin == true) {
            //user privilidge changed
            $isAdmin = false;
            $user->setGuest();
            $changed = true;
        }else if (strcmp($cmd->getResult()->UserGroup . "", "UnknownUser") == 0) {
            $deleted = true;
        }

        //update User
        if($changed) {
            $dataAccess->updateUserByLoginName($loginName, $domain,$user);
            $_SESSION['domain'] = $domain;
            $_SESSION['loginName'] = $loginName;
            $_SESSION['isAdmin'] = $user->isAdmin();
        }
        else if ($deleted) {
            $dataAccess->deleteUserByLoginName($loginName,$domain);
            logoutUser();
        }
        else {
            $_SESSION['domain'] = $domain;
            $_SESSION['loginName'] = $loginName;
            $_SESSION['isAdmin'] = $user->isAdmin();
        }
    }
    else {
        logoutUser();
    }
}

session_start();

checkAuthorizeValues();

//set login info to smarty template
$smarty->assign('domain',getSessionPara('domain'));
$smarty->assign('isAdmin',getSessionPara('isAdmin'));
$smarty->assign('curLoginName',getSessionPara('loginName'));
$smarty->assign(LOCAL_LAUNCH_ID, getRequestPara(LOCAL_LAUNCH_ID));

if (!getSessionPara('isAdmin')) {
    $smarty->assign('unauthorized','disabled="true"');
}

?>
