<?php
abstract class HdBase extends BaseFactory 
{
	protected function createObject()
	{
		return new HD();
	}
	
	public function toGetMBRInfo()
	{
		$handler = new HdMBRInfoXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetMBRInfo, $handler);
	}
	
	public function toGetMPStatus()
	{
		$handler = new HdMPStatusXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetMPStatus, $handler);
	}
	
	public function toGetHDInfo()
	{
		$handler = new HdInfoXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetHDInfo, $handler);
	}
	
	public function toGetValidSize()
	{
		$handler = new HdValidSizeXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetFreeSpaceInfo, $handler);
	}
	
	public function toGetHDRaidStatus()
	{
		$handler = new HdRaidStatusXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetHDRaidStatus, $handler);
	}
	
	public function toGetHdFreeInfo()
	{
		$blkList = new BlockList();
		$blkList->setAdapterID($this->getAdapterID());
		$blkList->toGetBlkInfo();
		foreach ($this->BaseClasses as $HD)
		{
			$HD->setFree();
			foreach ($blkList->getBaseClasses() as $blk)
			{
				if ($blk->getHDID() == $HD->getDeviceID()) {
					if ($blk->getFlag() != BlockFlag::VALID) {
						$HD->setNotFree();
						break;
					}
				}
			}
		}
	}
	
	public function toGetHdStatus()
	{
		$handler = new HdStatusXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetBGAStatus, $handler);
	}
	
	public function toGetConfig()
	{
		$handler = new HdConfigXmlHandler();
		$this->runCommand(XMLAPICommand::MV_PD_GetConfig, $handler);
	}
}

?>