<?php
class SSDAdapterList extends SSDAdapterBase {
    public function toGetSSDAdapterCount() {
        $XMLApiCmd = new XMLAPICommand();
        $XMLApiCmd->setCommand(XMLAPICommand::MV_SSD_AdapterCount);

        $this->XMLAPICommandList['setSSDAdapterCount'] = $XMLApiCmd;
    }

    public function toGetSSDAdapterInfo() {
        $XMLApiCmd = new XMLAPICommand();
        $XMLApiCmd->setCommand(XMLAPICommand::MV_SSD_AdapterInfo);
        $XMLApiCmd->setCommandPara("AdapterID",XMLAPICommand::ParaALL);

        $this->XMLAPICommandList['setSSDAdapterInfo'] = $XMLApiCmd;
    }

    protected function prepareAPICommands() {

    }

    protected function setSSDAdapterCount($data) {
        $XMLRoot = $data;

        if (isset($XMLRoot->RetVal)) {
            if (! $this->BaseClasses) {
                $count = intval($XMLRoot->RetVal);
                for ($i = 0;$i < $count ;$i++) {
                    $SSDAdapter = new SSDAdapter();
                    $SSDAdapter->setDeviceID($i);
                    $this->BaseClasses[] = $SSDAdapter;
                }
            }
        }
    }

    protected function setDataToBaseClass() {

    }

    public function loadTestData() {

    }
}
?>