<?php

header("Content-type: text/xml");//xml header

//no cache http header response
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Cache-control: private");
header("Pragma: no-cache");

//xml header
echo '<?xml version="1.0" encoding="UTF-8" ?>'; 

include_once("../phpsrc/include.php");

include_once("../phpsrc/authorization.php");
include_once("../phpsrc/action/UserAction.class.php");
include_once("../phpsrc/action/ActionOnDG.class.php");
include_once("../phpsrc/action/XMLRet.class.php");

$cmdName = getRequestPara("cmdName");
$noPermissionCheck = getRequestPara("noPermissionCheck");

$action = null;

//choose action to run
switch ($cmdName) {
    case APICmd::createPackageVD:
        include_once("../phpsrc/action/ActionCreatePackageVD.class.php");
        $action = new ActionCreatePackageVD();
        break;
    case APICmd::deletePackageVD:
        include_once("../phpsrc/action/ActionDeletePackageVD.class.php");
        $action = new ActionDeletePackageVD();
        break;
    case APICmd::savePackageVDConfig:
        include_once("../phpsrc/action/ActionSavePackageVDConfig.class.php");
        $action = new ActionSavePackageVDConfig();
        break;
    case APICmd::packageVDBgaControl:
        include_once("../phpsrc/action/ActionPackageVDBGAControl.class.php");
        $action = new ActionPackageVDBGAControl();
        break;
    case APICmd::initPackageVD:
        include_once("../phpsrc/action/ActionInitPackageVD.class.php");
        $action = new ActionInitPackageVD();
        break;
    case APICmd::checkPackageVD:
        include_once("../phpsrc/action/ActionCheckPackageVD.class.php");
        $action = new ActionCheckPackageVD();
        break;
    case APICmd::rebuildPackageVD:
        include_once("../phpsrc/action/ActionRebuildPackageVD.class.php");
        $action = new ActionRebuildPackageVD();
        break;
    case APICmd::migratePackageVD:
        include_once("../phpsrc/action/ActionMigratePackageVD.class.php");
        $action = new ActionMigratePackageVD();
        break;
    case APICmd::getMigratedPackageVDSize :
        include_once("../phpsrc/action/GetMigratedPackageVDSize.class.php");
        $action = new GetMigratedPackageVDSize();
        break;
    case APICmd::AcceleratorAuto:
        include_once("../phpsrc/action/ActionAcceleratorGroupBase.class.php");
        include_once("../phpsrc/action/ActionAcceleratorAuto.class.php");
        $action = new ActionAcceleratorAuto();
        break;
    case APICmd::hyperIntelligentInit:
        include_once("../phpsrc/action/ActionHyperIntelligentInit.class.php");
        $action = new ActionHyperIntelligentInit();
        break;
    case APICmd::rescanAdapter:
        include_once("../phpsrc/action/ActionRescanAdapter.class.php");
        $action = new ActionRescanAdapter();
        break;
    case APICmd::ssdAdapterLink:
        include_once("../phpsrc/action/ActionSSDAdapterLink.class.php");
        $action = new ActionSSDAdapterLink();
        break;
    case APICmd::ssdAdapterUnLink:
        include_once("../phpsrc/action/ActionSSDAdapterUnLink.class.php");
        $action = new ActionSSDAdapterUnLink();
        break;
    case APICmd::pdAESForceOnline:
        include_once("../phpsrc/action/ActionPDAESForceOnline.class.php");
        $action = new ActionPDAESForceOnline();
        break;
    case APICmd::aesPortMount:
        include_once("../phpsrc/action/ActionAESPortMount.class.php");
        $action = new ActionAESPortMount();
        break;
    case APICmd::aesPortDismount:
        include_once("../phpsrc/action/ActionAESPortDismount.class.php");
        $action = new ActionAESPortDismount();
        break;
    case APICmd::aesPortEnable:
        include_once("../phpsrc/action/ActionAESPortEnable.class.php");
        $action = new ActionAESPortEnable();
        break;
    case APICmd::aesEntryChangePWD:
        include_once("../phpsrc/action/ActionAESEntryChangePwd.class.php");
        $action = new ActionAESEntryChangePwd();
        break;
    case APICmd::aesEntryAddKey :
        include_once("../phpsrc/action/ActionAESEntryAddKey.class.php");
        $action = new ActionAESEntryAddKey();
        break;
    case APICmd::aesEntryRemoveKey :
        include_once("../phpsrc/action/ActionAESEntryRemoveKey.class.php");
        $action = new ActionAESEntryRemoveKey();
        break;
//    case APICmd::setAESKey:
//        include_once("../phpsrc/action/ActionAESSetKey.class.php");
//        $action = new ActionAESSetKey();
//        break;
//    case APICmd::enableAES :
//        include_once("../phpsrc/action/ActionAESEnable.class.php");
//        $action = new ActionAESEnable();
//        break;
//    case APICmd::clearAESKey :
//        include_once("../phpsrc/action/ActionAESClear.class.php");
//        $action = new ActionAESClear();
//        break;
//    case APICmd::safeRemoveAES :
//        include_once("../phpsrc/action/ActionAESSafeRemove.class.php");
//        $action = new ActionAESSafeRemove();
//        break;
//    case APICmd::getAESPrivilege :
//        include_once("../phpsrc/action/ActionAESGetPrivilege.class.php");
//        $action = new ActionAESGetPrivilege();
//        break;
    case APICmd::deleteHyperDuo:
        include_once("../phpsrc/action/ActionDeleteHyperDuo.class.php");
        $action = new ActionDeleteHyperDuo();
        break;
    case APICmd::UpdateAccVolFreeSize:
        include_once("../phpsrc/action/ActionUpdateAccVolFreeSize.class.php");
        $action = new ActionUpdateAccVolFreeSize();
        break;
    case APICmd::ssdAdapterCreate:
        include_once("../phpsrc/action/ActionSSDAdapterCreate.class.php");
        $action = new ActionSSDAdapterCreate();
        break;
    case APICmd::deleteHyperSSD:
        include_once("../phpsrc/action/ActionDeleteHyperSSD.class.php");
        $action = new ActionDeleteHyperSSD();
        break;
    case APICmd::calcSelectedAppSize:
        include_once("../phpsrc/action/CalculateSelectedAppSize.class.php");
        $action = new CalculateSelectedAppSize();
        break;
    case APICmd::addFileToGroup:
        include_once("../phpsrc/action/ActionAcceleratorGroupBase.class.php");
        include_once("../phpsrc/action/ActionAddFileToGroup.class.php");
        $action = new ActionAddFileToGroup();
        break;
    case APICmd::deleteFileFromApp:
        include_once("../phpsrc/action/ActionAcceleratorGroupBase.class.php");
        include_once("../phpsrc/action/ActionDeleteFileFromApp.class.php");
        $action = new ActionDeleteFileFromApp();
        break;
    case APICmd::deleteGroup:
        include_once("../phpsrc/action/ActionAcceleratorGroupBase.class.php");
        include_once("../phpsrc/action/ActionDeleteGroup.class.php");
        $action = new ActionDeleteGroup();
        break;
    case APICmd::saveCustomizeGroup:
        include_once("../phpsrc/action/ActionAcceleratorGroupBase.class.php");
        include_once("../phpsrc/action/ActionSaveCustomizeGroup.class.php");
        $action = new ActionSaveCustomizeGroup();
        break;
    case APICmd::doAcceleratorMaintain:
        include_once("../phpsrc/action/ActionAcceleratorMaintain.class.php");
        $action = new ActionAcceleratorMaintain();
        break;
    case APICmd::createHyperHDD:
        include_once("../phpsrc/action/ActionCreateHypperHDD.class.php");
        $action = new ActionCreateHypperHDD();
        break;
    case APICmd::getSSDCreateHypperMaxSize :
        include_once("../phpsrc/action/GetSSDCreateHypperMaxSize.class.php");
        $action = new GetSSDCreateHypperMaxSize();
        break;
    case APICmd::appPauseAccelerate :
        include_once("../phpsrc/action/ActionAppPauseAccelerate.class.php");
        $action = new ActionAppPauseAccelerate();
        break;
    case APICmd::appResumeAccelerate :
        include_once("../phpsrc/action/ActionAppResumeAccelerate.class.php");
        $action = new ActionAppResumeAccelerate();
        break;
    case APICmd::appStopAccelerate  :
        include_once("../phpsrc/action/ActionAppStopAccelerate.class.php");
        $action = new ActionAppStopAccelerate();
        break;
    case APICmd::getAcceleratorScanStatus:
        include_once("../phpsrc/action/GetAppScanStatus.class.php");
        $action = new GetAppScanStatus();
        break;
    case APICmd::appScan :
        include_once("../phpsrc/action/ActionAppScan.class.php");
        $action = new ActionAppScan();
        break;
    case APICmd::getAcceleratingStatus:
        include_once("../phpsrc/action/GetAcceleratingStatus.class.php");
        $action = new GetAcceleratingStatus();
        break;
    case APICmd::appAccelerate :
        include_once("../phpsrc/action/ActionAppAccelerate.class.php");
        $action = new ActionAppAccelerate();
        break;
    case APICmd::getSSDVolumeAllocation :
        include_once("../phpsrc/action/GetSSDVolumeAllocation.class.php");
        $action = new GetSSDVolumeAllocation();
        break;
    case APICmd::reportVD :
        include_once("../phpsrc/action/ActionReportVD.class.php");
        $action = new ActionReportVD();
        break;
    case APICmd::ssdCreateVolume :
        include_once("../phpsrc/action/ActionSSDCreateVolume.class.php");
        $action = new ActionSSDCreateVolume();
        break;
    case APICmd::getCurrentCreatePara :
        include_once("../phpsrc/action/GetCurrentCreatePara.class.php");
        $action = new GetCurrentCreatePara();
        break;
    case APICmd::getAllSSDStatus :
        include_once("../phpsrc/action/GetAllSSDStatus.class.php");
        $action = new GetAllSSDStatus();
        break;
    case APICmd::setSSDOpLevel:
        include_once("../phpsrc/action/ActionSetSSDOpLevel.class.php");
        $action = new ActionSetSSDOpLevel();
        break;
    case APICmd::flashBios:
        include_once("../phpsrc/action/ActionFlashBios.class.php");
        $action = new ActionFlashBios();
        break;
    case APICmd::ldondgbgaControl:
        include_once("../phpsrc/action/ActionLdOnDgBAGControl.class.php");
        $action = new ActionLdOnDgBAGControl();
        break;
    case APICmd::saveDgConfig:
        include_once("../phpsrc/action/ActionSaveDGConfig.class.php");
        $action = new ActionSaveDGConfig();
        break;
    case APICmd::createDGNext:
        include_once("../phpsrc/action/ActionCreateDG.class.php");
        $action = new ActionCreateDG();
        break;
    case APICmd::createDGSubmit:
        include_once("../phpsrc/action/ActionCreateDG.class.php");
        $action = new ActionCreateDG();
        break;
    case APICmd::deleteDG:
        include_once("../phpsrc/action/ActionDeleteDG.class.php");
        $action = new ActionDeleteDG();
        break;
    case APICmd::migrateDG:
        include_once("../phpsrc/action/ActionMigrateDG.class.php");
        $action = new ActionMigrateDG();
        break;
    case APICmd::rebuildDG:
        include_once("../phpsrc/action/ActionRebuildDG.class.php");
        $action = new ActionRebuildDG();
        break;
    case APICmd::saveDgConfig:
        include_once("../phpsrc/action/ActionSaveDGConfig.class.php");
        $action = new ActionSaveDGConfig();
        break;

    case APICmd::dgbgaControl:
        include_once("../phpsrc/action/ActionDgBGAControl.class.php");
        $action = new ActionDgBGAControl();
        break;

    case APICmd::createVdOnDg:
        include_once("../phpsrc/action/ActionCreateVdOnDg.class.php");
        $action = new ActionCreateVdOnDg();
        break;
    case APICmd::initVdOnDg :
        include_once("../phpsrc/action/ActionInitVdOndg.class.php");
        $action = new ActionInitVdOnDg();
        break;
    case APICmd::checkVdOnDg:
        include_once("../phpsrc/action/ActionCheckVdOnDg.class.php");
        $action = new ActionCheckVdOnDg();
        break;
    case APICmd::deleteVdOnDg:
        include_once("../phpsrc/action/ActionDeleteVdOnDg.class.php");
        $action = new ActionDeleteVdOnDg();
        break;
    case APICmd::saveVdOnDg:
        include_once("../phpsrc/action/ActionSaveVdOnDgConfig.class.php");
        $action = new ActionSaveVdOnDgConfig();
        break;

    case APICmd::initLD :
        include_once("../phpsrc/action/ActionInitLD.class.php");
        $action = new ActionInitLD();
        break;
    case APICmd::checkLD:
        include_once("../phpsrc/action/ActionCheckLD.class.php");
        $action = new ActionCheckLD();
        break;
    case APICmd::quickCreateDGVD:
        include_once("../phpsrc/action/ActionQuickCreateDG.class.php");
        $action = new ActionQuickCreateDG();
        break;
    case APICmd::quickCreateVD:
        include_once("../phpsrc/action/ActionQuickCreateVD.class.php");
        $action = new ActionQuickCreateVD();
        break;
    case APICmd::createLD:
        include_once("../phpsrc/action/ActionCreateLD.class.php");
        $action = new ActionCreateLD();
        break;
    case APICmd::deleteLD:
        include_once("../phpsrc/action/ActionDeleteLD.class.php");
        $action = new ActionDeleteLD();
        break;
    case APICmd::bgaControl:
        include_once("../phpsrc/action/ActionBGAControl.class.php");
        $action = new ActionBGAControl();
        break;
    case APICmd::migrateLD:
        include_once("../phpsrc/action/ActionMigrateLD.class.php");
        $action = new ActionMigrateLD();
        break;
    case APICmd::rebuildLD:
        include_once("../phpsrc/action/ActionRebuildLD.class.php");
        $action = new ActionRebuildLD();
        break;
    case APICmd::saveLDConfig:
        include_once("../phpsrc/action/ActionSaveLDConfig.class.php");
        $action = new ActionSaveLDConfig();
        break;
    case APICmd::importLD:
        include_once("../phpsrc/action/ActionImportLD.class.php");
        $action = new ActionImportLD();
        break;
    case APICmd::saveHDConfig:
        include_once("../phpsrc/action/ActionSaveHDConfig.class.php");
        $action = new ActionSaveHDConfig();
        break;
    case APICmd::setHDStatus:
        include_once("../phpsrc/action/ActionSetHdStatus.class.php");
        $action = new ActionSetHdStatus();
        break;
    case APICmd::saveLEDConfig:
        include_once("../phpsrc/action/ActionSaveLEDConfig.class.php");
        $action = new ActionSaveLEDConfig();
        break;
    case APICmd::saveENCElementConfig:
        include_once("../phpsrc/action/ActionSaveENCElementConfig.class.php");
        $action = new ActionSaveENCElementConfig();
        break;
    case APICmd::saveHBAConfig:
        include_once("../phpsrc/action/ActionSaveHBAConfig.class.php");
        $action = new ActionSaveHBAConfig();
        break;
    case APICmd::clearSP:
        include_once("../phpsrc/action/ActionClearSpare.class.php");
        $action = new ActionClearSpare();
        break;
    case APICmd::setGlobalSP:
        include_once("../phpsrc/action/ActionSetSpare.class.php");
        include_once("../phpsrc/action/ActionSetGlobalSpare.class.php");
        $action = new ActionSetGlobalSpare();
        break;
    case APICmd::setLDSP:
        include_once("../phpsrc/action/ActionSetLDSpare.class.php");
        $action = new ActionSetLDSpare();
        break;
    case APICmd::getEventGrid:
        include_once("../phpsrc/action/GetEventsInfo.class.php");
        $action = new GetEventsInfo();
        break;
    case APICmd::getMigratedLDSize :
        include_once("../phpsrc/action/GetMigratedLDSize.class.php");
        $action = new GetMigratedLDSize();
        break;
    case APICmd::getMigratedDgSize :
        include_once("../phpsrc/action/GetMigratedDgSize.class.php");
        $action = new GetMigratedDgSize();
        break;
    case APICmd::clearEvents :
        include_once("../phpsrc/action/ActionClearEvents.class.php");
        $action = new ActionClearEvents();
        break;
    case APICmd::testMailSetting :
        include_once("../phpsrc/action/ActionTestMailSetting.class.php");
        $action = new ActionTestMailSetting();
        break;
    case APICmd::testMacMailSetting :
        include_once("../phpsrc/action/ActionTestMacMailSetting.class.php");
        $action = new ActionTestMacMailSetting();
        break;
    case APICmd::mediaPatrolPD :
        include_once("../phpsrc/action/ActionMediaPatrolPD.class.php");
        $action = new ActionMediaPatrolPD();
        break;
    case APICmd::pdbgaControl :
        include_once("../phpsrc/action/ActionHdBgaControl.class.php");
        $action = new ActionHdBgaControl();
        break;
    case APICmd::dataScrubPd :
        include_once("../phpsrc/action/ActionDataScrubHd.class.php");
        $action = new ActionDataScrubHd();
        break;
    case APICmd::setDedicatedSP :
        include_once("../phpsrc/action/ActionSetSpare.class.php");
        include_once("../phpsrc/action/ActionSetDedicatedSpare.class.php");
        $action = new ActionSetDedicatedSpare();
        break;
    case APICmd::wipePD :
        include_once("../phpsrc/action/ActionWipePD.class.php");
        $action = new ActionWipePD();
        break;
    case APICmd::saveBBUConfig:
        include_once("../phpsrc/action/ActionSaveBBUConfig.class.php");
        $action = new ActionSaveBBUConfig();
        break;
    case APICmd::saveBBUSchedule:
        include_once("../phpsrc/action/ActionBBUSchedule.class.php");
        $action = new ActionBBUSchedule();
        break;
    case APICmd::muteAdapter:
        include_once("../phpsrc/action/ActionAdapterMute.class.php");
        $action = new ActionAdapterMute();
        break;
    default:
        break;
}

if ($action) {
    $action->smartyAssign($smarty);
    $action->displayResultXML($noPermissionCheck);
}
?>
