<?php
class ActionCreateHypperHDD extends UserAction
{
	private $RaidModes;
	private $SSDIDs;
	private $HDCount;
	private $SSDCount;
	private $HDIDs;
	private $AcceleratorSizes;
	private $waterMarks;
	private $KeepDatas;
	private $VDID;
	
	protected function validatePara()
	{
            //check the http request parameters
	}
        
	protected function initActionPara()
	{
		$this->SSDCount = getRequestPara("SSDCount");
		$this->HDCount = getRequestPara("HDCount");
		$this->RaidModes = getRequestPara("RaidModes");
		$this->SSDIDs = getRequestPara("SSDIDs");
		$this->HDIDs = getRequestPara("HDIDs");
		$this->AcceleratorSizes = getRequestPara("AccSizes");
		$this->waterMarks = getRequestPara("Watermarks");
		$this->KeepDatas = getRequestPara("KeepDatas");
	}

	private function getExistedVDs()
	{
		$oldVDs = new LdList();
		$oldVDs->setAdapterID($this->getAdapterID());
		$oldVDs->toGetLDInfo();
		
		$oldVDIDs = array();
		foreach ($oldVDs->getBaseClasses() as $vd)
		{
			$oldVDIDs[] = $vd->getID();
		}
		return $oldVDIDs;
	}
	
	private function getVDsAfterCreate()
	{
		$newVDs = new LdList();
		$newVDs->setAdapterID($this->getAdapterID());
		$newVDs->toGetLDInfo();
		
		$newVDIDs = array();
		foreach ($newVDs->getBaseClasses() as $vd)
		{
			$newVDIDs[] = $vd->getID();
		}
		return $newVDIDs;
	}
	
	private function doCreate()
	{
		include_once("../phpsrc/baseclass/LD.class.php");
		include_once("../phpsrc/baseclass/LdList.class.php");
		$oldVDIDs = $this->getExistedVDs();
		
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_HyperHDD_Create);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());

		$waterMarks = explode(" ",$this->waterMarks);
		$this->ApiCmd->setCommandPara("HyperWaterMark",trim($waterMarks[0]));
		$RaidModes = explode(" ",$this->RaidModes);
		$this->ApiCmd->setCommandPara("RaidMode",trim($RaidModes[0]));
		$this->ApiCmd->setCommandPara("SSDCount",$this->SSDCount);
		$this->ApiCmd->setCommandPara("SSDIDs",$this->SSDIDs);
		$this->ApiCmd->setCommandPara("HDIDs",$this->HDIDs);
		$this->ApiCmd->setCommandPara("Size","");

		$KeepDataTypes = explode(" ",$this->KeepDatas);
		$this->ApiCmd->setCommandPara("KeepData",trim($KeepDataTypes[0]));		
		$this->ApiCmd->setCommandPara("HDCount",$this->HDCount);
		//var_dump($this->ApiCmd);
		$this->ApiCmd->issueCommand();

		if (!$this->ApiCmd->getResult() ||$this->ApiCmd->getResult()->RetVal . "") {
			$this->setCreateFail();
		} else {
			$newVDIDs = $this->getVDsAfterCreate();
			
			$arr = array_diff($newVDIDs, $oldVDIDs);
			if ($arr) {
				$this->VDID = array_shift($arr);
			}
			
			$this->setCreateCmdXmlRetSuccess();
		}
	}
	
	private function setCreateCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		//$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::LdListPage ;
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
			."?Target=" . Target::getIndependentVDPage . "&ID=" . $this->VDID . "&HBAID=" . $this->getAdapterID();
	}
	
	private function setCreateFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->getAdapterID() ;
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	protected function doAction()
	{
		$this->doCreate();
	}
}
?>